/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.api.metatileentity.MetaTileEntity;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public abstract class MTETrait {
    private static final Object2IntFunction<String> traitIds = new Object2IntOpenHashMap();
    private static int rollingNetworkId = 0;
    protected final MetaTileEntity metaTileEntity;
    private final int networkId;

    public MTETrait(@Nonnull MetaTileEntity metaTileEntity) {
        this.metaTileEntity = metaTileEntity;
        metaTileEntity.addMetaTileEntityTrait(this);
        String traitName = this.getName();
        this.networkId = !traitIds.containsKey((Object)traitName) ? traitIds.put((Object)traitName, rollingNetworkId++) : traitIds.getInt((Object)traitName);
    }

    @Nonnull
    public MetaTileEntity getMetaTileEntity() {
        return this.metaTileEntity;
    }

    @Nonnull
    public abstract String getName();

    public final int getNetworkID() {
        return this.networkId;
    }

    public abstract <T> T getCapability(Capability<T> var1);

    public void onFrontFacingSet(EnumFacing newFrontFacing) {
    }

    public void update() {
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(@Nonnull NBTTagCompound compound) {
    }

    public void writeInitialData(@Nonnull PacketBuffer buffer) {
    }

    public void receiveInitialData(@Nonnull PacketBuffer buffer) {
    }

    public void receiveCustomData(int id, @Nonnull PacketBuffer buffer) {
    }

    public final void writeCustomData(int id, @Nonnull Consumer<PacketBuffer> writer) {
        this.metaTileEntity.writeTraitData(this, id, writer);
    }
}

