/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pattern;

import gregtech.api.GregTechAPI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.BlockWorldState;
import gregtech.api.pattern.PatternError;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.RelativeDirection;
import gregtech.common.blocks.MetaBlocks;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class BlockPattern {
    static EnumFacing[] FACINGS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.UP, EnumFacing.DOWN};
    public final int[][] aisleRepetitions;
    public final RelativeDirection[] structureDir;
    protected final TraceabilityPredicate[][][] blockMatches;
    protected final int fingerLength;
    protected final int thumbLength;
    protected final int palmLength;
    protected final BlockWorldState worldState = new BlockWorldState();
    protected final PatternMatchContext matchContext = new PatternMatchContext();
    protected final Map<TraceabilityPredicate.SimplePredicate, Integer> globalCount;
    protected final Map<TraceabilityPredicate.SimplePredicate, Integer> layerCount;
    public Long2ObjectMap<BlockInfo> cache = new Long2ObjectOpenHashMap();
    private int[] centerOffset = null;

    public BlockPattern(TraceabilityPredicate[][][] predicatesIn, RelativeDirection[] structureDir, int[][] aisleRepetitions) {
        this.blockMatches = predicatesIn;
        this.globalCount = new HashMap<TraceabilityPredicate.SimplePredicate, Integer>();
        this.layerCount = new HashMap<TraceabilityPredicate.SimplePredicate, Integer>();
        this.fingerLength = predicatesIn.length;
        this.structureDir = structureDir;
        this.aisleRepetitions = aisleRepetitions;
        if (this.fingerLength > 0) {
            this.thumbLength = predicatesIn[0].length;
            this.palmLength = this.thumbLength > 0 ? predicatesIn[0][0].length : 0;
        } else {
            this.thumbLength = 0;
            this.palmLength = 0;
        }
        this.initializeCenterOffsets();
    }

    private void initializeCenterOffsets() {
        block0: for (int x = 0; x < this.palmLength; ++x) {
            for (int y = 0; y < this.thumbLength; ++y) {
                int minZ = 0;
                int maxZ = 0;
                for (int z = 0; z < this.fingerLength; ++z) {
                    TraceabilityPredicate predicate = this.blockMatches[z][y][x];
                    if (predicate.isCenter) {
                        this.centerOffset = new int[]{x, y, z, minZ, maxZ};
                        break block0;
                    }
                    minZ += this.aisleRepetitions[z][0];
                    maxZ += this.aisleRepetitions[z][1];
                }
            }
        }
        if (this.centerOffset == null) {
            throw new IllegalArgumentException("Didn't find center predicate");
        }
    }

    public PatternError getError() {
        return this.worldState.error;
    }

    public PatternMatchContext checkPatternFastAt(World world, BlockPos centerPos, EnumFacing facing) {
        if (!this.cache.isEmpty()) {
            boolean pass = true;
            for (Map.Entry entry : this.cache.entrySet()) {
                TileEntity tileEntity;
                BlockPos pos = BlockPos.func_177969_a((long)((Long)entry.getKey()));
                IBlockState blockState = world.func_180495_p(pos);
                if (blockState != ((BlockInfo)entry.getValue()).getBlockState()) {
                    pass = false;
                    break;
                }
                TileEntity cachedTileEntity = ((BlockInfo)entry.getValue()).getTileEntity();
                if (cachedTileEntity == null || (tileEntity = world.func_175625_s(pos)) == cachedTileEntity) continue;
                pass = false;
                break;
            }
            if (pass) {
                return this.worldState.hasError() ? null : this.matchContext;
            }
        }
        return this.checkPatternAt(world, centerPos, facing);
    }

    public void clearCache() {
        this.cache.clear();
    }

    private PatternMatchContext checkPatternAt(World world, BlockPos centerPos, EnumFacing facing) {
        boolean findFirstAisle = false;
        int minZ = -this.centerOffset[4];
        this.matchContext.reset();
        this.globalCount.clear();
        this.layerCount.clear();
        this.cache.clear();
        int z = minZ++;
        for (int c = 0; c < this.fingerLength; ++c) {
            int r = 0;
            while (findFirstAisle ? r < this.aisleRepetitions[c][1] : z <= -this.centerOffset[3]) {
                block16: {
                    this.layerCount.clear();
                    int b = 0;
                    int y = -this.centerOffset[1];
                    while (b < this.thumbLength) {
                        int a = 0;
                        int x = -this.centerOffset[0];
                        while (a < this.palmLength) {
                            TraceabilityPredicate predicate = this.blockMatches[c][b][a];
                            BlockPos pos = this.setActualRelativeOffset(x, y, z, facing).func_177982_a(centerPos.func_177958_n(), centerPos.func_177956_o(), centerPos.func_177952_p());
                            this.worldState.update(world, pos, this.matchContext, this.globalCount, this.layerCount, predicate);
                            TileEntity tileEntity = this.worldState.getTileEntity();
                            if (predicate != TraceabilityPredicate.ANY) {
                                if (tileEntity instanceof IGregTechTileEntity) {
                                    if (((IGregTechTileEntity)tileEntity).isValid()) {
                                        this.cache.put(pos.func_177986_g(), (Object)new BlockInfo(this.worldState.getBlockState(), tileEntity, predicate));
                                    } else {
                                        this.cache.put(pos.func_177986_g(), (Object)new BlockInfo(this.worldState.getBlockState(), null, predicate));
                                    }
                                } else {
                                    this.cache.put(pos.func_177986_g(), (Object)new BlockInfo(this.worldState.getBlockState(), tileEntity, predicate));
                                }
                            }
                            if (!predicate.test(this.worldState)) {
                                if (findFirstAisle) {
                                    if (r < this.aisleRepetitions[c][0]) {
                                        c = 0;
                                        r = 0;
                                        z = minZ++;
                                        this.matchContext.reset();
                                        findFirstAisle = false;
                                    }
                                } else {
                                    ++z;
                                }
                                break block16;
                            }
                            ++a;
                            ++x;
                        }
                        ++b;
                        ++y;
                    }
                    findFirstAisle = true;
                    ++z;
                    for (Map.Entry<TraceabilityPredicate.SimplePredicate, Integer> entry : this.layerCount.entrySet()) {
                        if (entry.getValue() >= entry.getKey().minLayerCount) continue;
                        this.worldState.setError(new TraceabilityPredicate.SinglePredicateError(entry.getKey(), 3));
                        return null;
                    }
                }
                ++r;
            }
            if (r >= this.aisleRepetitions[c][0]) continue;
            if (!this.worldState.hasError()) {
                this.worldState.setError(new PatternError());
            }
            return null;
        }
        for (Map.Entry<TraceabilityPredicate.SimplePredicate, Integer> entry : this.globalCount.entrySet()) {
            if (entry.getValue() >= entry.getKey().minGlobalCount) continue;
            this.worldState.setError(new TraceabilityPredicate.SinglePredicateError(entry.getKey(), 1));
            return null;
        }
        this.worldState.setError(null);
        return this.matchContext;
    }

    public void autoBuild(EntityPlayer player, MultiblockControllerBase controllerBase) {
        World world = player.field_70170_p;
        BlockWorldState worldState = new BlockWorldState();
        int minZ = -this.centerOffset[4];
        EnumFacing facing = controllerBase.getFrontFacing().func_176734_d();
        BlockPos centerPos = controllerBase.getPos();
        HashMap<TraceabilityPredicate.SimplePredicate, BlockInfo[]> cacheInfos = new HashMap<TraceabilityPredicate.SimplePredicate, BlockInfo[]>();
        HashMap<TraceabilityPredicate.SimplePredicate, Integer> cacheGlobal = new HashMap<TraceabilityPredicate.SimplePredicate, Integer>();
        HashMap<BlockPos, Object> blocks = new HashMap<BlockPos, Object>();
        blocks.put(controllerBase.getPos(), controllerBase);
        int z = minZ++;
        for (int c = 0; c < this.fingerLength; ++c) {
            for (int r = 0; r < this.aisleRepetitions[c][0]; ++r) {
                HashMap<TraceabilityPredicate.SimplePredicate, Integer> cacheLayer = new HashMap<TraceabilityPredicate.SimplePredicate, Integer>();
                int b = 0;
                int y = -this.centerOffset[1];
                while (b < this.thumbLength) {
                    int a = 0;
                    int x = -this.centerOffset[0];
                    while (a < this.palmLength) {
                        block31: {
                            MetaTileEntity sampleMetaTileEntity;
                            ItemStack found;
                            BlockPos pos2;
                            block33: {
                                List candidates;
                                block32: {
                                    TraceabilityPredicate predicate;
                                    block30: {
                                        predicate = this.blockMatches[c][b][a];
                                        pos2 = this.setActualRelativeOffset(x, y, z, facing).func_177982_a(centerPos.func_177958_n(), centerPos.func_177956_o(), centerPos.func_177952_p());
                                        worldState.update(world, pos2, this.matchContext, this.globalCount, this.layerCount, predicate);
                                        if (world.func_180495_p(pos2).func_185904_a().func_76222_j()) break block30;
                                        blocks.put(pos2, world.func_180495_p(pos2));
                                        for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                                            limit.testLimited(worldState);
                                        }
                                        break block31;
                                    }
                                    boolean find = false;
                                    Object[] infos = new BlockInfo[]{};
                                    for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                                        if (limit.minLayerCount <= 0) continue;
                                        if (!cacheLayer.containsKey(limit)) {
                                            cacheLayer.put(limit, 1);
                                        } else {
                                            if ((Integer)cacheLayer.get(limit) >= limit.minLayerCount || limit.maxLayerCount != -1 && (Integer)cacheLayer.get(limit) >= limit.maxLayerCount) continue;
                                            cacheLayer.put(limit, (Integer)cacheLayer.get(limit) + 1);
                                        }
                                        if (!cacheInfos.containsKey(limit)) {
                                            cacheInfos.put(limit, limit.candidates == null ? null : limit.candidates.get());
                                        }
                                        infos = (BlockInfo[])cacheInfos.get(limit);
                                        find = true;
                                        break;
                                    }
                                    if (!find) {
                                        for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                                            if (limit.minGlobalCount <= 0) continue;
                                            if (!cacheGlobal.containsKey(limit)) {
                                                cacheGlobal.put(limit, 1);
                                            } else {
                                                if ((Integer)cacheGlobal.get(limit) >= limit.minGlobalCount || limit.maxGlobalCount != -1 && (Integer)cacheGlobal.get(limit) >= limit.maxGlobalCount) continue;
                                                cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                            }
                                            if (!cacheInfos.containsKey(limit)) {
                                                cacheInfos.put(limit, limit.candidates == null ? null : limit.candidates.get());
                                            }
                                            infos = (BlockInfo[])cacheInfos.get(limit);
                                            find = true;
                                            break;
                                        }
                                    }
                                    if (!find) {
                                        for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                                            if (limit.maxLayerCount != -1 && cacheLayer.getOrDefault(limit, Integer.MAX_VALUE) == limit.maxLayerCount || limit.maxGlobalCount != -1 && cacheGlobal.getOrDefault(limit, Integer.MAX_VALUE) == limit.maxGlobalCount) continue;
                                            if (!cacheInfos.containsKey(limit)) {
                                                cacheInfos.put(limit, limit.candidates == null ? null : limit.candidates.get());
                                            }
                                            if (cacheLayer.containsKey(limit)) {
                                                cacheLayer.put(limit, (Integer)cacheLayer.get(limit) + 1);
                                            } else {
                                                cacheLayer.put(limit, 1);
                                            }
                                            if (cacheGlobal.containsKey(limit)) {
                                                cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                            } else {
                                                cacheGlobal.put(limit, 1);
                                            }
                                            infos = (BlockInfo[])ArrayUtils.addAll((Object[])infos, (Object[])((Object[])cacheInfos.get(limit)));
                                        }
                                        for (TraceabilityPredicate.SimplePredicate common : predicate.common) {
                                            if (!cacheInfos.containsKey(common)) {
                                                cacheInfos.put(common, common.candidates == null ? null : common.candidates.get());
                                            }
                                            infos = (BlockInfo[])ArrayUtils.addAll((Object[])infos, (Object[])((Object[])cacheInfos.get(common)));
                                        }
                                    }
                                    if ((candidates = Arrays.stream(infos).filter(info -> info.getBlockState().func_177230_c() != Blocks.field_150350_a).map(info -> {
                                        MetaTileEntity metaTileEntity;
                                        IBlockState blockState = info.getBlockState();
                                        MetaTileEntity metaTileEntity2 = metaTileEntity = info.getTileEntity() instanceof IGregTechTileEntity ? ((IGregTechTileEntity)info.getTileEntity()).getMetaTileEntity() : null;
                                        if (metaTileEntity != null) {
                                            return metaTileEntity.getStackForm();
                                        }
                                        return new ItemStack(Item.func_150898_a((Block)blockState.func_177230_c()), 1, blockState.func_177230_c().func_180651_a(blockState));
                                    }).collect(Collectors.toList())).isEmpty()) break block31;
                                    found = null;
                                    if (player.func_184812_l_()) break block32;
                                    for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                                        if (!candidates.stream().anyMatch(candidate -> candidate.func_77969_a(itemStack)) || itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemBlock)) continue;
                                        found = itemStack.func_77946_l();
                                        itemStack.func_190920_e(itemStack.func_190916_E() - 1);
                                        break;
                                    }
                                    if (found != null) break block33;
                                    break block31;
                                }
                                for (int i = candidates.size() - 1; i >= 0 && ((found = ((ItemStack)candidates.get(i)).func_77946_l()).func_190926_b() || !(found.func_77973_b() instanceof ItemBlock)); --i) {
                                    found = null;
                                }
                                if (found == null) break block31;
                            }
                            ItemBlock itemBlock = (ItemBlock)found.func_77973_b();
                            IBlockState state = itemBlock.func_179223_d().func_176203_a(itemBlock.func_77647_b(found.func_77960_j()));
                            blocks.put(pos2, state);
                            world.func_175656_a(pos2, state);
                            TileEntity holder = world.func_175625_s(pos2);
                            if (holder instanceof IGregTechTileEntity && (sampleMetaTileEntity = GregTechAPI.MTE_REGISTRY.getObjectById(found.func_77952_i())) != null) {
                                MetaTileEntity metaTileEntity = ((IGregTechTileEntity)holder).setMetaTileEntity(sampleMetaTileEntity);
                                metaTileEntity.onPlacement();
                                blocks.put(pos2, metaTileEntity);
                                if (found.func_77978_p() != null) {
                                    metaTileEntity.initFromItemStackData(found.func_77978_p());
                                }
                            }
                        }
                        ++a;
                        ++x;
                    }
                    ++b;
                    ++y;
                }
                ++z;
            }
        }
        EnumFacing[] facings = (EnumFacing[])ArrayUtils.addAll((Object[])new EnumFacing[]{controllerBase.getFrontFacing()}, (Object[])FACINGS);
        blocks.forEach((pos, block) -> {
            if (block instanceof MetaTileEntity) {
                MetaTileEntity metaTileEntity = (MetaTileEntity)block;
                boolean find = false;
                for (EnumFacing enumFacing : facings) {
                    if (!metaTileEntity.isValidFrontFacing(enumFacing) || blocks.containsKey(pos.func_177972_a(enumFacing))) continue;
                    metaTileEntity.setFrontFacing(enumFacing);
                    find = true;
                    break;
                }
                if (!find) {
                    for (EnumFacing enumFacing : FACINGS) {
                        if (!world.func_175623_d(pos.func_177972_a(enumFacing)) || !metaTileEntity.isValidFrontFacing(enumFacing)) continue;
                        metaTileEntity.setFrontFacing(enumFacing);
                        break;
                    }
                }
            }
        });
    }

    public BlockInfo[][][] getPreview(int[] repetition) {
        HashMap<TraceabilityPredicate.SimplePredicate, BlockInfo[]> cacheInfos = new HashMap<TraceabilityPredicate.SimplePredicate, BlockInfo[]>();
        HashMap<TraceabilityPredicate.SimplePredicate, Integer> cacheGlobal = new HashMap<TraceabilityPredicate.SimplePredicate, Integer>();
        HashMap<BlockPos, BlockInfo> blocks = new HashMap<BlockPos, BlockInfo>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int x = 0;
        for (int l = 0; l < this.fingerLength; ++l) {
            for (int r = 0; r < repetition[l]; ++r) {
                HashMap<TraceabilityPredicate.SimplePredicate, Integer> cacheLayer = new HashMap<TraceabilityPredicate.SimplePredicate, Integer>();
                for (int y = 0; y < this.thumbLength; ++y) {
                    for (int z = 0; z < this.palmLength; ++z) {
                        TraceabilityPredicate predicate = this.blockMatches[l][y][z];
                        boolean find = false;
                        BlockInfo[] infos = null;
                        for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                            if (limit.minLayerCount <= 0) continue;
                            if (!cacheLayer.containsKey(limit)) {
                                cacheLayer.put(limit, 1);
                            } else {
                                if ((Integer)cacheLayer.get(limit) >= limit.minLayerCount) continue;
                                cacheLayer.put(limit, (Integer)cacheLayer.get(limit) + 1);
                            }
                            if (cacheGlobal.getOrDefault(limit, 0) < limit.previewCount) {
                                if (!cacheGlobal.containsKey(limit)) {
                                    cacheGlobal.put(limit, 1);
                                } else {
                                    if ((Integer)cacheGlobal.get(limit) >= limit.previewCount) continue;
                                    cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                }
                            }
                            if (!cacheInfos.containsKey(limit)) {
                                cacheInfos.put(limit, limit.candidates == null ? null : limit.candidates.get());
                            }
                            infos = (BlockInfo[])cacheInfos.get(limit);
                            find = true;
                            break;
                        }
                        if (!find) {
                            for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                                if (limit.minGlobalCount == -1 && limit.previewCount == -1) continue;
                                if (cacheGlobal.getOrDefault(limit, 0) < limit.previewCount) {
                                    if (!cacheGlobal.containsKey(limit)) {
                                        cacheGlobal.put(limit, 1);
                                    } else {
                                        if ((Integer)cacheGlobal.get(limit) >= limit.previewCount) continue;
                                        cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                    }
                                } else {
                                    if (limit.minGlobalCount <= 0) continue;
                                    if (!cacheGlobal.containsKey(limit)) {
                                        cacheGlobal.put(limit, 1);
                                    } else {
                                        if ((Integer)cacheGlobal.get(limit) >= limit.minGlobalCount) continue;
                                        cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                    }
                                }
                                if (!cacheInfos.containsKey(limit)) {
                                    cacheInfos.put(limit, limit.candidates == null ? null : limit.candidates.get());
                                }
                                infos = (BlockInfo[])cacheInfos.get(limit);
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (TraceabilityPredicate.SimplePredicate common : predicate.common) {
                                if (common.previewCount <= 0) continue;
                                if (!cacheGlobal.containsKey(common)) {
                                    cacheGlobal.put(common, 1);
                                } else {
                                    if ((Integer)cacheGlobal.get(common) >= common.previewCount) continue;
                                    cacheGlobal.put(common, (Integer)cacheGlobal.get(common) + 1);
                                }
                                if (!cacheInfos.containsKey(common)) {
                                    cacheInfos.put(common, common.candidates == null ? null : common.candidates.get());
                                }
                                infos = (BlockInfo[])cacheInfos.get(common);
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (TraceabilityPredicate.SimplePredicate common : predicate.common) {
                                if (common.previewCount != -1) continue;
                                if (!cacheInfos.containsKey(common)) {
                                    cacheInfos.put(common, common.candidates == null ? null : common.candidates.get());
                                }
                                infos = (BlockInfo[])cacheInfos.get(common);
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                                if (limit.previewCount != -1) continue;
                                if (limit.maxGlobalCount != -1 || limit.maxLayerCount != -1) {
                                    if (cacheGlobal.getOrDefault(limit, 0) < limit.maxGlobalCount) {
                                        if (!cacheGlobal.containsKey(limit)) {
                                            cacheGlobal.put(limit, 1);
                                        } else {
                                            cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                        }
                                    } else {
                                        if (cacheLayer.getOrDefault(limit, 0) >= limit.maxLayerCount) continue;
                                        if (!cacheLayer.containsKey(limit)) {
                                            cacheLayer.put(limit, 1);
                                        } else {
                                            cacheLayer.put(limit, (Integer)cacheLayer.get(limit) + 1);
                                        }
                                    }
                                }
                                if (!cacheInfos.containsKey(limit)) {
                                    cacheInfos.put(limit, limit.candidates == null ? null : limit.candidates.get());
                                }
                                infos = (BlockInfo[])cacheInfos.get(limit);
                                break;
                            }
                        }
                        BlockInfo info2 = infos == null || infos.length == 0 ? BlockInfo.EMPTY : infos[0];
                        BlockPos pos2 = this.setActualRelativeOffset(z, y, x, EnumFacing.NORTH);
                        if (info2.getTileEntity() instanceof MetaTileEntityHolder) {
                            MetaTileEntityHolder holder = new MetaTileEntityHolder();
                            holder.setMetaTileEntity(((MetaTileEntityHolder)info2.getTileEntity()).getMetaTileEntity());
                            holder.getMetaTileEntity().onPlacement();
                            info2 = new BlockInfo(MetaBlocks.MACHINE.func_176223_P(), holder);
                        }
                        blocks.put(pos2, info2);
                        minX = Math.min(pos2.func_177958_n(), minX);
                        minY = Math.min(pos2.func_177956_o(), minY);
                        minZ = Math.min(pos2.func_177952_p(), minZ);
                        maxX = Math.max(pos2.func_177958_n(), maxX);
                        maxY = Math.max(pos2.func_177956_o(), maxY);
                        maxZ = Math.max(pos2.func_177952_p(), maxZ);
                    }
                }
                ++x;
            }
        }
        BlockInfo[][][] result = (BlockInfo[][][])Array.newInstance(BlockInfo.class, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
        int finalMinX = minX;
        int finalMinY = minY;
        int finalMinZ = minZ;
        blocks.forEach((pos, info) -> {
            if (info.getTileEntity() instanceof MetaTileEntityHolder) {
                MetaTileEntity metaTileEntity = ((MetaTileEntityHolder)info.getTileEntity()).getMetaTileEntity();
                boolean find = false;
                for (EnumFacing enumFacing : FACINGS) {
                    if (!metaTileEntity.isValidFrontFacing(enumFacing) || blocks.containsKey(pos.func_177972_a(enumFacing))) continue;
                    metaTileEntity.setFrontFacing(enumFacing);
                    find = true;
                    break;
                }
                if (!find) {
                    for (EnumFacing enumFacing : FACINGS) {
                        BlockInfo blockInfo = (BlockInfo)blocks.get(pos.func_177972_a(enumFacing));
                        if (blockInfo == null || blockInfo.getBlockState().func_177230_c() != Blocks.field_150350_a || !metaTileEntity.isValidFrontFacing(enumFacing)) continue;
                        metaTileEntity.setFrontFacing(enumFacing);
                        break;
                    }
                }
            }
            result[pos.func_177958_n() - finalMinX][pos.func_177956_o() - finalMinY][pos.func_177952_p() - finalMinZ] = info;
        });
        return result;
    }

    private BlockPos setActualRelativeOffset(int x, int y, int z, EnumFacing facing) {
        int[] c0 = new int[]{x, y, z};
        int[] c1 = new int[3];
        block8: for (int i = 0; i < 3; ++i) {
            switch (this.structureDir[i].getActualFacing(facing)) {
                case UP: {
                    c1[1] = c0[i];
                    continue block8;
                }
                case DOWN: {
                    c1[1] = -c0[i];
                    continue block8;
                }
                case WEST: {
                    c1[0] = -c0[i];
                    continue block8;
                }
                case EAST: {
                    c1[0] = c0[i];
                    continue block8;
                }
                case NORTH: {
                    c1[2] = -c0[i];
                    continue block8;
                }
                case SOUTH: {
                    c1[2] = c0[i];
                }
            }
        }
        return new BlockPos(c1[0], c1[1], c1[2]);
    }
}

