/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet;

import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public abstract class WorldPipeNet<NodeDataType, T extends PipeNet<NodeDataType>>
extends WorldSavedData {
    private WeakReference<World> worldRef = new WeakReference<Object>(null);
    protected List<T> pipeNets = new ArrayList<T>();
    protected final Map<ChunkPos, List<T>> pipeNetsByChunk = new HashMap<ChunkPos, List<T>>();

    public WorldPipeNet(String name) {
        super(name);
    }

    public World getWorld() {
        return (World)this.worldRef.get();
    }

    protected void setWorldAndInit(World world) {
        if (world != this.worldRef.get()) {
            this.worldRef = new WeakReference<World>(world);
            this.onWorldSet();
        }
    }

    public static String getDataID(String baseID, World world) {
        if (world == null || world.field_72995_K) {
            throw new RuntimeException("WorldPipeNet should only be created on the server!");
        }
        int dimension = world.field_73011_w.getDimension();
        return dimension == 0 ? baseID : baseID + '.' + dimension;
    }

    protected void onWorldSet() {
        this.pipeNets.forEach(PipeNet::onNodeConnectionsUpdate);
    }

    public void addNode(BlockPos nodePos, NodeDataType nodeData, int mark, int openConnections, boolean isActive) {
        PipeNet<Object> myPipeNet = null;
        Node<NodeDataType> node = new Node<NodeDataType>(nodeData, openConnections, mark, isActive);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Node secondNode;
            BlockPos offsetPos = nodePos.func_177972_a(facing);
            T pipeNet = this.getNetFromPos(offsetPos);
            Node node2 = secondNode = pipeNet == null ? null : ((PipeNet)pipeNet).getAllNodes().get(offsetPos);
            if (pipeNet == null || !((PipeNet)pipeNet).canAttachNode(nodeData) || !((PipeNet)pipeNet).canNodesConnect(secondNode, facing.func_176734_d(), node, null)) continue;
            if (myPipeNet == null) {
                myPipeNet = pipeNet;
                myPipeNet.addNode(nodePos, node);
                continue;
            }
            if (myPipeNet == pipeNet) continue;
            myPipeNet.uniteNetworks((PipeNet<Object>)pipeNet);
        }
        if (myPipeNet == null) {
            myPipeNet = (PipeNet<Object>)this.createNetInstance();
            myPipeNet.addNode(nodePos, node);
            this.addPipeNet(myPipeNet);
            this.func_76185_a();
        }
    }

    protected void addPipeNetToChunk(ChunkPos chunkPos, T pipeNet) {
        this.pipeNetsByChunk.computeIfAbsent(chunkPos, any -> new ArrayList()).add(pipeNet);
    }

    protected void removePipeNetFromChunk(ChunkPos chunkPos, T pipeNet) {
        List<T> list = this.pipeNetsByChunk.get(chunkPos);
        if (list != null) {
            list.remove(pipeNet);
            if (list.isEmpty()) {
                this.pipeNetsByChunk.remove(chunkPos);
            }
        }
    }

    public void removeNode(BlockPos nodePos) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).removeNode(nodePos);
        }
    }

    public void updateBlockedConnections(BlockPos nodePos, EnumFacing side, boolean isBlocked) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).updateBlockedConnections(nodePos, side, isBlocked);
            ((PipeNet)pipeNet).onPipeConnectionsUpdate();
        }
    }

    public void updateMark(BlockPos nodePos, int newMark) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).updateMark(nodePos, newMark);
        }
    }

    public T getNetFromPos(BlockPos blockPos) {
        List pipeNetsInChunk = this.pipeNetsByChunk.getOrDefault(new ChunkPos(blockPos), Collections.emptyList());
        for (PipeNet pipeNet : pipeNetsInChunk) {
            if (!pipeNet.containsNode(blockPos)) continue;
            return (T)pipeNet;
        }
        return null;
    }

    protected void addPipeNet(T pipeNet) {
        this.addPipeNetSilently(pipeNet);
    }

    protected void addPipeNetSilently(T pipeNet) {
        this.pipeNets.add(pipeNet);
        ((PipeNet)pipeNet).getContainedChunks().forEach(chunkPos -> this.addPipeNetToChunk((ChunkPos)chunkPos, pipeNet));
        ((PipeNet)pipeNet).isValid = true;
    }

    protected void removePipeNet(T pipeNet) {
        this.pipeNets.remove(pipeNet);
        ((PipeNet)pipeNet).getContainedChunks().forEach(chunkPos -> this.removePipeNetFromChunk((ChunkPos)chunkPos, pipeNet));
        ((PipeNet)pipeNet).isValid = false;
    }

    protected abstract T createNetInstance();

    public void func_76184_a(NBTTagCompound nbt) {
        this.pipeNets = new ArrayList<T>();
        NBTTagList allEnergyNets = nbt.func_150295_c("PipeNets", 10);
        for (int i = 0; i < allEnergyNets.func_74745_c(); ++i) {
            NBTTagCompound pNetTag = allEnergyNets.func_150305_b(i);
            T pipeNet = this.createNetInstance();
            ((PipeNet)pipeNet).deserializeNBT(pNetTag);
            this.addPipeNetSilently(pipeNet);
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        NBTTagList allPipeNets = new NBTTagList();
        for (PipeNet pipeNet : this.pipeNets) {
            NBTTagCompound pNetTag = pipeNet.serializeNBT();
            allPipeNets.func_74742_a((NBTBase)pNetTag);
        }
        compound.func_74782_a("PipeNets", (NBTBase)allPipeNets);
        return compound;
    }
}

