/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.block.material;

import gregtech.api.GregTechAPI;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.material.IMaterialPipeTile;
import gregtech.api.pipenet.block.material.IMaterialPipeType;
import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public abstract class BlockMaterialPipe<PipeType extends Enum<PipeType> & IMaterialPipeType<NodeDataType>, NodeDataType, WorldPipeNetType extends WorldPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends BlockPipe<PipeType, NodeDataType, WorldPipeNetType> {
    protected final PipeType pipeType;

    public BlockMaterialPipe(PipeType pipeType) {
        this.pipeType = pipeType;
    }

    @Override
    public NodeDataType createProperties(IPipeTile<PipeType, NodeDataType> pipeTile) {
        PipeType pipeType = pipeTile.getPipeType();
        Material material = ((IMaterialPipeTile)pipeTile).getPipeMaterial();
        if (pipeType == null || material == null) {
            return this.getFallbackType();
        }
        return this.createProperties(pipeType, material);
    }

    @Override
    public NodeDataType createItemProperties(ItemStack itemStack) {
        Material material = BlockMaterialPipe.getItemMaterial(itemStack);
        if (this.pipeType == null || material == null) {
            return this.getFallbackType();
        }
        return this.createProperties(this.pipeType, material);
    }

    public ItemStack getItem(Material material) {
        if (material == null) {
            return ItemStack.field_190927_a;
        }
        int materialId = GregTechAPI.MATERIAL_REGISTRY.getIDForObject(material);
        return new ItemStack((Block)this, 1, materialId);
    }

    public static Material getItemMaterial(ItemStack itemStack) {
        return (Material)GregTechAPI.MATERIAL_REGISTRY.getObjectById(itemStack.func_77960_j());
    }

    @Override
    public void setTileEntityData(TileEntityPipeBase<PipeType, NodeDataType> pipeTile, ItemStack itemStack) {
        ((TileEntityMaterialPipeBase)pipeTile).setPipeData(this, this.pipeType, BlockMaterialPipe.getItemMaterial(itemStack));
    }

    @Override
    public ItemStack getDropItem(IPipeTile<PipeType, NodeDataType> pipeTile) {
        Material material = ((IMaterialPipeTile)pipeTile).getPipeMaterial();
        return this.getItem(material);
    }

    protected abstract NodeDataType createProperties(PipeType var1, Material var2);

    public OrePrefix getPrefix() {
        return ((IMaterialPipeType)this.pipeType).getOrePrefix();
    }

    @Override
    public PipeType getItemPipeType(ItemStack is) {
        return this.pipeType;
    }
}

