/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.tile;

import com.google.common.base.Preconditions;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverIO;
import gregtech.api.cover.ICoverable;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.core.advancement.AdvancementTriggers;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class PipeCoverableImplementation
implements ICoverable {
    private final IPipeTile<?, ?> holder;
    private final CoverBehavior[] coverBehaviors = new CoverBehavior[6];
    private final int[] sidedRedstoneInput = new int[6];

    public PipeCoverableImplementation(IPipeTile<?, ?> holder) {
        this.holder = holder;
    }

    public void transferDataTo(PipeCoverableImplementation destImpl) {
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior behavior = this.coverBehaviors[coverSide.func_176745_a()];
            if (behavior == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            behavior.writeToNBT(tagCompound);
            CoverBehavior newBehavior = behavior.getCoverDefinition().createCoverBehavior(destImpl, coverSide);
            newBehavior.readFromNBT(tagCompound);
            destImpl.coverBehaviors[coverSide.func_176745_a()] = newBehavior;
        }
    }

    @Override
    public final boolean placeCoverOnSide(EnumFacing side, ItemStack itemStack, CoverDefinition coverDefinition, EntityPlayer player) {
        Preconditions.checkNotNull((Object)side, (Object)"side");
        Preconditions.checkNotNull((Object)coverDefinition, (Object)"coverDefinition");
        CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(this, side);
        if (!this.canPlaceCoverOnSide(side) || !coverBehavior.canAttach()) {
            return false;
        }
        boolean requiresTicking = coverBehavior instanceof ITickable;
        if (requiresTicking && !this.holder.supportsTicking()) {
            IPipeTile<?, ?> newHolderTile = this.holder.setSupportsTicking();
            return newHolderTile.getCoverableImplementation().placeCoverOnSide(side, itemStack, coverDefinition, player);
        }
        if (this.coverBehaviors[side.func_176745_a()] != null) {
            this.removeCover(side);
        }
        this.coverBehaviors[side.func_176745_a()] = coverBehavior;
        coverBehavior.onAttached(itemStack, player);
        this.writeCustomData(1, CoverIO.getCoverPlacementCustomDataWriter(side, coverBehavior));
        if (coverBehavior.shouldAutoConnect()) {
            this.holder.setConnection(side, true, false);
        }
        this.holder.notifyBlockUpdate();
        this.holder.markAsDirty();
        AdvancementTriggers.FIRST_COVER_PLACE.trigger((EntityPlayerMP)player);
        return true;
    }

    @Override
    public final boolean removeCover(EnumFacing side) {
        Preconditions.checkNotNull((Object)side, (Object)"side");
        CoverBehavior coverBehavior = this.getCoverAtSide(side);
        if (coverBehavior == null) {
            return false;
        }
        List<ItemStack> drops = coverBehavior.getDrops();
        coverBehavior.onRemoved();
        this.coverBehaviors[side.func_176745_a()] = null;
        for (ItemStack dropStack : drops) {
            Block.func_180635_a((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)dropStack);
        }
        this.writeCustomData(2, buffer -> buffer.writeByte(side.func_176745_a()));
        if (coverBehavior.shouldAutoConnect()) {
            this.holder.setConnection(side, false, false);
        }
        this.holder.notifyBlockUpdate();
        this.holder.markAsDirty();
        return true;
    }

    public final void dropAllCovers() {
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = this.coverBehaviors[coverSide.func_176745_a()];
            if (coverBehavior == null) continue;
            List<ItemStack> drops = coverBehavior.getDrops();
            coverBehavior.onRemoved();
            for (ItemStack dropStack : drops) {
                Block.func_180635_a((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)dropStack);
            }
        }
    }

    @Override
    public ItemStack getStackForm() {
        BlockPipe<?, ?, ?> pipeBlock = this.holder.getPipeBlock();
        return pipeBlock.getDropItem(this.holder);
    }

    public void onLoad() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.sidedRedstoneInput[side.func_176745_a()] = GTUtility.getRedstonePower(this.getWorld(), this.getPos(), side);
        }
    }

    @Override
    public final int getInputRedstoneSignal(EnumFacing side, boolean ignoreCover) {
        if (!ignoreCover && this.getCoverAtSide(side) != null) {
            return 0;
        }
        return this.sidedRedstoneInput[side.func_176745_a()];
    }

    public void updateInputRedstoneSignals() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int currentValue;
            int redstoneValue = GTUtility.getRedstonePower(this.getWorld(), this.getPos(), side);
            if (redstoneValue == (currentValue = this.sidedRedstoneInput[side.func_176745_a()])) continue;
            this.sidedRedstoneInput[side.func_176745_a()] = redstoneValue;
            CoverBehavior coverBehavior = this.getCoverAtSide(side);
            if (coverBehavior == null) continue;
            coverBehavior.onRedstoneInputSignalChange(redstoneValue);
        }
    }

    @Override
    public void notifyBlockUpdate() {
        this.holder.notifyBlockUpdate();
    }

    @Override
    public void scheduleRenderUpdate() {
        BlockPos pos = this.getPos();
        this.getWorld().func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    @Override
    public double getCoverPlateThickness() {
        float thickness = ((IPipeType)this.holder.getPipeType()).getThickness();
        if (thickness >= 1.0f) {
            return 0.0;
        }
        return Math.min(0.0625, (1.0 - (double)thickness) / 2.0);
    }

    @Override
    public int getPaintingColorForRendering() {
        return ConfigHolder.client.defaultPaintingColor;
    }

    @Override
    public boolean shouldRenderBackSide() {
        return false;
    }

    @Override
    public CoverBehavior getCoverAtSide(EnumFacing side) {
        return side == null ? null : this.coverBehaviors[side.func_176745_a()];
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        return this.holder.canPlaceCoverOnSide(side);
    }

    public boolean canConnectRedstone(@Nullable EnumFacing side) {
        if (side == null) {
            return this.canConnectRedstone(EnumFacing.UP) || this.canConnectRedstone(EnumFacing.DOWN);
        }
        CoverBehavior behavior = this.getCoverAtSide(side);
        return behavior != null && behavior.canConnectRedstone();
    }

    public int getOutputRedstoneSignal(@Nullable EnumFacing side) {
        if (side == null) {
            return this.getHighestOutputRedstoneSignal();
        }
        CoverBehavior behavior = this.getCoverAtSide(side);
        return behavior == null ? 0 : behavior.getRedstoneSignalOutput();
    }

    public int getHighestOutputRedstoneSignal() {
        int highestSignal = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            CoverBehavior behavior = this.getCoverAtSide(side);
            highestSignal = Math.max(highestSignal, behavior.getRedstoneSignalOutput());
        }
        return highestSignal;
    }

    public void update() {
        if (!this.getWorld().field_72995_K) {
            for (CoverBehavior coverBehavior : this.coverBehaviors) {
                if (!(coverBehavior instanceof ITickable)) continue;
                ((ITickable)coverBehavior).func_73660_a();
            }
        }
    }

    @Override
    public void writeCoverData(CoverBehavior behavior, int id, Consumer<PacketBuffer> writer) {
        this.writeCustomData(0, buffer -> {
            buffer.writeByte(behavior.attachedSide.func_176745_a());
            buffer.func_150787_b(id);
            writer.accept((PacketBuffer)buffer);
        });
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        CoverIO.writeCoverSyncData(buf, this);
    }

    public void readInitialSyncData(PacketBuffer buf) {
        CoverIO.receiveCoverSyncData(buf, this, (side, cover) -> {
            this.coverBehaviors[side.func_176745_a()] = cover;
        });
    }

    public void writeCustomData(int dataId, Consumer<PacketBuffer> writer) {
        this.holder.writeCoverCustomData(dataId, writer);
    }

    public void readCustomData(int dataId, PacketBuffer buf) {
        if (dataId == 1) {
            CoverIO.readCoverPlacement(buf, this, (s, cover) -> {
                this.coverBehaviors[s.func_176745_a()] = cover;
            }, this.holder::scheduleChunkForRenderUpdate);
        } else if (dataId == 2) {
            EnumFacing placementSide = EnumFacing.field_82609_l[buf.readByte()];
            this.coverBehaviors[placementSide.func_176745_a()] = null;
            this.holder.scheduleChunkForRenderUpdate();
        } else if (dataId == 0) {
            EnumFacing coverSide = EnumFacing.field_82609_l[buf.readByte()];
            CoverBehavior coverBehavior = this.getCoverAtSide(coverSide);
            int internalId = buf.func_150792_a();
            if (coverBehavior != null) {
                coverBehavior.readUpdateData(internalId, buf);
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        CoverIO.writeCoverNBT(data, side -> this.coverBehaviors[side.func_176745_a()]);
    }

    public void readFromNBT(NBTTagCompound data) {
        CoverIO.readCoverNBT(data, this, (side, cover) -> {
            this.coverBehaviors[side.func_176745_a()] = cover;
        });
    }

    @Override
    public World getWorld() {
        return this.holder.getPipeWorld();
    }

    @Override
    public BlockPos getPos() {
        return this.holder.getPipePos();
    }

    @Override
    public long getOffsetTimer() {
        return this.holder.getTickTimer();
    }

    @Override
    public void markDirty() {
        this.holder.markAsDirty();
    }

    @Override
    public boolean isValid() {
        return this.holder.isValidTile();
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        return this.holder.getCapabilityInternal(capability, side);
    }
}

