/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.common.items.MetaItems;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidCellInput
extends GTRecipeItemInput {
    final Fluid fluid;

    public FluidCellInput(Fluid fluid) {
        super(FluidCellInput.getFilledCell(fluid));
        this.fluid = fluid;
    }

    public static ItemStack getFilledCell(Fluid fluid, int count) {
        ItemStack fluidCell = MetaItems.FLUID_CELL.getStackForm().func_77946_l();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidCell.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandlerItem == null) {
            throw new IllegalStateException("Could not get FluidHandlerItem capability for the fluid cell.");
        }
        fluidHandlerItem.fill(new FluidStack(fluid, 1000), true);
        fluidCell = fluidHandlerItem.getContainer();
        fluidCell.func_190920_e(count);
        return fluidCell;
    }

    public static ItemStack getFilledCell(Fluid fluid) {
        return FluidCellInput.getFilledCell(fluid, 1);
    }

    @Override
    public boolean acceptsStack(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        IFluidHandlerItem stackFluid = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        FluidStack drained = stackFluid == null ? null : stackFluid.getTankProperties()[0].getContents();
        return MetaItems.FLUID_CELL.isItemEqual(itemStack) && drained != null && drained.getFluid() == this.fluid && drained.amount == 1000;
    }
}

