/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import crafttweaker.annotations.ZenRegister;
import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.CircuitAssemblerRecipeBuilder;
import gregtech.api.recipes.builders.FuelRecipeBuilder;
import gregtech.api.recipes.builders.FusionRecipeBuilder;
import gregtech.api.recipes.builders.GasCollectorRecipeBuilder;
import gregtech.api.recipes.builders.ImplosionRecipeBuilder;
import gregtech.api.recipes.builders.PrimitiveRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.builders.UniversalDistillationRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.machines.RecipeMapAssemblyLine;
import gregtech.api.recipes.machines.RecipeMapCokeOven;
import gregtech.api.recipes.machines.RecipeMapCrackerUnit;
import gregtech.api.recipes.machines.RecipeMapDistillationTower;
import gregtech.api.recipes.machines.RecipeMapFluidCanner;
import gregtech.api.recipes.machines.RecipeMapFormingPress;
import gregtech.api.recipes.machines.RecipeMapFurnace;
import gregtech.api.unification.material.Materials;
import gregtech.core.sound.GTSoundEvents;
import net.minecraft.init.SoundEvents;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.recipe.RecipeMaps")
@ZenRegister
public class RecipeMaps {
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ALLOY_SMELTER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("alloy_smelter", 2, 1, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.FURNACE_OVERLAY_1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.FURNACE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ARC_FURNACE_RECIPES = new RecipeMap<SimpleRecipeBuilder>("arc_furnace", 1, 4, 1, 1, new SimpleRecipeBuilder(), false).setProgressBar(GuiTextures.PROGRESS_BAR_ARC_FURNACE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ARC).onRecipeBuild(recipeBuilder -> {
        recipeBuilder.invalidateOnBuildAction();
        if (recipeBuilder.getFluidInputs().isEmpty()) {
            recipeBuilder.fluidInputs(Materials.Oxygen.getFluid(recipeBuilder.duration));
        }
    });
    @ZenProperty
    public static final RecipeMap<AssemblerRecipeBuilder> ASSEMBLER_RECIPES = new RecipeMap<AssemblerRecipeBuilder>("assembler", 9, 1, 1, 0, new AssemblerRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CIRCUIT, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ASSEMBLER).onRecipeBuild(recipeBuilder -> {
        recipeBuilder.invalidateOnBuildAction();
        if (recipeBuilder.fluidInputs.size() == 1 && recipeBuilder.fluidInputs.get(0).getInputFluidStack().getFluid() == Materials.SolderingAlloy.getFluid()) {
            int amount = recipeBuilder.fluidInputs.get((int)0).getInputFluidStack().amount;
            ((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)recipeBuilder.copy()).clearFluidInputs()).fluidInputs(Materials.Tin.getFluid(amount * 2))).buildAndRegister();
        }
    });
    @ZenProperty
    public static final RecipeMapAssemblyLine<SimpleRecipeBuilder> ASSEMBLY_LINE_RECIPES = (RecipeMapAssemblyLine)new RecipeMapAssemblyLine<SimpleRecipeBuilder>("assembly_line", 16, false, 1, false, 4, false, 0, false, new SimpleRecipeBuilder(), false).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ASSEMBLER);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> AUTOCLAVE_RECIPES = new RecipeMap<SimpleRecipeBuilder>("autoclave", 2, 2, 1, 1, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, GuiTextures.CRYSTAL_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CRYSTALLIZATION, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.FURNACE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> BENDER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("bender", 2, 1, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, false, GuiTextures.BENDER_OVERLAY).setSlotOverlay(false, false, true, GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_BENDING, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.MOTOR);
    @ZenProperty
    public static final RecipeMap<BlastRecipeBuilder> BLAST_RECIPES = new RecipeMap<BlastRecipeBuilder>("electric_blast_furnace", 3, 3, 1, 1, new BlastRecipeBuilder(), false).setSound(GTSoundEvents.FURNACE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> BREWING_RECIPES = new RecipeMap("brewery", 1, 0, 1, 1, ((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(128)).EUt(4), false).setSlotOverlay(false, false, GuiTextures.BREWER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.CHEMICAL_REACTOR);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CANNER_RECIPES = new RecipeMapFluidCanner("canner", 2, 2, 1, 1, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, false, GuiTextures.CANNER_OVERLAY).setSlotOverlay(false, false, true, GuiTextures.CANISTER_OVERLAY).setSlotOverlay(true, false, GuiTextures.CANISTER_OVERLAY).setSlotOverlay(false, true, GuiTextures.DARK_CANISTER_OVERLAY).setSlotOverlay(true, true, GuiTextures.DARK_CANISTER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CANNER, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.BATH);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CENTRIFUGE_RECIPES = new RecipeMap("centrifuge", 2, 6, 1, 6, new SimpleRecipeBuilder().EUt(5), false).setSlotOverlay(false, false, false, GuiTextures.EXTRACTOR_OVERLAY).setSlotOverlay(false, false, true, GuiTextures.CANISTER_OVERLAY).setSlotOverlay(false, true, true, GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.CENTRIFUGE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CHEMICAL_BATH_RECIPES = new RecipeMap<SimpleRecipeBuilder>("chemical_bath", 1, 6, 1, 1, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, true, GuiTextures.BREWER_OVERLAY).setSlotOverlay(true, false, false, GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, true, GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MIXER, ProgressWidget.MoveType.CIRCULAR).setSound(GTSoundEvents.BATH);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CHEMICAL_RECIPES = new RecipeMap("chemical_reactor", 2, 2, 3, 2, new SimpleRecipeBuilder().EUt(GTValues.VA[1]), false).setSlotOverlay(false, false, false, GuiTextures.MOLECULAR_OVERLAY_1).setSlotOverlay(false, false, true, GuiTextures.MOLECULAR_OVERLAY_2).setSlotOverlay(false, true, false, GuiTextures.MOLECULAR_OVERLAY_3).setSlotOverlay(false, true, true, GuiTextures.MOLECULAR_OVERLAY_4).setSlotOverlay(true, false, GuiTextures.VIAL_OVERLAY_1).setSlotOverlay(true, true, GuiTextures.VIAL_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTValues.FOOLS.get() != false ? GTSoundEvents.SCIENCE : GTSoundEvents.CHEMICAL_REACTOR).onRecipeBuild(recipeBuilder -> {
        recipeBuilder.invalidateOnBuildAction();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)LARGE_CHEMICAL_RECIPES.recipeBuilder().inputs(recipeBuilder.getInputs().toArray(new GTRecipeInput[0]))).fluidInputs(recipeBuilder.getFluidInputs())).outputs(recipeBuilder.getOutputs())).chancedOutputs(recipeBuilder.getChancedOutputs())).fluidOutputs(recipeBuilder.getFluidOutputs())).cleanroom(recipeBuilder.getCleanroom())).duration(recipeBuilder.duration)).EUt(recipeBuilder.EUt)).buildAndRegister();
    });
    @ZenProperty
    public static final RecipeMap<CircuitAssemblerRecipeBuilder> CIRCUIT_ASSEMBLER_RECIPES = new RecipeMap<CircuitAssemblerRecipeBuilder>("circuit_assembler", 6, 1, 1, 0, new CircuitAssemblerRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CIRCUIT_ASSEMBLER, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ASSEMBLER).onRecipeBuild(recipeBuilder -> {
        recipeBuilder.invalidateOnBuildAction();
        if (recipeBuilder.getFluidInputs().isEmpty()) {
            ((RecipeBuilder)((RecipeBuilder)recipeBuilder.copy()).fluidInputs(Materials.SolderingAlloy.getFluid(Math.max(1, 72 * ((CircuitAssemblerRecipeBuilder)recipeBuilder).getSolderMultiplier())))).buildAndRegister();
            recipeBuilder.fluidInputs(Materials.Tin.getFluid(Math.max(1, 144 * ((CircuitAssemblerRecipeBuilder)recipeBuilder).getSolderMultiplier())));
        }
    });
    @ZenProperty
    public static final RecipeMap<PrimitiveRecipeBuilder> COKE_OVEN_RECIPES = new RecipeMapCokeOven<PrimitiveRecipeBuilder>("coke_oven", 1, false, 1, false, 0, false, 1, false, new PrimitiveRecipeBuilder(), false).setSound(GTSoundEvents.FIRE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> COMPRESSOR_RECIPES = new RecipeMap("compressor", 1, 1, 0, 0, ((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(200)).EUt(2), false).setSlotOverlay(false, false, GuiTextures.COMPRESSOR_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_COMPRESS, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.COMPRESSOR);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CRACKING_RECIPES = new RecipeMapCrackerUnit<SimpleRecipeBuilder>("cracker", 1, false, 0, true, 2, false, 2, true, new SimpleRecipeBuilder(), false).setSlotOverlay(false, true, GuiTextures.CRACKING_OVERLAY_1).setSlotOverlay(true, true, GuiTextures.CRACKING_OVERLAY_2).setSlotOverlay(false, false, GuiTextures.CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CRACKING, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.FIRE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> CUTTER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("cutter", 1, 2, 1, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.SAWBLADE_OVERLAY).setSlotOverlay(true, false, false, GuiTextures.CUTTER_OVERLAY).setSlotOverlay(true, false, true, GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_SLICE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.CUT).onRecipeBuild(recipeBuilder -> {
        recipeBuilder.invalidateOnBuildAction();
        if (recipeBuilder.getFluidInputs().isEmpty()) {
            ((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)recipeBuilder.copy()).fluidInputs(Materials.Water.getFluid(Math.max(4, Math.min(1000, recipeBuilder.duration * recipeBuilder.EUt / 320))))).duration(recipeBuilder.duration * 2)).buildAndRegister();
            ((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)recipeBuilder.copy()).fluidInputs(Materials.DistilledWater.getFluid(Math.max(3, Math.min(750, recipeBuilder.duration * recipeBuilder.EUt / 426))))).duration((int)((double)recipeBuilder.duration * 1.5))).buildAndRegister();
            ((RecipeBuilder)recipeBuilder.fluidInputs(Materials.Lubricant.getFluid(Math.max(1, Math.min(250, recipeBuilder.duration * recipeBuilder.EUt / 1280))))).duration(Math.max(1, recipeBuilder.duration));
        }
    });
    @ZenProperty
    public static final RecipeMap<UniversalDistillationRecipeBuilder> DISTILLATION_RECIPES = new RecipeMapDistillationTower("distillation_tower", 0, true, 1, true, 1, true, 12, false, new UniversalDistillationRecipeBuilder(), false).setSound(GTSoundEvents.CHEMICAL_REACTOR);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> DISTILLERY_RECIPES = new RecipeMap<SimpleRecipeBuilder>("distillery", 1, 1, 1, 1, new SimpleRecipeBuilder(), false).setSlotOverlay(false, true, GuiTextures.BEAKER_OVERLAY_1).setSlotOverlay(true, true, GuiTextures.BEAKER_OVERLAY_4).setSlotOverlay(true, false, GuiTextures.DUST_OVERLAY).setSlotOverlay(false, false, GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.BOILER);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ELECTROLYZER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("electrolyzer", 2, 6, 1, 6, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, false, GuiTextures.LIGHTNING_OVERLAY_1).setSlotOverlay(false, false, true, GuiTextures.CANISTER_OVERLAY).setSlotOverlay(false, true, true, GuiTextures.LIGHTNING_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ELECTROLYZER);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ELECTROMAGNETIC_SEPARATOR_RECIPES = new RecipeMap<SimpleRecipeBuilder>("electromagnetic_separator", 1, 3, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MAGNET, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ARC);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> EXTRACTOR_RECIPES = new RecipeMap("extractor", 1, 1, 0, 1, ((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(400)).EUt(2), false).setSlotOverlay(false, false, GuiTextures.EXTRACTOR_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.COMPRESSOR);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> EXTRUDER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("extruder", 2, 1, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, true, GuiTextures.MOLD_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRUDER, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ARC);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FERMENTING_RECIPES = new RecipeMap("fermenter", 1, 1, 1, 1, new SimpleRecipeBuilder().EUt(2), false).setSlotOverlay(false, false, true, GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, true, GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.CHEMICAL_REACTOR);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FLUID_HEATER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("fluid_heater", 1, 0, 1, 1, new SimpleRecipeBuilder(), false).setSlotOverlay(false, true, GuiTextures.HEATING_OVERLAY_1).setSlotOverlay(true, true, GuiTextures.HEATING_OVERLAY_2).setSlotOverlay(false, false, GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.BOILER);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FLUID_SOLIDFICATION_RECIPES = new RecipeMap<SimpleRecipeBuilder>("fluid_solidifier", 1, 1, 1, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.SOLIDIFIER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.COOLING);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FORGE_HAMMER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("forge_hammer", 1, 1, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.HAMMER_OVERLAY).setSpecialTexture(78, 42, 20, 6, GuiTextures.PROGRESS_BAR_HAMMER_BASE).setProgressBar(GuiTextures.PROGRESS_BAR_HAMMER, ProgressWidget.MoveType.VERTICAL_DOWNWARDS).setSound(GTSoundEvents.FORGE_HAMMER);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FORMING_PRESS_RECIPES = new RecipeMapFormingPress("forming_press", 6, 1, 0, 0, new SimpleRecipeBuilder(), false).setProgressBar(GuiTextures.PROGRESS_BAR_COMPRESS, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.COMPRESSOR);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> FURNACE_RECIPES = new RecipeMapFurnace("electric_furnace", 1, 1, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.FURNACE_OVERLAY_1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.FURNACE);
    @ZenProperty
    public static final RecipeMap<FusionRecipeBuilder> FUSION_RECIPES = new RecipeMap<FusionRecipeBuilder>("fusion_reactor", 0, 0, 2, 1, new FusionRecipeBuilder(), false).setProgressBar(GuiTextures.PROGRESS_BAR_FUSION, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ARC);
    @ZenProperty
    public static final RecipeMap<GasCollectorRecipeBuilder> GAS_COLLECTOR_RECIPES = new RecipeMap<GasCollectorRecipeBuilder>("gas_collector", 1, 0, 0, 1, new GasCollectorRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.INT_CIRCUIT_OVERLAY).setSlotOverlay(true, true, GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.COOLING);
    @ZenProperty
    public static final RecipeMap<ImplosionRecipeBuilder> IMPLOSION_RECIPES = new RecipeMap("implosion_compressor", 3, 2, 0, 0, ((ImplosionRecipeBuilder)new ImplosionRecipeBuilder().duration(20)).EUt(GTValues.VA[1]), false).setSlotOverlay(false, false, true, GuiTextures.IMPLOSION_OVERLAY_1).setSlotOverlay(false, false, false, GuiTextures.IMPLOSION_OVERLAY_2).setSlotOverlay(true, false, true, GuiTextures.DUST_OVERLAY).setSound(SoundEvents.field_187539_bB);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> LARGE_CHEMICAL_RECIPES = new RecipeMap("large_chemical_reactor", 3, 3, 5, 4, new SimpleRecipeBuilder().EUt(GTValues.VA[1]), false).setSlotOverlay(false, false, false, GuiTextures.MOLECULAR_OVERLAY_1).setSlotOverlay(false, false, true, GuiTextures.MOLECULAR_OVERLAY_2).setSlotOverlay(false, true, false, GuiTextures.MOLECULAR_OVERLAY_3).setSlotOverlay(false, true, true, GuiTextures.MOLECULAR_OVERLAY_4).setSlotOverlay(true, false, GuiTextures.VIAL_OVERLAY_1).setSlotOverlay(true, true, GuiTextures.VIAL_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.CHEMICAL_REACTOR).setSmallRecipeMap(CHEMICAL_RECIPES);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> LASER_ENGRAVER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("laser_engraver", 2, 1, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, true, GuiTextures.LENS_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ELECTROLYZER);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> LATHE_RECIPES = new RecipeMap<SimpleRecipeBuilder>("lathe", 1, 2, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.PIPE_OVERLAY_1).setSlotOverlay(true, false, false, GuiTextures.PIPE_OVERLAY_2).setSlotOverlay(true, false, true, GuiTextures.DUST_OVERLAY).setSpecialTexture(98, 24, 5, 18, GuiTextures.PROGRESS_BAR_LATHE_BASE).setProgressBar(GuiTextures.PROGRESS_BAR_LATHE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.CUT);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> MACERATOR_RECIPES = new RecipeMap("macerator", 1, 4, 0, 0, ((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(150)).EUt(2), false).setSlotOverlay(false, false, GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MACERATE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.MACERATOR);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> MASS_FABRICATOR_RECIPES = new RecipeMap<SimpleRecipeBuilder>("mass_fabricator", 1, 0, 1, 2, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.ATOMIC_OVERLAY_1).setSlotOverlay(false, true, GuiTextures.ATOMIC_OVERLAY_2).setSlotOverlay(true, true, GuiTextures.POSITIVE_MATTER_OVERLAY).setSlotOverlay(true, true, true, GuiTextures.NEUTRAL_MATTER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MASS_FAB, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.REPLICATOR);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> MIXER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("mixer", 6, 1, 2, 1, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MIXER, ProgressWidget.MoveType.CIRCULAR).setSound(GTSoundEvents.MIXER);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ORE_WASHER_RECIPES = new RecipeMap("ore_washer", 2, 3, 1, 0, ((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(400)).EUt(16), false).setSlotOverlay(false, false, GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_BATH, ProgressWidget.MoveType.CIRCULAR).setSound(GTSoundEvents.BATH);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> PACKER_RECIPES = new RecipeMap("packer", 2, 2, 0, 0, ((SimpleRecipeBuilder)new SimpleRecipeBuilder().EUt(12)).duration(10), false).setSlotOverlay(false, false, true, GuiTextures.BOX_OVERLAY).setSlotOverlay(true, false, GuiTextures.BOXED_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_UNPACKER, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ASSEMBLER);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> POLARIZER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("polarizer", 1, 1, 0, 0, new SimpleRecipeBuilder(), false).setProgressBar(GuiTextures.PROGRESS_BAR_MAGNET, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ARC);
    @ZenProperty
    public static final RecipeMap<PrimitiveRecipeBuilder> PRIMITIVE_BLAST_FURNACE_RECIPES = new RecipeMap<PrimitiveRecipeBuilder>("primitive_blast_furnace", 3, false, 3, false, 0, false, 0, false, new PrimitiveRecipeBuilder(), false).setSound(GTSoundEvents.FIRE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> PYROLYSE_RECIPES = new RecipeMap<SimpleRecipeBuilder>("pyrolyse_oven", 2, 1, 1, 1, new SimpleRecipeBuilder(), false).setSound(GTSoundEvents.FIRE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> REPLICATOR_RECIPES = new RecipeMap<SimpleRecipeBuilder>("replicator", 1, 1, 2, 1, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.DATA_ORB_OVERLAY).setSlotOverlay(true, false, GuiTextures.ATOMIC_OVERLAY_1).setSlotOverlay(true, true, GuiTextures.ATOMIC_OVERLAY_2).setSlotOverlay(false, true, GuiTextures.NEUTRAL_MATTER_OVERLAY).setSlotOverlay(false, true, true, GuiTextures.POSITIVE_MATTER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_REPLICATOR, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.REPLICATOR);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> ROCK_BREAKER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("rock_breaker", 1, 4, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, GuiTextures.CRUSHED_ORE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MACERATE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.FIRE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> SCANNER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("scanner", 2, 1, 1, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.DATA_ORB_OVERLAY).setSlotOverlay(false, false, true, GuiTextures.SCANNER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.ELECTROLYZER);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> SIFTER_RECIPES = new RecipeMap<SimpleRecipeBuilder>("sifter", 1, 6, 0, 0, new SimpleRecipeBuilder(), false).setProgressBar(GuiTextures.PROGRESS_BAR_SIFT, ProgressWidget.MoveType.VERTICAL_DOWNWARDS).setSound(SoundEvents.field_187753_eE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> THERMAL_CENTRIFUGE_RECIPES = new RecipeMap("thermal_centrifuge", 1, 3, 0, 0, ((SimpleRecipeBuilder)new SimpleRecipeBuilder().duration(400)).EUt(30), false).setSlotOverlay(false, false, GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.CENTRIFUGE);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> VACUUM_RECIPES = new RecipeMap("vacuum_freezer", 1, 1, 2, 1, new SimpleRecipeBuilder().EUt(GTValues.VA[2]), false).setSound(GTSoundEvents.COOLING);
    @ZenProperty
    public static final RecipeMap<SimpleRecipeBuilder> WIREMILL_RECIPES = new RecipeMap<SimpleRecipeBuilder>("wiremill", 2, 1, 0, 0, new SimpleRecipeBuilder(), false).setSlotOverlay(false, false, GuiTextures.WIREMILL_OVERLAY).setSlotOverlay(false, false, true, GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_WIREMILL, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.MOTOR);
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> COMBUSTION_GENERATOR_FUELS = new RecipeMap<FuelRecipeBuilder>("combustion_generator", 0, 0, 1, 0, new FuelRecipeBuilder(), false).setSlotOverlay(false, true, true, GuiTextures.FURNACE_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.COMBUSTION);
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> GAS_TURBINE_FUELS = new RecipeMap<FuelRecipeBuilder>("gas_turbine", 0, 0, 1, 0, new FuelRecipeBuilder(), false).setSlotOverlay(false, true, true, GuiTextures.DARK_CANISTER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.TURBINE);
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> STEAM_TURBINE_FUELS = new RecipeMap<FuelRecipeBuilder>("steam_turbine", 0, 0, 1, 1, new FuelRecipeBuilder(), false).setSlotOverlay(false, true, true, GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.TURBINE);
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> SEMI_FLUID_GENERATOR_FUELS = new RecipeMap<FuelRecipeBuilder>("semi_fluid_generator", 0, 0, 1, 0, new FuelRecipeBuilder(), false).setSlotOverlay(false, true, true, GuiTextures.FURNACE_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.COMBUSTION);
    @ZenProperty
    public static final RecipeMap<FuelRecipeBuilder> PLASMA_GENERATOR_FUELS = new RecipeMap<FuelRecipeBuilder>("plasma_generator", 0, 0, 1, 1, new FuelRecipeBuilder(), false).setSlotOverlay(false, true, true, GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressWidget.MoveType.HORIZONTAL).setSound(GTSoundEvents.TURBINE);
}

