/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UniversalDistillationRecipeBuilder
extends RecipeBuilder<UniversalDistillationRecipeBuilder> {
    private boolean doDistilleryRecipes = true;

    public UniversalDistillationRecipeBuilder() {
    }

    public UniversalDistillationRecipeBuilder(Recipe recipe, RecipeMap<UniversalDistillationRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public UniversalDistillationRecipeBuilder(RecipeBuilder<UniversalDistillationRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public UniversalDistillationRecipeBuilder copy() {
        return new UniversalDistillationRecipeBuilder(this);
    }

    @Override
    public void buildAndRegister() {
        if (!this.doDistilleryRecipes) {
            super.buildAndRegister();
            return;
        }
        for (int i = 0; i < this.fluidOutputs.size(); ++i) {
            SimpleRecipeBuilder builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.DISTILLERY_RECIPES.recipeBuilder().copy().EUt(Math.max(1, this.EUt / 4))).circuitMeta(i + 1);
            int ratio = UniversalDistillationRecipeBuilder.getRatioForDistillery(((GTRecipeInput)this.fluidInputs.get(0)).getInputFluidStack(), (FluidStack)this.fluidOutputs.get(i), !this.outputs.isEmpty() ? (ItemStack)this.outputs.get(0) : null);
            int recipeDuration = (int)((double)this.duration * OverclockingLogic.STANDARD_OVERCLOCK_DURATION_DIVISOR);
            boolean shouldDivide = ratio != 1;
            boolean fluidsDivisible = UniversalDistillationRecipeBuilder.isFluidStackDivisibleForDistillery(((GTRecipeInput)this.fluidInputs.get(0)).getInputFluidStack(), ratio) && UniversalDistillationRecipeBuilder.isFluidStackDivisibleForDistillery((FluidStack)this.fluidOutputs.get(i), ratio);
            FluidStack dividedInputFluid = new FluidStack(((GTRecipeInput)this.fluidInputs.get(0)).getInputFluidStack(), Math.max(1, ((GTRecipeInput)this.fluidInputs.get(0)).getAmount() / ratio));
            FluidStack dividedOutputFluid = new FluidStack((FluidStack)this.fluidOutputs.get(i), Math.max(1, ((FluidStack)this.fluidOutputs.get((int)i)).amount / ratio));
            if (shouldDivide && fluidsDivisible) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)builder.fluidInputs(dividedInputFluid)).fluidOutputs(dividedOutputFluid)).duration(Math.max(1, recipeDuration / ratio));
            } else if (!shouldDivide) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)builder.fluidInputs((GTRecipeInput)this.fluidInputs.get(0))).fluidOutputs((FluidStack)this.fluidOutputs.get(i))).outputs(this.outputs)).duration(recipeDuration)).cleanroom(this.getCleanroom())).buildAndRegister();
                continue;
            }
            if (!this.outputs.isEmpty()) {
                boolean itemsDivisible;
                boolean bl = itemsDivisible = GTUtility.isItemStackCountDivisible((ItemStack)this.outputs.get(0), ratio) && fluidsDivisible;
                if (fluidsDivisible && itemsDivisible) {
                    ItemStack stack = ((ItemStack)this.outputs.get(0)).func_77946_l();
                    stack.func_190920_e(stack.func_190916_E() / ratio);
                    builder.outputs(stack);
                }
            }
            builder.buildAndRegister();
        }
        super.buildAndRegister();
    }

    private static int getRatioForDistillery(FluidStack fluidInput, FluidStack fluidOutput, ItemStack output) {
        int[] divisors = new int[]{2, 5, 10, 25, 50};
        int ratio = -1;
        for (int divisor : divisors) {
            if (!UniversalDistillationRecipeBuilder.isFluidStackDivisibleForDistillery(fluidInput, divisor) || !UniversalDistillationRecipeBuilder.isFluidStackDivisibleForDistillery(fluidOutput, divisor) || output != null && !GTUtility.isItemStackCountDivisible(output, divisor)) continue;
            ratio = divisor;
        }
        return Math.max(1, ratio);
    }

    private static boolean isFluidStackDivisibleForDistillery(FluidStack fluidStack, int divisor) {
        return GTUtility.isFluidStackAmountDivisible(fluidStack, divisor) && fluidStack.amount / divisor >= 25;
    }

    public UniversalDistillationRecipeBuilder disableDistilleryRecipes() {
        this.doDistilleryRecipes = false;
        return this;
    }
}

