/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.crafttweaker;

import com.cleanroommc.groovyscript.api.GroovyLog;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.zenscript.IBracketHandler;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.recipes.crafttweaker.MetaTileEntityBracketHandler;
import gregtech.api.unification.material.Material;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.itempipe.BlockItemPipe;
import gregtech.integration.groovy.GroovyScriptCompat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;

@BracketHandler
@ZenRegister
public class MetaItemBracketHandler
implements IBracketHandler {
    private static final Map<String, ItemStack> metaItemNames = new HashMap<String, ItemStack>();
    private static final Map<String, ItemStack> metaBlockNames = new HashMap<String, ItemStack>();
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(MetaItemBracketHandler.class, (String)"getCtMetaItem", (Class[])new Class[]{String.class});

    public static void rebuildComponentRegistry() {
        metaItemNames.clear();
        for (MetaItem<?> metaItem : MetaItem.getMetaItems()) {
            for (MetaItem.MetaValueItem metaValueItem : metaItem.getAllItems()) {
                if (metaValueItem.unlocalizedName.equals("meta_item")) continue;
                metaItemNames.put(metaValueItem.unlocalizedName, metaValueItem.getStackForm());
            }
        }
        for (Map.Entry entry : MetaBlocks.COMPRESSED.entrySet()) {
            metaBlockNames.put("block" + ((Material)entry.getKey()).toCamelCaseString(), ((BlockCompressed)((Object)entry.getValue())).getItem((Material)entry.getKey()));
        }
        for (Map.Entry entry : MetaBlocks.FRAMES.entrySet()) {
            metaBlockNames.put("frame" + ((Material)entry.getKey()).toCamelCaseString(), ((BlockFrame)((Object)entry.getValue())).getItem((Material)entry.getKey()));
        }
        for (Iterator<Object> iterator : MetaBlocks.CABLES) {
            for (Material material : ((BlockCable)((Object)iterator)).getEnabledMaterials()) {
                metaBlockNames.put(((BlockMaterialPipe)((Object)iterator)).getPrefix().name + material.toCamelCaseString(), ((BlockMaterialPipe)((Object)iterator)).getItem(material));
            }
        }
        for (Iterator<Object> iterator : MetaBlocks.ITEM_PIPES) {
            for (Material material : ((BlockItemPipe)((Object)iterator)).getEnabledMaterials()) {
                metaBlockNames.put(((BlockMaterialPipe)((Object)iterator)).getPrefix().name + material.toCamelCaseString(), ((BlockMaterialPipe)((Object)iterator)).getItem(material));
            }
        }
        for (Iterator<Object> iterator : MetaBlocks.FLUID_PIPES) {
            for (Material material : ((BlockFluidPipe)((Object)iterator)).getEnabledMaterials()) {
                metaBlockNames.put(((BlockMaterialPipe)((Object)iterator)).getPrefix().name + material.toCamelCaseString(), ((BlockMaterialPipe)((Object)iterator)).getItem(material));
            }
        }
    }

    public static ItemStack getMetaItem(String name) {
        ItemStack item = metaItemNames.get(name);
        if (item != null) {
            return item.func_77946_l();
        }
        item = metaBlockNames.get(name);
        if (item != null) {
            return item.func_77946_l();
        }
        item = MetaTileEntityBracketHandler.getMetaTileEntityItem(name);
        if (item != null) {
            return item.func_77946_l();
        }
        if (GroovyScriptCompat.isCurrentlyRunning()) {
            GroovyLog.get().error("Could not resolve metaitem('{}')", new Object[]{name});
        }
        return ItemStack.field_190927_a;
    }

    public static IItemStack getCtMetaItem(String name) {
        ItemStack itemStack = MetaItemBracketHandler.getMetaItem(name);
        if (itemStack.func_190926_b()) {
            CraftTweakerAPI.logError((String)("Could not resolve <metaitem:" + name + ">"));
            return MCItemStack.EMPTY;
        }
        return new MCItemStack(itemStack);
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() < 3) {
            return null;
        }
        if (!tokens.get(0).getValue().equalsIgnoreCase("metaitem")) {
            return null;
        }
        if (!tokens.get(1).getValue().equals(":")) {
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 2; i < tokens.size(); ++i) {
            nameBuilder.append(tokens.get(i).getValue());
        }
        return position -> new ExpressionCallStatic(position, environment, this.method, new Expression[]{new ExpressionString(position, nameBuilder.toString())});
    }
}

