/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.zenscript.IBracketHandler;
import gregtech.api.GregTechAPI;
import gregtech.api.metatileentity.MetaTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;

@BracketHandler
@ZenRegister
public class MetaTileEntityBracketHandler
implements IBracketHandler {
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(MetaTileEntityBracketHandler.class, (String)"getCtMetaTileEntityItem", (Class[])new Class[]{String.class});

    @Nullable
    public static ItemStack getMetaTileEntityItem(String name) {
        String[] resultName = MetaTileEntityBracketHandler.splitObjectName(name);
        MetaTileEntity metaTileEntity = (MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_82594_a(new ResourceLocation(resultName[0], resultName[1]));
        return metaTileEntity == null ? null : metaTileEntity.getStackForm();
    }

    public static IItemStack getCtMetaTileEntityItem(String name) {
        ItemStack itemStack = MetaTileEntityBracketHandler.getMetaTileEntityItem(name);
        return itemStack == null || itemStack.func_190926_b() ? MCItemStack.EMPTY : new MCItemStack(itemStack);
    }

    public static String[] splitObjectName(String toSplit) {
        String[] resultSplit = new String[]{"gregtech", toSplit};
        int i = toSplit.indexOf(58);
        if (i >= 0) {
            resultSplit[1] = toSplit.substring(i + 1);
            if (i > 1) {
                resultSplit[0] = toSplit.substring(0, i);
            }
        }
        return resultSplit;
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() < 3) {
            return null;
        }
        if (!tokens.get(0).getValue().equalsIgnoreCase("meta_tile_entity")) {
            return null;
        }
        if (!tokens.get(1).getValue().equals(":")) {
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 2; i < tokens.size(); ++i) {
            nameBuilder.append(tokens.get(i).getValue());
        }
        return position -> new ExpressionCallStatic(position, environment, this.method, new Expression[]{new ExpressionString(position, nameBuilder.toString())});
    }
}

