/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients;

import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GTRecipeOreInput
extends GTRecipeInput {
    int ore;
    ItemStack[] inputStacks;

    protected GTRecipeOreInput(String ore, int amount) {
        this.ore = OreDictionary.getOreID((String)ore);
        this.amount = amount;
    }

    protected GTRecipeOreInput(int ore, int amount) {
        this.ore = ore;
        this.amount = amount;
    }

    public static GTRecipeInput getOrCreate(String ore, int amount) {
        return GTRecipeOreInput.getFromCache(new GTRecipeOreInput(ore, amount));
    }

    public static GTRecipeInput getOrCreate(String ore) {
        return GTRecipeOreInput.getFromCache(new GTRecipeOreInput(ore, 1));
    }

    public static GTRecipeInput getOrCreate(OrePrefix prefix, Material material, int amount) {
        return GTRecipeOreInput.getOrCreate(new UnificationEntry(prefix, material).toString(), amount);
    }

    public static GTRecipeInput getOrCreate(OrePrefix prefix, Material material) {
        return GTRecipeOreInput.getOrCreate(new UnificationEntry(prefix, material).toString(), 1);
    }

    @Override
    protected GTRecipeOreInput copy() {
        GTRecipeOreInput copy = new GTRecipeOreInput(this.ore, this.amount);
        copy.isConsumable = this.isConsumable;
        copy.nbtMatcher = this.nbtMatcher;
        copy.nbtCondition = this.nbtCondition;
        return copy;
    }

    @Override
    public GTRecipeInput copyWithAmount(int amount) {
        GTRecipeOreInput copy = new GTRecipeOreInput(this.ore, amount);
        copy.isConsumable = this.isConsumable;
        copy.nbtMatcher = this.nbtMatcher;
        copy.nbtCondition = this.nbtCondition;
        return copy;
    }

    @Override
    public ItemStack[] getInputStacks() {
        if (this.inputStacks == null) {
            this.inputStacks = (ItemStack[])OreDictionary.getOres((String)OreDictionary.getOreName((int)this.ore)).stream().map(is -> {
                is = is.func_77946_l();
                is.func_190920_e(this.amount);
                return is;
            }).toArray(ItemStack[]::new);
        }
        return this.inputStacks;
    }

    @Override
    public boolean isOreDict() {
        return true;
    }

    @Override
    public int getOreDict() {
        return this.ore;
    }

    @Override
    public boolean acceptsStack(@Nullable ItemStack input) {
        if (input == null || input.func_190926_b()) {
            return false;
        }
        for (ItemStack target : this.getInputStacks()) {
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false)) continue;
            return this.nbtMatcher == null || this.nbtMatcher.evaluate(input, this.nbtCondition);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.ore, this.isConsumable, this.nbtMatcher, this.nbtCondition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GTRecipeOreInput)) {
            return false;
        }
        GTRecipeOreInput other = (GTRecipeOreInput)obj;
        if (this.amount != other.amount) {
            return false;
        }
        if (this.isConsumable != other.isConsumable) {
            return false;
        }
        if (this.nbtMatcher != null && !this.nbtMatcher.equals(other.nbtMatcher)) {
            return false;
        }
        if (this.nbtCondition != null && !this.nbtCondition.equals(other.nbtCondition)) {
            return false;
        }
        return this.ore == other.ore;
    }

    @Override
    public boolean equalIgnoreAmount(GTRecipeInput input) {
        if (this == input) {
            return true;
        }
        if (!(input instanceof GTRecipeOreInput)) {
            return false;
        }
        GTRecipeOreInput other = (GTRecipeOreInput)input;
        if (this.nbtMatcher != null && !this.nbtMatcher.equals(other.nbtMatcher)) {
            return false;
        }
        if (this.nbtCondition != null && !this.nbtCondition.equals(other.nbtCondition)) {
            return false;
        }
        return this.ore == other.ore;
    }

    public String toString() {
        return this.amount + "x" + OreDictionary.getOreName((int)this.ore);
    }
}

