/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.map;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.map.AbstractMapIngredient;
import gregtech.api.recipes.map.Either;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class Branch {
    private Map<AbstractMapIngredient, Either<Recipe, Branch>> nodes;
    private Map<AbstractMapIngredient, Either<Recipe, Branch>> specialNodes;

    public Stream<Recipe> getRecipes(boolean filterHidden) {
        Stream<Recipe> stream = null;
        if (this.nodes != null) {
            stream = this.nodes.values().stream().flatMap(either -> either.map(Stream::of, right -> right.getRecipes(filterHidden)));
        }
        if (this.specialNodes != null) {
            stream = stream == null ? this.specialNodes.values().stream().flatMap(either -> either.map(Stream::of, right -> right.getRecipes(filterHidden))) : Stream.concat(stream, this.specialNodes.values().stream().flatMap(either -> either.map(Stream::of, right -> right.getRecipes(filterHidden))));
        }
        if (stream == null) {
            return Stream.empty();
        }
        if (filterHidden) {
            stream = stream.filter(t -> !t.isHidden());
        }
        return stream;
    }

    public boolean isEmptyBranch() {
        return !(this.nodes != null && !this.nodes.isEmpty() || this.specialNodes != null && !this.specialNodes.isEmpty());
    }

    @Nonnull
    public Map<AbstractMapIngredient, Either<Recipe, Branch>> getNodes() {
        if (this.nodes == null) {
            this.nodes = new Object2ObjectOpenHashMap(2);
        }
        return this.nodes;
    }

    @Nonnull
    public Map<AbstractMapIngredient, Either<Recipe, Branch>> getSpecialNodes() {
        if (this.specialNodes == null) {
            this.specialNodes = new Object2ObjectOpenHashMap(2);
        }
        return this.specialNodes;
    }
}

