/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.map;

import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.map.AbstractMapIngredient;
import gregtech.api.recipes.map.MapItemStackIngredient;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MapItemStackNBTIngredient
extends MapItemStackIngredient {
    protected GTRecipeInput gtRecipeInput = null;

    public MapItemStackNBTIngredient(ItemStack stack, int meta, NBTTagCompound tag) {
        super(stack, meta, tag);
    }

    public MapItemStackNBTIngredient(ItemStack s, GTRecipeInput gtRecipeInput) {
        super(s, s.func_77960_j(), null);
        this.gtRecipeInput = gtRecipeInput;
    }

    @Nonnull
    public static List<AbstractMapIngredient> from(@Nonnull GTRecipeInput r) {
        ObjectArrayList list = new ObjectArrayList();
        for (ItemStack s : r.getInputStacks()) {
            list.add((Object)new MapItemStackNBTIngredient(s, r));
        }
        return list;
    }

    @Override
    protected int hash() {
        int hash = this.stack.func_77973_b().hashCode() * 31;
        return hash += 31 * this.meta;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MapItemStackNBTIngredient) {
            MapItemStackNBTIngredient other = (MapItemStackNBTIngredient)obj;
            if (this.stack.func_77973_b() != other.stack.func_77973_b()) {
                return false;
            }
            if (this.meta != other.meta) {
                return false;
            }
            if (this.gtRecipeInput != null) {
                if (other.gtRecipeInput != null) {
                    return this.gtRecipeInput.equalIgnoreAmount(other.gtRecipeInput);
                }
            } else if (other.gtRecipeInput != null) {
                return other.gtRecipeInput.acceptsStack(this.stack);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "MapItemStackNBTIngredient{item=" + this.stack.func_77973_b().getRegistryName() + "}{meta=" + this.meta + "}";
    }

    @Override
    public boolean isSpecialIngredient() {
        return true;
    }
}

