/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.recipeproperties;

import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.TextFormattingUtil;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.Validate;

public class FusionEUToStartProperty
extends RecipeProperty<Long> {
    public static final String KEY = "eu_to_start";
    private static final TreeMap<Long, String> registeredFusionTiers = new TreeMap();
    private static FusionEUToStartProperty INSTANCE;

    protected FusionEUToStartProperty() {
        super(KEY, Long.class);
    }

    public static FusionEUToStartProperty getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FusionEUToStartProperty();
        }
        return INSTANCE;
    }

    @Override
    public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value) {
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.eu_to_start", (Object[])new Object[]{TextFormattingUtil.formatLongToCompactString((Long)this.castValue(value))}) + FusionEUToStartProperty.getFusionTier((Long)this.castValue(value)), x, y, color);
    }

    private static String getFusionTier(Long eu) {
        Map.Entry<Long, String> mapEntry = registeredFusionTiers.ceilingEntry(eu);
        if (mapEntry == null) {
            throw new IllegalArgumentException("Value is above registered maximum EU values");
        }
        return String.format(" %s", mapEntry.getValue());
    }

    public static void registerFusionTier(int tier, String shortName) {
        Validate.notNull((Object)shortName);
        long maxEU = 160000000L * (long)Math.pow(2.0, tier - 6);
        registeredFusionTiers.put(maxEU, shortName);
    }
}

