/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.recipeproperties;

import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.worldgen.config.WorldGenRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class GasCollectorDimensionProperty
extends RecipeProperty<IntList> {
    public static final String KEY = "dimension";
    private static GasCollectorDimensionProperty INSTANCE;

    private GasCollectorDimensionProperty() {
        super(KEY, IntList.class);
    }

    public static GasCollectorDimensionProperty getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GasCollectorDimensionProperty();
        }
        return INSTANCE;
    }

    @Override
    public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value) {
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.dimensions", (Object[])new Object[]{GasCollectorDimensionProperty.getDimensionsForRecipe((List)this.castValue(value))}), x, y, color);
    }

    private static String getDimensionsForRecipe(List<Integer> value) {
        Map<Integer, String> dimNames = WorldGenRegistry.getNamedDimensions();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.size(); ++i) {
            builder.append(dimNames.getOrDefault(value.get(i), String.valueOf(value.get(i))));
            if (i == value.size() - 1) continue;
            builder.append(", ");
        }
        String str = builder.toString();
        if (str.length() >= 13) {
            str = str.substring(0, 10) + "..";
        }
        return str;
    }
}

