/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.app;

import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.os.SystemCall;
import gregtech.common.items.behaviors.TerminalBehaviour;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ARApplication
extends AbstractApplication {
    protected ItemStack heldStack;

    public ARApplication(String name) {
        super(name);
    }

    @Override
    public int getAppTier() {
        if (this.nbt != null) {
            if (this.os != null) {
                return super.getAppTier();
            }
            if (TerminalBehaviour.isCreative(this.heldStack)) {
                return this.getMaxTier();
            }
            return Math.min(this.nbt.func_74762_e("_tier"), this.getMaxTier());
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public final void setAROpened(ItemStack heldStack) {
        this.heldStack = heldStack;
        this.nbt = heldStack.func_190925_c("terminal").func_74775_l(this.getRegistryName());
    }

    @Override
    public AbstractApplication initApp() {
        this.openAR();
        return this;
    }

    protected final void openAR() {
        this.os.tabletNBT.func_74778_a("_ar", this.getRegistryName());
        if (this.isClient) {
            SystemCall.SHUT_DOWN.call(this.getOs(), true, new String[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onAROpened() {
    }

    @SideOnly(value=Side.CLIENT)
    public void onARClosed() {
        this.nbt = null;
        this.heldStack = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void tickAR(EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void drawARScreen(RenderWorldLastEvent var1);
}

