/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.gui.widgets.ScrollBarWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.FacingPos;
import gregtech.client.renderer.scene.FBOWorldSceneRenderer;
import gregtech.client.renderer.scene.WorldSceneRenderer;
import gregtech.client.utils.RenderUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class MachineSceneWidget
extends WidgetGroup {
    private static FBOWorldSceneRenderer worldSceneRenderer;
    private boolean dragging;
    private int lastMouseX;
    private int lastMouseY;
    private int currentMouseX;
    private int currentMouseY;
    private Vector3f center;
    private float rotationYaw = 45.0f;
    private float rotationPitch;
    private float zoom = 5.0f;
    private float alpha = 1.0f;
    private boolean blendColor = true;
    private Set<BlockPos> cores;
    private Set<BlockPos> around;
    private FacingPos hoveredFacingPos;
    private FacingPos selectedFacingPos;
    private BiConsumer<BlockPos, EnumFacing> onSelected;
    protected MetaTileEntity mte;
    protected final BlockPos pos;

    public MachineSceneWidget(int x, int y, int width, int height, MetaTileEntity mte) {
        this(x, y, width, height, mte.getPos());
        this.mte = mte;
        this.updateScene();
    }

    public MachineSceneWidget(int x, int y, int width, int height, BlockPos pos) {
        super(x, y, width, height);
        this.pos = pos;
        this.addWidget(new ScrollBarWidget(5, height - 13, width - 50, 8, 0.0f, 1.0f, 0.05f).setOnChanged(value -> {
            this.alpha = value.floatValue();
        }, true).setInitValue(1.0f));
        this.addWidget(new RectButtonWidget(width - 40, height - 15, 35, 12, 1).setToggleButton((IGuiTexture)new TextTexture("COLOR", -1), (c, b) -> {
            this.blendColor = b;
        }).setValueSupplier(true, () -> this.blendColor).setColors(TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_F_1.getColor(), 0).setIcon(new TextTexture("ALPHA", -1)));
        if (worldSceneRenderer != null) {
            worldSceneRenderer.releaseFBO();
            worldSceneRenderer = null;
        }
    }

    public Set<BlockPos> getCores() {
        return this.cores;
    }

    public Set<BlockPos> getAround() {
        return this.around;
    }

    public static FBOWorldSceneRenderer getWorldSceneRenderer() {
        return worldSceneRenderer;
    }

    public MachineSceneWidget setOnSelected(BiConsumer<BlockPos, EnumFacing> onSelected) {
        this.onSelected = onSelected;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBlockOverLay(WorldSceneRenderer renderer) {
        this.hoveredFacingPos = null;
        if (this.isMouseOverElement(this.currentMouseX, this.currentMouseY)) {
            int x = this.getPosition().x;
            int y = this.getPosition().y;
            int width = this.getSize().width;
            int height = this.getSize().height;
            int resolutionWidth = worldSceneRenderer.getResolutionWidth();
            int resolutionHeight = worldSceneRenderer.getResolutionHeight();
            int mouseX = resolutionWidth * (this.currentMouseX - x) / width;
            int mouseY = (int)((float)resolutionHeight * (1.0f - (float)(this.currentMouseY - y) / (float)height));
            Vector3f hitPos = WorldSceneRenderer.unProject(mouseX, mouseY);
            World world = renderer.world;
            Vec3d eyePos = new Vec3d((double)renderer.getEyePos().x, (double)renderer.getEyePos().y, (double)renderer.getEyePos().z);
            hitPos.scale(2.0f);
            Vec3d endPos = new Vec3d((double)hitPos.x - eyePos.field_72450_a, (double)hitPos.y - eyePos.field_72448_b, (double)hitPos.z - eyePos.field_72449_c);
            double min = 3.4028234663852886E38;
            for (BlockPos core : this.cores) {
                double dist;
                RayTraceResult hit;
                IBlockState blockState = world.func_180495_p(core);
                if (blockState.func_177230_c() == Blocks.field_150350_a || (hit = blockState.func_185910_a(world, core, eyePos, endPos)) == null || hit.field_72313_a == RayTraceResult.Type.MISS || !((dist = eyePos.func_72438_d(new Vec3d((Vec3i)hit.func_178782_a()))) < min)) continue;
                min = dist;
                this.hoveredFacingPos = new FacingPos(hit.func_178782_a(), hit.field_178784_b);
            }
        }
        if (this.selectedFacingPos != null || this.hoveredFacingPos != null) {
            GlStateManager.func_179094_E();
            RenderUtil.useLightMap(240.0f, 240.0f, () -> {
                GlStateManager.func_179097_i();
                if (this.selectedFacingPos != null) {
                    MachineSceneWidget.drawFacingBorder(this.selectedFacingPos, -16711936);
                }
                if (this.hoveredFacingPos != null && !this.hoveredFacingPos.equals(this.selectedFacingPos)) {
                    MachineSceneWidget.drawFacingBorder(this.hoveredFacingPos, -1);
                }
                GlStateManager.func_179126_j();
            });
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    private static void drawFacingBorder(FacingPos posFace, int color) {
        GlStateManager.func_179094_E();
        RenderUtil.moveToFace(posFace.getPos().func_177958_n(), posFace.getPos().func_177956_o(), posFace.getPos().func_177952_p(), posFace.getFacing());
        RenderUtil.rotateToFace(posFace.getFacing(), null);
        GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)0.0f);
        GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)0.0f);
        Widget.drawBorder(1, 1, 14, 14, color, 1);
        GlStateManager.func_179121_F();
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.mte == null) {
            World world = this.gui.entityPlayer.field_70170_p;
            TileEntity tileEntity = world.func_175625_s(this.pos);
            if (tileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tileEntity).getMetaTileEntity() != null) {
                this.mte = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
                this.updateScene();
            }
        } else if (!this.mte.isValid()) {
            worldSceneRenderer.releaseFBO();
            worldSceneRenderer = null;
            this.mte = null;
        }
    }

    private void updateScene() {
        if (!this.mte.isValid()) {
            return;
        }
        World world = this.mte.getWorld();
        if (worldSceneRenderer != null) {
            worldSceneRenderer.releaseFBO();
        }
        worldSceneRenderer = new FBOWorldSceneRenderer(world, 1080, 1080);
        worldSceneRenderer.setAfterWorldRender(this::renderBlockOverLay);
        this.cores = new HashSet<BlockPos>();
        this.around = new HashSet<BlockPos>();
        this.cores.add(this.pos);
        if (this.mte instanceof MultiblockControllerBase && ((MultiblockControllerBase)this.mte).isStructureFormed()) {
            PatternMatchContext context = ((MultiblockControllerBase)this.mte).structurePattern.checkPatternFastAt(world, this.pos, this.mte.getFrontFacing().func_176734_d());
            if (context != null) {
                List validPos = ((MultiblockControllerBase)this.mte).structurePattern.cache.keySet().stream().map(BlockPos::func_177969_a).collect(Collectors.toList());
                Set parts = context.getOrCreate("MultiblockParts", HashSet::new);
                for (IMultiblockPart part : parts) {
                    if (!(part instanceof MetaTileEntity)) continue;
                    this.cores.add(((MetaTileEntity)((Object)part)).getPos());
                }
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    this.cores.forEach(pos -> this.around.add(pos.func_177972_a(facing)));
                }
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                int maxZ = Integer.MIN_VALUE;
                for (BlockPos vPos : validPos) {
                    this.around.add(vPos);
                    minX = Math.min(minX, vPos.func_177958_n());
                    minY = Math.min(minY, vPos.func_177956_o());
                    minZ = Math.min(minZ, vPos.func_177952_p());
                    maxX = Math.max(maxX, vPos.func_177958_n());
                    maxY = Math.max(maxY, vPos.func_177956_o());
                    maxZ = Math.max(maxZ, vPos.func_177952_p());
                }
                this.around.removeAll(this.cores);
                this.center = new Vector3f((float)(minX + maxX) / 2.0f, (float)(minY + maxY) / 2.0f, (float)(minZ + maxZ) / 2.0f);
            } else {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    this.around.add(this.pos.func_177972_a(facing));
                }
                this.center = new Vector3f((float)this.pos.func_177958_n() + 0.5f, (float)this.pos.func_177956_o() + 0.5f, (float)this.pos.func_177952_p() + 0.5f);
            }
        } else {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.around.add(this.pos.func_177972_a(facing));
            }
            this.center = new Vector3f((float)this.pos.func_177958_n() + 0.5f, (float)this.pos.func_177956_o() + 0.5f, (float)this.pos.func_177952_p() + 0.5f);
        }
        worldSceneRenderer.addRenderedBlocks(this.cores, null);
        worldSceneRenderer.addRenderedBlocks(this.around, this::aroundBlocksRenderHook);
        worldSceneRenderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
    }

    private void aroundBlocksRenderHook(boolean isTESR, int pass, BlockRenderLayer layer) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        if (this.blendColor) {
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.CONSTANT_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.DST_ALPHA);
        } else {
            GlStateManager.func_179112_b((int)32771, (int)32772);
        }
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.dragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            if (this.hoveredFacingPos != null && !this.hoveredFacingPos.equals(this.selectedFacingPos)) {
                this.selectedFacingPos = this.hoveredFacingPos;
                if (this.onSelected != null) {
                    this.onSelected.accept(this.selectedFacingPos.getPos(), this.selectedFacingPos.getFacing());
                }
            }
            return true;
        }
        this.dragging = false;
        return false;
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.zoom = (float)MathHelper.func_151237_a((double)((double)this.zoom + (wheelDelta < 0 ? 0.5 : -0.5)), (double)3.0, (double)999.0);
            if (worldSceneRenderer != null) {
                worldSceneRenderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.dragging) {
            this.rotationPitch += (float)(mouseX - this.lastMouseX + 360);
            this.rotationPitch %= 360.0f;
            this.rotationYaw = (float)MathHelper.func_151237_a((double)(this.rotationYaw + (float)(mouseY - this.lastMouseY)), (double)-89.9, (double)89.9);
            this.lastMouseY = mouseY;
            this.lastMouseX = mouseX;
            if (worldSceneRenderer != null) {
                worldSceneRenderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, timeDragged);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        MachineSceneWidget.drawSolidRect(x, y, width, height, -1358954496);
        if (worldSceneRenderer != null) {
            GL11.glDisable((int)3089);
            worldSceneRenderer.render((float)x, (float)y, (float)width, (float)height, mouseX - x, mouseY - y);
            GL11.glEnable((int)3089);
        }
        MachineSceneWidget.drawBorder(x + 1, y + 1, width - 2, height - 2, -16777216, 1);
        if (this.mte != null) {
            MachineSceneWidget.drawStringSized(I18n.func_135052_a((String)this.mte.getMetaFullName(), (Object[])new Object[0]), (float)x + (float)width / 2.0f, y + 10, -1, true, 1.0f, true);
        }
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
    }
}

