/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import org.lwjgl.input.Mouse;

public class RectButtonWidget
extends CircleButtonWidget {
    private IGuiTexture pressedIcon;
    private BiConsumer<Widget.ClickData, Boolean> onPressed;
    private boolean isPressed;
    private Supplier<Boolean> supplier;
    private boolean isClient;

    public RectButtonWidget(int x, int y, int width, int height) {
        this(x, y, width, height, 2);
    }

    public RectButtonWidget(int x, int y, int width, int height, int border) {
        super(x, y);
        this.setSelfPosition(new Position(x, y));
        this.setSize(new Size(width, height));
        this.border = border;
    }

    public RectButtonWidget setToggleButton(IGuiTexture pressedIcon, BiConsumer<Widget.ClickData, Boolean> onPressed) {
        this.pressedIcon = pressedIcon;
        this.onPressed = onPressed;
        return this;
    }

    public RectButtonWidget setToggleButton(IGuiTexture pressedIcon, Consumer<Boolean> onPressed) {
        this.pressedIcon = pressedIcon;
        this.onPressed = onPressed != null ? (c, p) -> onPressed.accept((Boolean)p) : null;
        return this;
    }

    public RectButtonWidget setInitValue(boolean isPressed) {
        this.isPressed = isPressed;
        return this;
    }

    public RectButtonWidget setValueSupplier(boolean isClient, Supplier<Boolean> supplier) {
        this.isClient = isClient;
        this.supplier = supplier;
        return this;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.isClient && this.supplier != null) {
            this.isPressed = this.supplier.get();
        }
    }

    @Override
    public void detectAndSendChanges() {
        if (!this.isClient && this.supplier != null && this.supplier.get() != this.isPressed) {
            this.isPressed = !this.isPressed;
            this.writeUpdateInfo(1, buffer -> buffer.writeBoolean(this.isPressed));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            this.isPressed = buffer.readBoolean();
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.onPressed == null) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            boolean bl = this.isPressed = !this.isPressed;
            if (!this.isClient) {
                Widget.ClickData clickData = new Widget.ClickData(Mouse.getEventButton(), RectButtonWidget.isShiftDown(), RectButtonWidget.isCtrlDown(), false);
                this.writeClientAction(1, buffer -> {
                    clickData.writeToBuf((PacketBuffer)buffer);
                    buffer.writeBoolean(this.isPressed);
                });
            }
            RectButtonWidget.playButtonClickSound();
            this.onPressed.accept(new Widget.ClickData(Mouse.getEventButton(), RectButtonWidget.isShiftDown(), RectButtonWidget.isCtrlDown(), true), this.isPressed);
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (this.onPressed == null) {
            super.handleClientAction(id, buffer);
        } else if (id == 1) {
            Widget.ClickData clickData = Widget.ClickData.readFromBuf(buffer);
            this.isPressed = buffer.readBoolean();
            this.onPressed.accept(clickData, this.isPressed);
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        RectButtonWidget.drawBorder(x + this.border, y + this.border, width - 2 * this.border, height - 2 * this.border, this.colors[0], this.border);
        this.isHover = this.isMouseOverElement(mouseX, mouseY);
        if (this.isHover || this.hoverTick != 0) {
            float per = Math.min(((float)this.hoverTick + partialTicks) / 8.0f, 1.0f);
            RectButtonWidget.drawSolidRect(x, y, (int)((float)width * per), this.border, this.colors[1]);
            RectButtonWidget.drawSolidRect(x + width - this.border, y, this.border, (int)((float)height * per), this.colors[1]);
            RectButtonWidget.drawSolidRect((int)((1.0f - per) * (float)width) + x, y + height - this.border, (int)((float)width * per), this.border, this.colors[1]);
            RectButtonWidget.drawSolidRect(x, (int)((1.0f - per) * (float)height) + y, this.border, (int)((float)height * per), this.colors[1]);
        }
        RectButtonWidget.drawSolidRect(x + this.border, y + this.border, width - 2 * this.border, height - 2 * this.border, this.colors[2]);
        if (this.isHover && this.hover != null) {
            this.hover.draw(x + this.border, y + this.border, width - 2 * this.border, height - 2 * this.border);
        }
        if (this.isPressed) {
            if (this.pressedIcon != null) {
                this.pressedIcon.draw(x + this.border, y + this.border, width - 2 * this.border, height - 2 * this.border);
            }
        } else if (this.icon != null) {
            this.icon.draw(x + this.border, y + this.border, width - 2 * this.border, height - 2 * this.border);
        }
    }
}

