/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.os;

import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.os.SystemCall;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.GTLog;
import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TerminalHomeButtonWidget
extends CircleButtonWidget {
    private final TerminalOSWidget os;
    private int mouseClickTime = -1;
    private final Pair<SystemCall, String>[] actions;

    public TerminalHomeButtonWidget(TerminalOSWidget os) {
        super(351, 115, 11, 2, 18);
        this.os = os;
        this.setColors(0, TerminalTheme.COLOR_F_1.getColor(), 0);
        this.actions = new Pair[8];
        if (FMLCommonHandler.instance().getSide().isClient()) {
            NBTTagCompound nbt = null;
            try {
                nbt = CompressedStreamTools.func_74797_a((File)new File(TerminalRegistry.TERMINAL_PATH, "config/home_button.nbt"));
            }
            catch (IOException e) {
                GTLog.logger.error("error while loading local nbt for the home button", (Throwable)e);
            }
            if (nbt == null) {
                this.actions[TerminalHomeButtonWidget.actionMap((boolean)false, (boolean)false, (boolean)false)] = new MutablePair((Object)SystemCall.CALL_MENU, null);
                this.actions[TerminalHomeButtonWidget.actionMap((boolean)true, (boolean)false, (boolean)false)] = new MutablePair((Object)SystemCall.MINIMIZE_FOCUS_APP, null);
            } else {
                for (int i = 0; i < this.actions.length; ++i) {
                    if (!nbt.func_74764_b(String.valueOf(i))) continue;
                    NBTTagCompound tag = nbt.func_74775_l(String.valueOf(i));
                    this.actions[i] = new MutablePair((Object)SystemCall.getFromIndex(tag.func_74762_e("action")), tag.func_74764_b("arg") ? tag.func_74779_i("arg") : null);
                }
            }
        }
    }

    public Pair<SystemCall, String>[] getActions() {
        return this.actions;
    }

    public static int actionMap(boolean doubleClick, boolean isCtrl, boolean isShift) {
        return (doubleClick ? 1 : 0) + (isCtrl ? 2 : 0) + (isShift ? 4 : 0);
    }

    public void saveConfig() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            NBTTagCompound nbt = new NBTTagCompound();
            for (int i = 0; i < this.actions.length; ++i) {
                if (this.actions[i] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("action", ((SystemCall)((Object)this.actions[i].getKey())).index);
                if (this.actions[i].getValue() != null) {
                    tag.func_74778_a("arg", (String)this.actions[i].getValue());
                }
                nbt.func_74782_a(String.valueOf(i), (NBTBase)tag);
            }
            try {
                if (!nbt.func_82582_d()) {
                    CompressedStreamTools.func_74793_a((NBTTagCompound)nbt, (File)new File(TerminalRegistry.TERMINAL_PATH, "config/home_button.nbt"));
                }
            }
            catch (IOException e) {
                GTLog.logger.error("error while saving local nbt for the home button", (Throwable)e);
            }
        }
    }

    private void click(int index, boolean isClient, String ... args) {
        SystemCall action = SystemCall.getFromIndex(index);
        if (action != null) {
            action.call(this.os, isClient, args);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            int index = buffer.func_150792_a();
            int length = buffer.func_150792_a();
            String[] args = new String[length];
            for (int i = 0; i < length; ++i) {
                args[i] = buffer.func_150789_c(Short.MAX_VALUE);
            }
            this.click(index, false, args);
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.mouseClickTime > 3) {
            Pair<SystemCall, String> pair = this.actions[TerminalHomeButtonWidget.actionMap(false, TerminalHomeButtonWidget.isCtrlDown(), TerminalHomeButtonWidget.isShiftDown())];
            this.sendToServer(pair);
            TerminalHomeButtonWidget.playButtonClickSound();
            this.mouseClickTime = -1;
        } else if (this.mouseClickTime > -1) {
            ++this.mouseClickTime;
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.mouseClickTime == -1) {
                this.mouseClickTime = 0;
            } else if (this.mouseClickTime <= 3) {
                Pair<SystemCall, String> pair = this.actions[TerminalHomeButtonWidget.actionMap(true, TerminalHomeButtonWidget.isCtrlDown(), TerminalHomeButtonWidget.isShiftDown())];
                this.sendToServer(pair);
                TerminalHomeButtonWidget.playButtonClickSound();
                this.mouseClickTime = -1;
            }
            return true;
        }
        return false;
    }

    private void sendToServer(Pair<SystemCall, String> pair) {
        if (pair != null) {
            String[] args = pair.getValue() == null ? new String[]{} : ((String)pair.getValue()).split(" ");
            this.writeClientAction(1, buffer -> {
                buffer.func_150787_b(((SystemCall)((Object)((Object)pair.getKey()))).index);
                buffer.func_150787_b(args.length);
                for (String arg : args) {
                    buffer.func_180714_a(arg);
                }
            });
            this.click(((SystemCall)((Object)pair.getKey())).index, true, args);
        }
    }
}

