/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.enchantments.IEnchantment;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.unification.crafttweaker.CTMaterialHelpers;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PlasmaProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.ToolProperty;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="mods.gregtech.material.Material")
@ZenRegister
public class MaterialExpansion {
    @ZenMethod
    public static void setFormula(Material m, String formula, @Optional boolean withFormatting) {
        if (CTMaterialHelpers.checkFrozen("set material chemical formula")) {
            return;
        }
        m.setFormula(formula, withFormatting);
    }

    @ZenMethod
    public static boolean hasFlag(Material m, String flagName) {
        return m.hasFlag(MaterialFlag.getByName(flagName));
    }

    @ZenMethod
    public static void setIconSet(Material m, String iconSetName) {
        if (CTMaterialHelpers.checkFrozen("set material icon set")) {
            return;
        }
        m.setMaterialIconSet(MaterialIconSet.getByName(iconSetName));
    }

    @ZenGetter(value="iconSet")
    public static String getIconSet(Material m) {
        return m.getMaterialIconSet().getName();
    }

    @ZenGetter
    public static boolean isGaseous(Material m) {
        FluidProperty prop = m.getProperty(PropertyKey.FLUID);
        return prop != null && prop.isGas();
    }

    @ZenMethod
    public static void setFluidTemperature(Material m, int fluidTemperature) {
        if (CTMaterialHelpers.checkFrozen("set fluid temperature")) {
            return;
        }
        FluidProperty prop = m.getProperty(PropertyKey.FLUID);
        if (prop != null) {
            prop.setFluidTemperature(fluidTemperature);
        } else {
            CTMaterialHelpers.logError(m, "set temperature", "Fluid");
        }
    }

    @ZenGetter(value="fluidTemperature")
    public static int fluidTemperature(Material m) {
        FluidProperty prop = m.getProperty(PropertyKey.FLUID);
        if (prop != null) {
            return prop.getFluidTemperature();
        }
        CTMaterialHelpers.logError(m, "get temperature", "Fluid");
        return 0;
    }

    @ZenGetter(value="fluid")
    @Optional.Method(modid="crafttweaker")
    public static ILiquidDefinition getFluid(Material m) {
        FluidProperty prop = m.getProperty(PropertyKey.FLUID);
        if (prop != null) {
            return CraftTweakerMC.getILiquidDefinition((Fluid)prop.getFluid());
        }
        CTMaterialHelpers.logError(m, "get a Fluid", "Fluid");
        return null;
    }

    @ZenGetter(value="harvestLevel")
    public static int harvestLevel(Material m) {
        DustProperty prop = m.getProperty(PropertyKey.DUST);
        if (prop != null) {
            return prop.getHarvestLevel();
        }
        CTMaterialHelpers.logError(m, "get the harvest level", "Dust");
        return 0;
    }

    @ZenGetter(value="burnTime")
    public static int burnTime(Material m) {
        DustProperty prop = m.getProperty(PropertyKey.DUST);
        if (prop != null) {
            return prop.getBurnTime();
        }
        CTMaterialHelpers.logError(m, "get the burn time", "Dust");
        return 0;
    }

    @ZenMethod
    public static void setHarvestLevel(Material m, int harvestLevel) {
        if (CTMaterialHelpers.checkFrozen("set harvest level")) {
            return;
        }
        DustProperty prop = m.getProperty(PropertyKey.DUST);
        if (prop != null) {
            prop.setHarvestLevel(harvestLevel);
        } else {
            CTMaterialHelpers.logError(m, "set the harvest level", "Dust");
        }
    }

    @ZenMethod
    public static void setBurnTime(Material m, int burnTime) {
        if (CTMaterialHelpers.checkFrozen("set burn time")) {
            return;
        }
        DustProperty prop = m.getProperty(PropertyKey.DUST);
        if (prop != null) {
            prop.setBurnTime(burnTime);
        } else {
            CTMaterialHelpers.logError(m, "set the burn time", "Dust");
        }
    }

    @ZenGetter(value="plasma")
    @Optional.Method(modid="crafttweaker")
    public static ILiquidDefinition getPlasma(Material m) {
        PlasmaProperty prop = m.getProperty(PropertyKey.PLASMA);
        if (prop != null) {
            return CraftTweakerMC.getILiquidDefinition((Fluid)prop.getPlasma());
        }
        CTMaterialHelpers.logError(m, "get a Plasma", "Plasma");
        return null;
    }

    @ZenGetter(value="toolSpeed")
    public static float toolSpeed(Material m) {
        ToolProperty prop = m.getProperty(PropertyKey.TOOL);
        if (prop != null) {
            return prop.getToolSpeed();
        }
        CTMaterialHelpers.logError(m, "get the tool speed", "Tool");
        return 0.0f;
    }

    @ZenGetter(value="toolAttackDamage")
    public static float attackDamage(Material m) {
        ToolProperty prop = m.getProperty(PropertyKey.TOOL);
        if (prop != null) {
            return prop.getToolAttackDamage();
        }
        CTMaterialHelpers.logError(m, "get the tool attack damage", "Tool");
        return 0.0f;
    }

    @ZenGetter(value="toolDurability")
    public static int toolDurability(Material m) {
        ToolProperty prop = m.getProperty(PropertyKey.TOOL);
        if (prop != null) {
            return prop.getToolDurability();
        }
        CTMaterialHelpers.logError(m, "get the tool durability", "Tool");
        return 0;
    }

    @ZenGetter(value="toolHarvestLevel")
    public static int toolHarvestLevel(Material m) {
        ToolProperty prop = m.getProperty(PropertyKey.TOOL);
        if (prop != null) {
            return prop.getToolHarvestLevel();
        }
        CTMaterialHelpers.logError(m, "get the tool harvest level", "Tool");
        return 0;
    }

    @ZenGetter(value="toolEnchantability")
    public static int toolEnchant(Material m) {
        ToolProperty prop = m.getProperty(PropertyKey.TOOL);
        if (prop != null) {
            return prop.getToolEnchantability();
        }
        CTMaterialHelpers.logError(m, "get the tool enchantability", "Tool");
        return 0;
    }

    @ZenMethod
    @Optional.Method(modid="crafttweaker")
    public static void addToolEnchantment(Material m, IEnchantment enchantment) {
        if (CTMaterialHelpers.checkFrozen("add tool enchantment")) {
            return;
        }
        ToolProperty prop = m.getProperty(PropertyKey.TOOL);
        if (prop != null) {
            Enchantment enchantmentType = (Enchantment)enchantment.getDefinition().getInternal();
            prop.addEnchantmentForTools(enchantmentType, enchantment.getLevel());
        } else {
            CTMaterialHelpers.logError(m, "change tool enchantments", "Tool");
        }
    }

    @ZenMethod
    public static void setToolStats(Material m, float toolSpeed, float toolAttackDamage, int toolDurability, @Optional int enchantability, @Optional boolean shouldIngoreCraftingTools) {
        MaterialExpansion.setToolStats(m, toolSpeed, toolAttackDamage, toolDurability, enchantability, 0, shouldIngoreCraftingTools);
    }

    @ZenMethod
    public static void setToolStats(Material m, float toolSpeed, float toolAttackDamage, int toolDurability, @Optional int enchantability, @Optional int toolHarvestLevel, @Optional boolean shouldIngoreCraftingTools) {
        if (CTMaterialHelpers.checkFrozen("set tool stats")) {
            return;
        }
        ToolProperty prop = m.getProperty(PropertyKey.TOOL);
        if (prop != null) {
            prop.setToolSpeed(toolSpeed);
            prop.setToolAttackDamage(toolAttackDamage);
            prop.setToolDurability(toolDurability);
            prop.setToolHarvestLevel(toolHarvestLevel == 0 ? 2 : toolHarvestLevel);
            prop.setToolEnchantability(enchantability == 0 ? 10 : enchantability);
            prop.setShouldIgnoreCraftingTools(shouldIngoreCraftingTools);
        } else {
            CTMaterialHelpers.logError(m, "change tool stats", "Tool");
        }
    }

    @ZenMethod
    public static void setBlastTemp(Material m, int blastTemp) {
        if (CTMaterialHelpers.checkFrozen("set blast temperature")) {
            return;
        }
        if (blastTemp <= 0) {
            CraftTweakerAPI.logError((String)("Blast Temperature must be greater than zero! Material: " + m.getUnlocalizedName()));
            return;
        }
        BlastProperty prop = m.getProperty(PropertyKey.BLAST);
        if (prop != null) {
            prop.setBlastTemperature(blastTemp);
        } else {
            m.setProperty(PropertyKey.BLAST, new BlastProperty(blastTemp));
        }
    }

    @ZenGetter
    public static int blastTemp(Material m) {
        BlastProperty prop = m.getProperty(PropertyKey.BLAST);
        if (prop != null) {
            return prop.getBlastTemperature();
        }
        CTMaterialHelpers.logError(m, "get blast temperature", "Blast");
        return 0;
    }

    @ZenGetter
    public static int oreMultiplier(Material m) {
        OreProperty prop = m.getProperty(PropertyKey.ORE);
        if (prop != null) {
            return prop.getOreMultiplier();
        }
        CTMaterialHelpers.logError(m, "get ore multiplier", "Ore");
        return 0;
    }
}

