/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.info;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import gregtech.api.gui.resources.ResourceHelper;
import gregtech.api.unification.material.info.MaterialIconSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="gregtech", value={Side.CLIENT})
public class MaterialIconType {
    public static final Map<String, MaterialIconType> ICON_TYPES = new HashMap<String, MaterialIconType>();
    static int idCounter = 0;
    public static final MaterialIconType dustTiny = new MaterialIconType("dustTiny");
    public static final MaterialIconType dustSmall = new MaterialIconType("dustSmall");
    public static final MaterialIconType dust = new MaterialIconType("dust");
    public static final MaterialIconType dustImpure = new MaterialIconType("dustImpure");
    public static final MaterialIconType dustPure = new MaterialIconType("dustPure");
    public static final MaterialIconType crushed = new MaterialIconType("crushed");
    public static final MaterialIconType crushedPurified = new MaterialIconType("crushedPurified");
    public static final MaterialIconType crushedCentrifuged = new MaterialIconType("crushedCentrifuged");
    public static final MaterialIconType gem = new MaterialIconType("gem");
    public static final MaterialIconType gemChipped = new MaterialIconType("gemChipped");
    public static final MaterialIconType gemFlawed = new MaterialIconType("gemFlawed");
    public static final MaterialIconType gemFlawless = new MaterialIconType("gemFlawless");
    public static final MaterialIconType gemExquisite = new MaterialIconType("gemExquisite");
    public static final MaterialIconType nugget = new MaterialIconType("nugget");
    public static final MaterialIconType ingot = new MaterialIconType("ingot");
    public static final MaterialIconType ingotHot = new MaterialIconType("ingotHot");
    public static final MaterialIconType ingotDouble = new MaterialIconType("ingotDouble");
    public static final MaterialIconType ingotTriple = new MaterialIconType("ingotTriple");
    public static final MaterialIconType ingotQuadruple = new MaterialIconType("ingotQuadruple");
    public static final MaterialIconType ingotQuintuple = new MaterialIconType("ingotQuintuple");
    public static final MaterialIconType plate = new MaterialIconType("plate");
    public static final MaterialIconType plateDouble = new MaterialIconType("plateDouble");
    public static final MaterialIconType plateTriple = new MaterialIconType("plateTriple");
    public static final MaterialIconType plateQuadruple = new MaterialIconType("plateQuadruple");
    public static final MaterialIconType plateQuintuple = new MaterialIconType("plateQuintuple");
    public static final MaterialIconType plateDense = new MaterialIconType("plateDense");
    public static final MaterialIconType stick = new MaterialIconType("stick");
    public static final MaterialIconType lens = new MaterialIconType("lens");
    public static final MaterialIconType round = new MaterialIconType("round");
    public static final MaterialIconType bolt = new MaterialIconType("bolt");
    public static final MaterialIconType screw = new MaterialIconType("screw");
    public static final MaterialIconType ring = new MaterialIconType("ring");
    public static final MaterialIconType wireFine = new MaterialIconType("wireFine");
    public static final MaterialIconType gearSmall = new MaterialIconType("gearSmall");
    public static final MaterialIconType rotor = new MaterialIconType("rotor");
    public static final MaterialIconType stickLong = new MaterialIconType("stickLong");
    public static final MaterialIconType springSmall = new MaterialIconType("springSmall");
    public static final MaterialIconType spring = new MaterialIconType("spring");
    public static final MaterialIconType gear = new MaterialIconType("gear");
    public static final MaterialIconType foil = new MaterialIconType("foil");
    public static final MaterialIconType toolHeadSword = new MaterialIconType("toolHeadSword");
    public static final MaterialIconType toolHeadPickaxe = new MaterialIconType("toolHeadPickaxe");
    public static final MaterialIconType toolHeadShovel = new MaterialIconType("toolHeadShovel");
    public static final MaterialIconType toolHeadAxe = new MaterialIconType("toolHeadAxe");
    public static final MaterialIconType toolHeadHoe = new MaterialIconType("toolHeadHoe");
    public static final MaterialIconType toolHeadHammer = new MaterialIconType("toolHeadHammer");
    public static final MaterialIconType toolHeadFile = new MaterialIconType("toolHeadFile");
    public static final MaterialIconType toolHeadSaw = new MaterialIconType("toolHeadSaw");
    public static final MaterialIconType toolHeadBuzzSaw = new MaterialIconType("toolHeadBuzzSaw");
    public static final MaterialIconType toolHeadDrill = new MaterialIconType("toolHeadDrill");
    public static final MaterialIconType toolHeadChainsaw = new MaterialIconType("toolHeadChainsaw");
    public static final MaterialIconType toolHeadScythe = new MaterialIconType("toolHeadScythe");
    public static final MaterialIconType toolHeadScrewdriver = new MaterialIconType("toolHeadScrewdriver");
    public static final MaterialIconType toolHeadWrench = new MaterialIconType("toolHeadWrench");
    public static final MaterialIconType turbineBlade = new MaterialIconType("turbineBlade");
    public static final MaterialIconType fluid = new MaterialIconType("fluid");
    public static final MaterialIconType ore = new MaterialIconType("ore");
    public static final MaterialIconType oreSmall = new MaterialIconType("oreSmall");
    public static final MaterialIconType block = new MaterialIconType("block");
    public static final MaterialIconType frameGt = new MaterialIconType("frameGt");
    public static final MaterialIconType seed = new MaterialIconType("seed");
    public static final MaterialIconType crop = new MaterialIconType("crop");
    public static final MaterialIconType essence = new MaterialIconType("essence");
    private static final Table<MaterialIconType, MaterialIconSet, ResourceLocation> ITEM_MODEL_CACHE = HashBasedTable.create();
    private static final Table<MaterialIconType, MaterialIconSet, ResourceLocation> BLOCK_TEXTURE_CACHE = HashBasedTable.create();
    private static final Table<MaterialIconType, MaterialIconSet, ResourceLocation> BLOCK_MODEL_CACHE = HashBasedTable.create();
    private static final String BLOCK_TEXTURE_PATH_FULL = "textures/blocks/material_sets/%s/%s.png";
    private static final String BLOCK_TEXTURE_PATH = "blocks/material_sets/%s/%s";
    private static final String ITEM_MODEL_PATH_FULL = "models/item/material_sets/%s/%s.json";
    private static final String ITEM_MODEL_PATH = "material_sets/%s/%s";
    private static final String BLOCK_MODEL_PATH_FULL = "models/block/material_sets/%s/%s.json";
    private static final String BLOCK_MODEL_PATH = "block/material_sets/%s/%s";
    public final String name;
    public final int id;

    public MaterialIconType(String name) {
        this.name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        Preconditions.checkArgument((!ICON_TYPES.containsKey(this.name) ? 1 : 0) != 0, (Object)("MaterialIconType " + this.name + " already registered!"));
        this.id = idCounter++;
        ICON_TYPES.put(this.name, this);
    }

    @Nonnull
    public ResourceLocation getBlockTexturePath(@Nonnull MaterialIconSet materialIconSet) {
        return this.recurseIconsetPath(materialIconSet, BLOCK_TEXTURE_CACHE, BLOCK_TEXTURE_PATH_FULL, BLOCK_TEXTURE_PATH);
    }

    @Nonnull
    public ResourceLocation getItemModelPath(@Nonnull MaterialIconSet materialIconSet) {
        return this.recurseIconsetPath(materialIconSet, ITEM_MODEL_CACHE, ITEM_MODEL_PATH_FULL, ITEM_MODEL_PATH);
    }

    @Nonnull
    public ResourceLocation getBlockModelPath(@Nonnull MaterialIconSet materialIconSet) {
        return this.recurseIconsetPath(materialIconSet, BLOCK_MODEL_CACHE, BLOCK_MODEL_PATH_FULL, BLOCK_MODEL_PATH);
    }

    @Nonnull
    public ResourceLocation recurseIconsetPath(@Nonnull MaterialIconSet iconSet, @Nonnull Table<MaterialIconType, MaterialIconSet, ResourceLocation> cache, @Nonnull String fullPath, @Nonnull String path) {
        ResourceLocation fullLocation;
        if (cache.contains((Object)this, (Object)iconSet)) {
            return (ResourceLocation)cache.get((Object)this, (Object)iconSet);
        }
        if (!iconSet.isRootIconset && FMLCommonHandler.instance().getSidedDelegate() != null && FMLCommonHandler.instance().getSide().isClient() && !ResourceHelper.doResourcepacksHaveResource(fullLocation = new ResourceLocation("gregtech", String.format(fullPath, iconSet.name, this.name)))) {
            ResourceLocation iconSetPath = this.recurseIconsetPath(iconSet.parentIconset, cache, fullPath, path);
            cache.put((Object)this, (Object)iconSet, (Object)iconSetPath);
            return iconSetPath;
        }
        ResourceLocation iconSetPath = new ResourceLocation("gregtech", String.format(path, iconSet.name, this.name));
        cache.put((Object)this, (Object)iconSet, (Object)iconSetPath);
        return iconSetPath;
    }

    public String toString() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        ITEM_MODEL_CACHE.clear();
        BLOCK_TEXTURE_CACHE.clear();
    }
}

