/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.enchantment.Enchantment;

public class ToolProperty
implements IMaterialProperty<ToolProperty> {
    private float harvestSpeed;
    private float attackDamage;
    private float attackSpeed;
    private int durability;
    private int harvestLevel;
    private int enchantability = 10;
    private boolean ignoreCraftingTools;
    private boolean isUnbreakable;
    private boolean isMagnetic;
    private int durabilityMultiplier = 1;
    private final Object2IntMap<Enchantment> enchantments = new Object2IntArrayMap();

    public ToolProperty(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
        this.harvestSpeed = harvestSpeed;
        this.attackDamage = attackDamage;
        this.durability = durability;
        this.harvestLevel = harvestLevel;
    }

    public ToolProperty() {
        this(1.0f, 1.0f, 100, 2);
    }

    public float getToolSpeed() {
        return this.harvestSpeed;
    }

    public void setToolSpeed(float toolSpeed) {
        this.harvestSpeed = toolSpeed;
    }

    public float getToolAttackDamage() {
        return this.attackDamage;
    }

    public void setToolAttackDamage(float toolAttackDamage) {
        this.attackDamage = toolAttackDamage;
    }

    public float getToolAttackSpeed() {
        return this.attackSpeed;
    }

    public void setToolAttackSpeed(float toolAttackSpeed) {
        this.attackSpeed = toolAttackSpeed;
    }

    public int getToolDurability() {
        return this.durability;
    }

    public void setToolDurability(int toolDurability) {
        this.durability = toolDurability;
    }

    public int getToolHarvestLevel() {
        return this.harvestLevel;
    }

    public void setToolHarvestLevel(int toolHarvestLevel) {
        this.harvestLevel = toolHarvestLevel;
    }

    public int getToolEnchantability() {
        return this.enchantability;
    }

    public void setToolEnchantability(int toolEnchantability) {
        this.enchantability = toolEnchantability;
    }

    public boolean getShouldIgnoreCraftingTools() {
        return this.ignoreCraftingTools;
    }

    public void setShouldIgnoreCraftingTools(boolean ignore) {
        this.ignoreCraftingTools = ignore;
    }

    public boolean getUnbreakable() {
        return this.isUnbreakable;
    }

    public void setUnbreakable(boolean isUnbreakable) {
        this.isUnbreakable = isUnbreakable;
    }

    public Object2IntMap<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    public void setMagnetic(boolean isMagnetic) {
        this.isMagnetic = isMagnetic;
    }

    public boolean isMagnetic() {
        return this.isMagnetic;
    }

    public void setDurabilityMultiplier(int multiplier) {
        this.durabilityMultiplier = multiplier;
    }

    public int getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (!properties.hasProperty(PropertyKey.GEM)) {
            properties.ensureSet(PropertyKey.INGOT, true);
        }
    }

    public void addEnchantmentForTools(Enchantment enchantment, int level) {
        this.enchantments.put((Object)enchantment, level);
    }

    public static class Builder {
        private final ToolProperty toolProperty;

        public static Builder of(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
            return new Builder(harvestSpeed, attackDamage, durability, harvestLevel);
        }

        private Builder(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
            this.toolProperty = new ToolProperty(harvestSpeed, attackDamage, durability, harvestLevel);
        }

        public Builder enchantability(int enchantability) {
            this.toolProperty.setToolEnchantability(enchantability);
            return this;
        }

        public Builder attackSpeed(float attackSpeed) {
            this.toolProperty.setToolAttackSpeed(attackSpeed);
            return this;
        }

        public Builder ignoreCraftingTools() {
            this.toolProperty.setShouldIgnoreCraftingTools(true);
            return this;
        }

        public Builder unbreakable() {
            this.toolProperty.setUnbreakable(true);
            return this;
        }

        public Builder enchantment(Enchantment enchantment, int level) {
            this.toolProperty.addEnchantmentForTools(enchantment, level);
            return this;
        }

        public Builder magnetic() {
            this.toolProperty.setMagnetic(true);
            return this;
        }

        public Builder durabilityMultiplier(int multiplier) {
            this.toolProperty.setDurabilityMultiplier(multiplier);
            return this;
        }

        public ToolProperty build() {
            return this.toolProperty;
        }
    }
}

