/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.stack;

import crafttweaker.annotations.ZenRegister;
import gregtech.api.unification.material.Material;
import gregtech.api.util.SmallDigits;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.material.MaterialStack")
@ZenRegister
public class MaterialStack {
    @ZenProperty
    public final Material material;
    @ZenProperty
    public final long amount;

    public MaterialStack(Material material, long amount) {
        this.material = material;
        this.amount = amount;
    }

    @ZenMethod
    public MaterialStack copy(long amount) {
        return new MaterialStack(this.material, amount);
    }

    @ZenMethod
    public MaterialStack copy() {
        return new MaterialStack(this.material, this.amount);
    }

    @ZenMethod
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterialStack that = (MaterialStack)o;
        if (this.amount != that.amount) {
            return false;
        }
        return this.material.equals(that.material);
    }

    public int hashCode() {
        return this.material.hashCode();
    }

    @ZenMethod
    public String toString() {
        String string = "";
        string = this.material.getChemicalFormula().isEmpty() ? string + "?" : (this.material.getMaterialComponents().size() > 1 ? string + '(' + this.material.getChemicalFormula() + ')' : string + this.material.getChemicalFormula());
        if (this.amount > 1L) {
            string = string + SmallDigits.toSmallDownNumbers(Long.toString(this.amount));
        }
        return string;
    }
}

