/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.damagesources.DamageSources;
import gregtech.core.advancement.AdvancementTriggers;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;

public class EntityDamageUtil {
    private static final int FROST_WALKER_ID = 9;

    public static void applyTemperatureDamage(@Nonnull EntityLivingBase entity, int temperature, float multiplier, int maximum) {
        if (temperature > 320) {
            int damage = (int)(multiplier * (float)(temperature - 300) / 50.0f);
            if (maximum > 0) {
                damage = Math.min(maximum, damage);
            }
            EntityDamageUtil.applyHeatDamage(entity, damage);
        } else if (temperature < 260) {
            int damage = (int)(multiplier * (float)(273 - temperature) / 25.0f);
            if (maximum > 0) {
                damage = Math.min(maximum, damage);
            }
            EntityDamageUtil.applyFrostDamage(entity, damage);
        }
    }

    public static void applyHeatDamage(@Nonnull EntityLivingBase entity, int damage) {
        if (damage <= 0) {
            return;
        }
        if (!entity.func_70089_S()) {
            return;
        }
        if (entity instanceof EntityBlaze || entity instanceof EntityMagmaCube || entity instanceof EntityWitherSkeleton || entity instanceof EntityWither) {
            return;
        }
        if (entity.func_70660_b(MobEffects.field_76426_n) != null) {
            return;
        }
        entity.func_70097_a(DamageSources.getHeatDamage(), (float)damage);
        if (entity instanceof EntityPlayerMP) {
            AdvancementTriggers.HEAT_DEATH.trigger((EntityPlayerMP)entity);
        }
    }

    public static void applyFrostDamage(@Nonnull EntityLivingBase entity, int damage) {
        if (damage <= 0) {
            return;
        }
        if (!entity.func_70089_S()) {
            return;
        }
        if (entity instanceof EntitySnowman || entity instanceof EntityPolarBear || entity instanceof EntityStray) {
            return;
        }
        ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.FEET);
        if (!stack.func_190926_b()) {
            for (NBTBase base : stack.func_77986_q()) {
                NBTTagCompound compound = (NBTTagCompound)base;
                if (compound.func_74765_d("id") != 9) continue;
                stack.func_77972_a(1, entity);
                return;
            }
        }
        entity.func_70097_a(DamageSources.getFrostDamage(), (float)damage);
        if (entity instanceof EntityPlayerMP) {
            AdvancementTriggers.COLD_DEATH.trigger((EntityPlayerMP)entity);
        }
    }

    public static void applyChemicalDamage(@Nonnull EntityLivingBase entity, int damage) {
        if (damage <= 0) {
            return;
        }
        if (!entity.func_70089_S()) {
            return;
        }
        if (entity instanceof AbstractSkeleton) {
            return;
        }
        entity.func_70097_a(DamageSources.getChemicalDamage(), (float)damage);
        entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, damage * 100, 1));
        if (entity instanceof EntityPlayerMP) {
            AdvancementTriggers.CHEMICAL_DEATH.trigger((EntityPlayerMP)entity);
        }
    }
}

