/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.fluids.fluidType.FluidTypes;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidTooltipUtil {
    private static final Map<Fluid, List<String>> tooltips = new HashMap<Fluid, List<String>>();

    public static void registerTooltip(Fluid fluid, String tooltip) {
        if (fluid != null && tooltip != null) {
            tooltips.computeIfAbsent(fluid, k -> new ArrayList()).add(tooltip);
        }
    }

    public static void registerTooltip(Fluid fluid, List<String> tooltip) {
        if (fluid != null && tooltip != null && !tooltip.isEmpty()) {
            tooltips.put(fluid, tooltip);
        }
    }

    public static List<String> getFluidTooltip(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        return tooltips.get(fluid);
    }

    public static List<String> getFluidTooltip(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return FluidTooltipUtil.getFluidTooltip(stack.getFluid());
    }

    public static List<String> getFluidTooltip(String fluidName) {
        if (fluidName == null || fluidName.isEmpty()) {
            return null;
        }
        return FluidTooltipUtil.getFluidTooltip(FluidRegistry.getFluid((String)fluidName));
    }

    @Nonnull
    public static List<String> getWaterTooltip() {
        return FluidTooltipUtil.getMaterialTooltip(Materials.Water, Materials.Water.getProperty(PropertyKey.FLUID).getFluidTemperature(), false);
    }

    @Nonnull
    public static List<String> getLavaTooltip() {
        return FluidTooltipUtil.getMaterialTooltip(Materials.Lava, Materials.Lava.getProperty(PropertyKey.FLUID).getFluidTemperature(), false);
    }

    @Nonnull
    public static List<String> getMaterialTooltip(@Nonnull Material material, int temperature, boolean isPlasma) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (!material.getChemicalFormula().isEmpty()) {
            tooltip.add(TextFormatting.YELLOW + material.getChemicalFormula());
        }
        tooltip.add(LocalizationUtils.format("gregtech.fluid.temperature", temperature));
        if (isPlasma) {
            tooltip.add(LocalizationUtils.format(FluidTypes.PLASMA.getUnlocalizedTooltip(), new Object[0]));
        } else {
            tooltip.add(LocalizationUtils.format(material.getProperty(PropertyKey.FLUID).getFluidType().getUnlocalizedTooltip(), new Object[0]));
        }
        tooltip.addAll(material.getProperty(PropertyKey.FLUID).getFluidType().getAdditionalTooltips());
        if (temperature < 120) {
            tooltip.add(LocalizationUtils.format("gregtech.fluid.temperature.cryogenic", new Object[0]));
        }
        return tooltip;
    }
}

