/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GTLog;
import gregtech.api.worldgen.config.OreDepositDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;

public class GTJEIUtility {
    private static final int FONT_HEIGHT = Minecraft.func_71410_x().field_71466_p.field_78288_b;

    public static List<String> createSpawnPageBiomeTooltip(Function<Biome, Integer> biomeFunction, int originalWeight) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (biomeFunction == OreDepositDefinition.NO_BIOME_INFLUENCE) {
            return tooltip;
        }
        Iterator biomeIterator = Biome.field_185377_q.iterator();
        HashMap<Biome, Integer> modifiedBiomeMap = new HashMap<Biome, Integer>();
        while (biomeIterator.hasNext()) {
            Biome biome = (Biome)biomeIterator.next();
            int biomeWeight = biomeFunction.apply(biome);
            if (biomeWeight == originalWeight) continue;
            modifiedBiomeMap.put(biome, originalWeight + biomeWeight);
        }
        if (!modifiedBiomeMap.isEmpty()) {
            tooltip.add("\u00a7\n");
            tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.biome_weighting_title", (Object[])new Object[0]));
        }
        for (Map.Entry entry : modifiedBiomeMap.entrySet()) {
            if ((Integer)entry.getValue() == originalWeight) continue;
            if ((Integer)entry.getValue() <= 0) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.biome_weighting_no_spawn", (Object[])new Object[]{((Biome)entry.getKey()).func_185359_l()}));
                continue;
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.biome_weighting", (Object[])new Object[]{((Biome)entry.getKey()).func_185359_l(), entry.getValue()}));
        }
        return tooltip;
    }

    public static void drawMultiLineCommaSeparatedDimensionList(Map<Integer, String> namedDimensions, List<Integer> dimensionIDs, FontRenderer fontRenderer, int dimStartXPos, int dimStartYPos, int dimDisplayPosX) {
        for (int i = 0; i < dimensionIDs.size(); ++i) {
            String fullDimName;
            boolean isLastDimension;
            boolean bl = isLastDimension = i == dimensionIDs.size() - 1;
            if (namedDimensions.containsKey(dimensionIDs.get(i))) {
                String dimName = namedDimensions.get(dimensionIDs.get(i));
                fullDimName = isLastDimension ? dimensionIDs.get(i) + " (" + dimName + ")" : dimensionIDs.get(i) + " (" + dimName + "), ";
            } else {
                fullDimName = isLastDimension ? Integer.toString(dimensionIDs.get(i)) : dimensionIDs.get(i) + ", ";
            }
            int dimDisplayLength = fontRenderer.func_78256_a(fullDimName);
            if (dimDisplayLength > 176 - dimDisplayPosX) {
                dimStartYPos += FONT_HEIGHT;
                dimDisplayPosX = dimStartXPos;
            }
            fontRenderer.func_78276_b(fullDimName, dimDisplayPosX, dimStartYPos, 0x111111);
            dimDisplayPosX += dimDisplayLength;
        }
    }

    public static void cleanupDimensionList(Supplier<List<Integer>> dimensions) {
        if (Loader.isModLoaded((String)"advancedrocketry")) {
            try {
                int[] spaceDims = DimensionManager.getDimensions((DimensionType)DimensionType.func_193417_a((String)"space"));
                for (int i = 0; i < spaceDims.length; ++i) {
                    if (!dimensions.get().contains(spaceDims[i])) continue;
                    dimensions.get().remove(spaceDims[i]);
                }
            }
            catch (IllegalArgumentException e) {
                GTLog.logger.error("Something went wrong with AR JEI integration, No DimensionType found");
                GTLog.logger.error((Object)e);
            }
        }
    }
}

