/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.DataSerializerEntry;

public class NBTUtil {
    public static final DataSerializer<Vec3d> VECTOR = new DataSerializer<Vec3d>(){

        public void write(PacketBuffer buf, Vec3d value) {
            buf.writeFloat((float)value.field_72450_a);
            buf.writeFloat((float)value.field_72448_b);
            buf.writeFloat((float)value.field_72449_c);
        }

        public Vec3d read(PacketBuffer buf) {
            return new Vec3d((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
        }

        public DataParameter<Vec3d> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Vec3d copyValue(Vec3d value) {
            return new Vec3d(value.field_72450_a, value.field_72448_b, value.field_72449_c);
        }
    };

    public static void registerSerializers() {
        ForgeRegistries.DATA_SERIALIZERS.register(new DataSerializerEntry(VECTOR).setRegistryName("vector"));
    }

    public static Vec3d readVec3d(NBTTagCompound tag) {
        return new Vec3d((double)tag.func_74760_g("X"), (double)tag.func_74760_g("Y"), (double)tag.func_74760_g("Z"));
    }

    public static NBTTagCompound writeVec3d(Vec3d vector) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("X", (float)vector.field_72450_a);
        tag.func_74776_a("Y", (float)vector.field_72448_b);
        tag.func_74776_a("Z", (float)vector.field_72449_c);
        return tag;
    }
}

