/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

public class RedstoneUtil {
    public static int computeRedstoneBetweenValues(int value, float maxValue, float minValue, boolean isInverted) {
        if ((float)value >= maxValue) {
            return isInverted ? 0 : 15;
        }
        if ((float)value <= minValue) {
            return isInverted ? 15 : 0;
        }
        float ratio = !isInverted ? 15.0f * ((float)value - minValue) / (maxValue - minValue) : 15.0f * (maxValue - (float)value) / (maxValue - minValue);
        return Math.round(ratio);
    }

    public static int computeLatchedRedstoneBetweenValues(float value, float maxValue, float minValue, boolean isInverted, int output) {
        if (value >= maxValue) {
            output = !isInverted ? 0 : 15;
        } else if (value <= minValue) {
            output = !isInverted ? 15 : 0;
        }
        return output;
    }

    public static int computeRedstoneValue(long current, long max, boolean isInverted) throws ArithmeticException {
        int outputAmount = (int)(15L * current / max);
        if (isInverted) {
            outputAmount = 15 - outputAmount;
        }
        return outputAmount;
    }
}

