/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GTLog;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class VirtualTankRegistry
extends WorldSavedData {
    private static final int DEFAULT_CAPACITY = 64000;
    private static final String DATA_ID = "gregtech.vtank_data";
    protected static Map<UUID, Map<String, IFluidTank>> tankMap = new HashMap<UUID, Map<String, IFluidTank>>();

    public VirtualTankRegistry() {
        super(DATA_ID);
    }

    public VirtualTankRegistry(String name) {
        super(name);
    }

    public static IFluidTank getTank(String key, UUID uuid) {
        return tankMap.get(uuid).get(key);
    }

    public static Map<UUID, Map<String, IFluidTank>> getTankMap() {
        return tankMap;
    }

    public static IFluidTank getTankCreate(String key, UUID uuid, int capacity) {
        if (!tankMap.containsKey(uuid) || !tankMap.get(uuid).containsKey(key)) {
            VirtualTankRegistry.addTank(key, uuid, capacity);
        }
        return VirtualTankRegistry.getTank(key, uuid);
    }

    public static IFluidTank getTankCreate(String key, UUID uuid) {
        return VirtualTankRegistry.getTankCreate(key, uuid, 64000);
    }

    public static void addTank(String key, UUID uuid, int capacity) {
        if (tankMap.containsKey(uuid) && tankMap.get(uuid).containsKey(key)) {
            GTLog.logger.warn("Overwriting virtual tank " + key + "/" + (uuid == null ? "null" : uuid.toString()) + ", this might cause fluid loss!");
        } else if (!tankMap.containsKey(uuid)) {
            tankMap.put(uuid, new HashMap());
        }
        tankMap.get(uuid).put(key, new VirtualTank(capacity));
    }

    public static void addTank(String key, UUID uuid) {
        VirtualTankRegistry.addTank(key, uuid, 64000);
    }

    public static void delTank(String key, UUID uuid, boolean removeFluid) {
        if (tankMap.containsKey(uuid) && tankMap.get(uuid).containsKey(key)) {
            if (removeFluid || tankMap.get(uuid).get(key).getFluidAmount() <= 0) {
                tankMap.get(uuid).remove(key);
                if (tankMap.get(uuid).size() == 0) {
                    tankMap.remove(uuid);
                }
            }
        } else {
            GTLog.logger.warn("Attempted to delete tank " + key + "/" + (uuid == null ? "null" : uuid.toString()) + ", which does not exist!");
        }
    }

    public static void clearMaps() {
        tankMap.clear();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Public")) {
            NBTTagCompound publicTanks = nbt.func_74775_l("Public");
            for (String key : publicTanks.func_150296_c()) {
                NBTTagCompound tankCompound = publicTanks.func_74775_l(key);
                VirtualTankRegistry.addTank(key, null, tankCompound.func_74762_e("Capacity"));
                if (tankCompound.func_74764_b("Empty")) continue;
                VirtualTankRegistry.getTank(key, null).fill(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankCompound), true);
            }
        }
        if (nbt.func_74764_b("Private")) {
            NBTTagCompound privateTankUUIDs = nbt.func_74775_l("Private");
            for (String uuidStr : privateTankUUIDs.func_150296_c()) {
                UUID uuid = UUID.fromString(uuidStr);
                NBTTagCompound privateTanks = privateTankUUIDs.func_74775_l(uuidStr);
                for (String key : privateTanks.func_150296_c()) {
                    NBTTagCompound tankCompound = privateTanks.func_74775_l(key);
                    VirtualTankRegistry.addTank(key, uuid, tankCompound.func_74762_e("Capacity"));
                    if (tankCompound.func_74764_b("Empty")) continue;
                    VirtualTankRegistry.getTank(key, uuid).fill(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankCompound), true);
                }
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74782_a("Private", (NBTBase)new NBTTagCompound());
        tankMap.forEach((uuid, map) -> {
            NBTTagCompound mapCompound = new NBTTagCompound();
            map.forEach((key, tank) -> {
                if (tank.getFluid() != null || tank.getCapacity() != 64000) {
                    NBTTagCompound tankCompound = new NBTTagCompound();
                    tankCompound.func_74768_a("Capacity", tank.getCapacity());
                    if (tank.getFluid() != null) {
                        tank.getFluid().writeToNBT(tankCompound);
                    } else {
                        tankCompound.func_74778_a("Empty", "");
                    }
                    mapCompound.func_74782_a(key, (NBTBase)tankCompound);
                }
            });
            if (mapCompound.func_186856_d() > 0) {
                if (uuid == null) {
                    compound.func_74782_a("Public", (NBTBase)mapCompound);
                } else {
                    compound.func_74775_l("Private").func_74782_a(uuid.toString(), (NBTBase)mapCompound);
                }
            }
        });
        return compound;
    }

    public boolean func_76188_b() {
        return true;
    }

    public static void initializeStorage(World world) {
        MapStorage storage = world.func_175693_T();
        VirtualTankRegistry instance = (VirtualTankRegistry)storage.func_75742_a(VirtualTankRegistry.class, DATA_ID);
        if (instance == null) {
            instance = new VirtualTankRegistry();
            storage.func_75745_a(DATA_ID, (WorldSavedData)instance);
        }
    }

    private static class VirtualTank
    implements IFluidTank,
    IFluidHandler {
        @Nullable
        protected FluidStack fluid;
        protected int capacity;
        protected IFluidTankProperties[] tankProperties;

        public VirtualTank(int capacity) {
            this.capacity = capacity;
        }

        @Nullable
        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getFluidAmount() {
            return this.fluid == null ? 0 : this.fluid.amount;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public FluidTankInfo getInfo() {
            return new FluidTankInfo((IFluidTank)this);
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.tankProperties == null) {
                this.tankProperties = new IFluidTankProperties[]{new VirtualTankProperties(this)};
            }
            return this.tankProperties;
        }

        public int fill(FluidStack fluidStack, boolean doFill) {
            if (fluidStack == null || fluidStack.amount <= 0 || this.fluid != null && !fluidStack.isFluidEqual(this.fluid)) {
                return 0;
            }
            int fillAmt = Math.min(fluidStack.amount, this.capacity - this.getFluidAmount());
            if (doFill) {
                if (this.fluid == null) {
                    this.fluid = new FluidStack(fluidStack, fillAmt);
                } else {
                    this.fluid.amount += fillAmt;
                }
            }
            return fillAmt;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return resource == null || !resource.isFluidEqual(this.fluid) ? null : this.drain(resource.amount, doDrain);
        }

        @Nullable
        public FluidStack drain(int amount, boolean doDrain) {
            if (this.fluid == null || amount <= 0) {
                return null;
            }
            int drainAmt = Math.min(this.getFluidAmount(), amount);
            FluidStack drainedFluid = new FluidStack(this.fluid, drainAmt);
            if (doDrain) {
                this.fluid.amount -= drainAmt;
                if (this.fluid.amount <= 0) {
                    this.fluid = null;
                }
            }
            return drainedFluid;
        }

        private static class VirtualTankProperties
        implements IFluidTankProperties {
            protected final VirtualTank tank;

            private VirtualTankProperties(VirtualTank tank) {
                this.tank = tank;
            }

            @Nullable
            public FluidStack getContents() {
                FluidStack contents = this.tank.getFluid();
                return contents == null ? null : contents.copy();
            }

            public int getCapacity() {
                return this.tank.getCapacity();
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrain() {
                return true;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return true;
            }
        }
    }
}

