/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.oreglob;

import gregtech.api.unification.OreDictUnifier;
import gregtech.api.util.oreglob.OreGlobCompileResult;
import gregtech.api.util.oreglob.OreGlobFormattedStringVisualizer;
import gregtech.api.util.oreglob.OreGlobStringVisualizer;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.item.ItemStack;

public abstract class OreGlob {
    private static Function<String, OreGlobCompileResult> compiler;

    public static OreGlobCompileResult compile(String expression) {
        if (compiler == null) {
            throw new IllegalStateException("Compiler unavailable");
        }
        return compiler.apply(expression);
    }

    public static void setCompiler(Function<String, OreGlobCompileResult> compiler) {
        OreGlob.compiler = compiler;
    }

    public abstract <V extends Visualizer> V visualize(V var1);

    public abstract boolean matches(String var1);

    public final boolean matches(ItemStack stack) {
        Set<String> oreDicts = OreDictUnifier.getOreDictionaryNames(stack);
        if (oreDicts.isEmpty()) {
            return this.matches("");
        }
        for (String oreDict : oreDicts) {
            if (!this.matches(oreDict)) continue;
            return true;
        }
        return false;
    }

    public final List<String> toFormattedString() {
        return this.toFormattedString("  ");
    }

    public final List<String> toFormattedString(String indent) {
        return this.visualize(new OreGlobFormattedStringVisualizer(indent)).getLines();
    }

    public final String toString() {
        return this.visualize(new OreGlobStringVisualizer()).toString();
    }

    public static enum VisualizationHint {
        PLAINTEXT,
        NODE,
        VALUE,
        NEGATION,
        LABEL,
        ERROR;

    }

    public static interface Visualizer {
        public void newLine(int var1);

        public void text(String var1, VisualizationHint var2);

        public void number(int var1, VisualizationHint var2);

        public void text(int var1, VisualizationHint var2);

        default public void text(String text) {
            this.text(text, VisualizationHint.PLAINTEXT);
        }

        default public void number(int number) {
            this.number(number, VisualizationHint.VALUE);
        }

        default public void text(int codePoint) {
            this.text(codePoint, VisualizationHint.PLAINTEXT);
        }
    }
}

