/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.oreglob;

import gregtech.api.util.oreglob.OreGlob;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class OreGlobFormattedStringVisualizer
implements OreGlob.Visualizer {
    private final StringBuilder stb = new StringBuilder();
    private final List<String> lines = new ArrayList<String>();
    private final String indent;
    @Nullable
    private TextFormatting lastFormatting;

    public OreGlobFormattedStringVisualizer(String indent) {
        this.indent = indent;
    }

    @Override
    public void newLine(int indents) {
        this.finishLine();
        for (int i = 0; i < indents; ++i) {
            this.stb.append(this.indent);
        }
    }

    @Override
    public void text(String text, OreGlob.VisualizationHint hint) {
        this.format(hint);
        this.stb.append(text);
    }

    @Override
    public void number(int number, OreGlob.VisualizationHint hint) {
        this.format(hint);
        this.stb.append(number);
    }

    @Override
    public void text(int codePoint, OreGlob.VisualizationHint hint) {
        this.format(hint);
        this.stb.appendCodePoint(codePoint);
    }

    public List<String> getLines() {
        this.finishLine();
        return this.lines;
    }

    private void finishLine() {
        this.lines.add(this.stb.append(TextFormatting.RESET).toString());
        this.stb.delete(0, this.stb.length());
        this.lastFormatting = null;
    }

    private void format(OreGlob.VisualizationHint hint) {
        TextFormatting fmt = this.textFormatting(hint);
        if (this.lastFormatting == fmt) {
            return;
        }
        this.lastFormatting = fmt;
        this.stb.append(fmt);
    }

    private TextFormatting textFormatting(OreGlob.VisualizationHint hint) {
        switch (hint) {
            case PLAINTEXT: 
            case LABEL: {
                return TextFormatting.GRAY;
            }
            case NODE: {
                return TextFormatting.WHITE;
            }
            case VALUE: {
                return TextFormatting.YELLOW;
            }
            case NEGATION: 
            case ERROR: {
                return TextFormatting.RED;
            }
        }
        throw new IllegalStateException("Unknown VisualizationHint value '" + (Object)((Object)hint) + "'");
    }
}

