/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.populator;

import com.google.gson.JsonObject;
import gregtech.api.fluids.MetaFluids;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTLog;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.generator.GridEntryInfo;
import gregtech.api.worldgen.populator.VeinChunkPopulator;
import gregtech.common.blocks.MetaBlocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class SurfaceRockPopulator
implements VeinChunkPopulator {
    private gregtech.api.unification.material.Material material;
    private int failedGenerationCounter = 0;

    public SurfaceRockPopulator() {
    }

    public SurfaceRockPopulator(gregtech.api.unification.material.Material material) {
        this.material = material;
    }

    @Override
    public void loadFromConfig(JsonObject object) {
        this.material = OreConfigUtils.getMaterialByName(object.get("material").getAsString());
    }

    @Override
    public void initializeForVein(OreDepositDefinition definition) {
    }

    private static Set<gregtech.api.unification.material.Material> findUndergroundMaterials(Collection<IBlockState> generatedBlocks) {
        HashSet<gregtech.api.unification.material.Material> result = new HashSet<gregtech.api.unification.material.Material>();
        for (IBlockState blockState : generatedBlocks) {
            ItemStack itemStack;
            UnificationEntry entry;
            Fluid fluid;
            gregtech.api.unification.material.Material resultMaterial = blockState.func_177230_c() instanceof IFluidBlock || blockState.func_177230_c() instanceof BlockLiquid ? ((fluid = FluidRegistry.lookupFluidForBlock((Block)blockState.func_177230_c())) == null ? null : MetaFluids.getMaterialFromFluid(fluid)) : ((entry = OreDictUnifier.getUnificationEntry(itemStack = new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_180651_a(blockState)))) != null && entry.material != null && entry.material.hasProperty(PropertyKey.ORE) ? entry.material : null);
            if (resultMaterial == null) continue;
            result.add(resultMaterial);
        }
        return result;
    }

    private void setStoneBlock(World world, BlockPos blockPos) {
        boolean surfaceRockPlaced = world.func_175656_a(blockPos, MetaBlocks.SURFACE_ROCK.get(this.material).getBlock(this.material));
        if (!surfaceRockPlaced) {
            ++this.failedGenerationCounter;
        }
    }

    @Override
    public void populateChunk(World world, int chunkX, int chunkZ, Random random, OreDepositDefinition definition, GridEntryInfo gridEntryInfo) {
        int stonesCount = random.nextInt(2) + 1;
        if (world.func_175624_G() != WorldType.field_77138_c) {
            if (SurfaceRockPopulator.findUndergroundMaterials(gridEntryInfo.getGeneratedBlocks(definition, chunkX, chunkZ)).isEmpty()) {
                return;
            }
            int baseX = chunkX * 16 + 8;
            int baseZ = chunkZ * 16 + 8;
            for (int i = 0; i < stonesCount; ++i) {
                int randomX = baseX + random.nextInt(8);
                int randomZ = baseZ + random.nextInt(8);
                this.generateSurfaceRock(world, new BlockPos(randomX, 0, randomZ));
            }
            this.generateSurfaceRock(world, gridEntryInfo.getCenterPos(definition));
        }
        if (this.failedGenerationCounter == stonesCount && world.func_175624_G() != WorldType.field_77138_c) {
            GTLog.logger.debug("Failed to generate surface rocks for vein {} at chunk with position: x: {}, z: {}", (Object)definition.getDepositName(), (Object)chunkX, (Object)chunkZ);
        }
    }

    public void generateSurfaceRock(World world, BlockPos pos) {
        BlockPos topBlockPos = SurfaceRockPopulator.findSpawnHeight(world, pos);
        if (topBlockPos.func_177956_o() <= 20) {
            return;
        }
        Block blockAtPos = world.func_180495_p(topBlockPos).func_177230_c();
        if (topBlockPos.func_177956_o() >= world.field_73011_w.getActualHeight()) {
            return;
        }
        if (!blockAtPos.func_176200_f((IBlockAccess)world, topBlockPos) || world.func_180495_p(topBlockPos).func_185904_a().func_76224_d()) {
            return;
        }
        this.setStoneBlock(world, topBlockPos);
    }

    public gregtech.api.unification.material.Material getMaterial() {
        return this.material;
    }

    public static BlockPos findSpawnHeight(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        BlockPos.PooledMutableBlockPos blockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        blockpos.func_181079_c(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        int airBlocks = 0;
        while (blockpos.func_177956_o() > 20) {
            blockpos.func_189536_c(EnumFacing.DOWN);
            IBlockState state = chunk.func_177435_g((BlockPos)blockpos);
            if (state.func_185904_a() == Material.field_151579_a || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151582_l || state.func_177230_c().isFoliage((IBlockAccess)world, (BlockPos)blockpos)) {
                ++airBlocks;
                continue;
            }
            if (airBlocks >= 10 && state.isSideSolid((IBlockAccess)world, (BlockPos)blockpos, EnumFacing.UP)) {
                blockpos.func_189536_c(EnumFacing.UP);
                break;
            }
            airBlocks = 0;
        }
        pos = blockpos.func_185334_h();
        blockpos.func_185344_t();
        return pos;
    }
}

