/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.shape;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.worldgen.shape.EllipsoidGenerator;
import gregtech.api.worldgen.shape.IBlockGeneratorAccess;
import net.minecraft.util.math.Vec3i;

public class LayeredGenerator
extends EllipsoidGenerator {
    private int yRadius;

    @Override
    public void loadFromConfig(JsonObject object) {
        super.loadFromConfig(object);
        JsonElement element = object.get("layers");
        this.yRadius = element != null ? element.getAsInt() / 2 : 3;
    }

    @Override
    public int getYRadius() {
        return this.yRadius;
    }

    @Override
    public Vec3i getMaxSize() {
        Vec3i result = super.getMaxSize();
        return new Vec3i(result.func_177958_n(), this.yRadius, result.func_177952_p());
    }

    @Override
    public void generateBlock(int x, int y, int z, IBlockGeneratorAccess blockAccess) {
        blockAccess.generateBlock(x, y, z, false);
    }
}

