/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model;

import gregtech.api.block.VariantActiveBlock;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.RenderUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="gregtech", value={Side.CLIENT})
public class ActiveVariantBlockBakedModel
implements IBakedModel {
    private static final Map<ModelResourceLocation, ActiveVariantBlockBakedModel> INSTANCES = new Object2ObjectOpenHashMap();
    private static final String[] BLOOM_TEXTURE_SUFFIX = new String[]{"_bloom", "_emissive", "_bloom_ctm", "_emissive_ctm"};
    private final ModelResourceLocation inactiveModelLocation;
    private final ModelResourceLocation activeModelLocation;
    @Nullable
    private final BooleanSupplier bloomConfig;
    private final ModelResourceLocation modelLocation;

    public ActiveVariantBlockBakedModel(ModelResourceLocation inactiveModelLocation, ModelResourceLocation activeModelLocation, @Nullable BooleanSupplier bloomConfig) {
        this.inactiveModelLocation = inactiveModelLocation;
        this.activeModelLocation = activeModelLocation;
        this.bloomConfig = bloomConfig;
        this.modelLocation = new ModelResourceLocation(new ResourceLocation("gregtech", "active_variant_block_" + inactiveModelLocation.func_110624_b() + "_" + inactiveModelLocation.func_110623_a()), inactiveModelLocation.func_177518_c().replaceAll(",active=(?:true|false)|active=(?:true|false),?", ""));
        INSTANCES.put(this.modelLocation, this);
    }

    public ModelResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    protected boolean getBloomConfig() {
        return this.bloomConfig == null || this.bloomConfig.getAsBoolean();
    }

    protected IBakedModel getModel(IBlockState state) {
        return this.getModel(Boolean.TRUE.equals(((IExtendedBlockState)state).getValue((IUnlistedProperty)VariantActiveBlock.ACTIVE)));
    }

    protected IBakedModel getModel(boolean active) {
        return Minecraft.func_71410_x().field_175618_aM.func_175023_a().func_178126_b().func_174953_a(active ? this.activeModelLocation : this.inactiveModelLocation);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null) {
            return Collections.emptyList();
        }
        IBakedModel m = this.getModel(state);
        if (this.getBloomConfig()) {
            return MinecraftForgeClient.getRenderLayer() == BloomEffectUtil.BLOOM ? ActiveVariantBlockBakedModel.getBloomQuads(m, state, side, rand) : m.func_188616_a(state, side, rand);
        }
        if (MinecraftForgeClient.getRenderLayer() == BloomEffectUtil.BLOOM) {
            return Collections.emptyList();
        }
        if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(m.func_188616_a(state, side, rand));
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)BloomEffectUtil.BLOOM);
            quads.addAll(ActiveVariantBlockBakedModel.getBloomQuads(m, state, side, rand));
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.CUTOUT);
            return quads;
        }
        return m.func_188616_a(state, side, rand);
    }

    private static List<BakedQuad> getBloomQuads(IBakedModel model, @Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        block0: for (BakedQuad q : model.func_188616_a(state, side, rand)) {
            for (String bloomTextureSuffix : BLOOM_TEXTURE_SUFFIX) {
                if (!q.func_187508_a().func_94215_i().endsWith(bloomTextureSuffix)) continue;
                list.add(RenderUtil.makeEmissive(q));
                continue block0;
            }
        }
        return list;
    }

    public boolean func_177555_b() {
        return this.getModel(false).func_177555_b();
    }

    public boolean isAmbientOcclusion(@Nonnull IBlockState state) {
        return this.getModel(state).func_177555_b();
    }

    public boolean func_177556_c() {
        return this.getModel(false).func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.getModel(false).func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        INSTANCES.forEach((arg_0, arg_1) -> ((IRegistry)event.getModelRegistry()).func_82595_a(arg_0, arg_1));
    }
}

