/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model;

import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.StoneType;
import gregtech.client.model.EmissiveOreBakedModel;
import gregtech.client.model.ModelFactory;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="gregtech", value={Side.CLIENT})
public class OreBakedModel
implements IBakedModel {
    private static final Map<Entry, ModelResourceLocation> ENTRIES = new Object2ObjectOpenHashMap();
    protected final StoneType stoneType;
    protected final IBakedModel overlay;
    private IBakedModel baseModel;

    public static ModelResourceLocation registerOreEntry(StoneType stoneType, Material material) {
        return ENTRIES.computeIfAbsent(new Entry(stoneType, material.getMaterialIconSet(), material.getProperty(PropertyKey.ORE).isEmissive()), Entry::getModelId);
    }

    public OreBakedModel(StoneType stoneType, IBakedModel overlay) {
        this.stoneType = stoneType;
        this.overlay = overlay;
    }

    protected IBakedModel getBaseModel() {
        if (this.baseModel == null) {
            this.baseModel = Minecraft.func_71410_x().field_175618_aM.func_184389_a(this.stoneType.stone.get());
            return this.baseModel;
        }
        return this.baseModel;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.getBaseModel().func_188616_a(null, side, 0L));
        quads.addAll(this.overlay.func_188616_a(null, side, rand));
        return quads;
    }

    public boolean func_177555_b() {
        return this.getBaseModel().func_177555_b();
    }

    public boolean func_177556_c() {
        return this.getBaseModel().func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getBaseModel().func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.getBaseModel().func_177552_f();
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.getBaseModel().isAmbientOcclusion(state);
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        for (Map.Entry<Entry, ModelResourceLocation> e : ENTRIES.entrySet()) {
            event.getMap().func_174942_a(MaterialIconType.ore.getBlockTexturePath(e.getKey().iconSet));
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        Object2ObjectOpenHashMap overlayCache = new Object2ObjectOpenHashMap();
        for (Map.Entry<Entry, ModelResourceLocation> e : ENTRIES.entrySet()) {
            IBakedModel overlay = overlayCache.computeIfAbsent(MaterialIconType.ore.getBlockTexturePath(e.getKey().iconSet), tex -> new ModelFactory(ModelFactory.ModelTemplate.ORE_OVERLAY).addSprite("texture", (ResourceLocation)tex).bake());
            event.getModelRegistry().func_82595_a((Object)e.getValue(), (Object)(e.getKey().emissive ? new EmissiveOreBakedModel(e.getKey().stoneType, overlay) : new OreBakedModel(e.getKey().stoneType, overlay)));
        }
    }

    private static final class Entry {
        private final StoneType stoneType;
        private final MaterialIconSet iconSet;
        private final boolean emissive;
        private final int hash;

        private Entry(StoneType stoneType, MaterialIconSet iconSet, boolean emissive) {
            this.stoneType = stoneType;
            this.iconSet = iconSet;
            this.emissive = emissive;
            this.hash = Objects.hash(stoneType.name, iconSet.name, emissive);
        }

        public ModelResourceLocation getModelId() {
            return new ModelResourceLocation(new ResourceLocation("gregtech", "ore_" + this.stoneType.name + "_" + this.iconSet.name + (this.emissive ? "_emissive" : "")), "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.stoneType.name.equals(entry.stoneType.name) && this.iconSet.name.equals(entry.iconSet.name) && this.emissive == entry.emissive;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "stoneType=" + this.stoneType.name + ", iconSet=" + this.iconSet.name + ", emissive=" + this.emissive;
        }
    }
}

