/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.customtexture;

import com.google.common.collect.Sets;
import com.google.gson.JsonParseException;
import gregtech.client.model.customtexture.CustomTextureBakedModel;
import gregtech.client.model.customtexture.CustomTextureModel;
import gregtech.client.model.customtexture.MetadataSectionCTM;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum CustomTextureModelHandler implements IResourceManagerReloadListener
{
    INSTANCE;

    private final Set<ResourceLocation> wrappedModels = Sets.newHashSet();
    private static final Map<ResourceLocation, MetadataSectionCTM> METADATA_CACHE;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelBakeEvent event) {
        Map stateModels = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (String)"stateModels");
        block2: for (ModelResourceLocation mrl : event.getModelRegistry().func_148742_b()) {
            IModel rootModel;
            if (this.wrappedModels.contains(mrl) || (rootModel = (IModel)stateModels.get(mrl)) == null || rootModel instanceof CustomTextureModel) continue;
            HashSet textures = Sets.newHashSet((Iterable)rootModel.getTextures());
            for (ResourceLocation tex : textures) {
                MetadataSectionCTM meta = null;
                try {
                    meta = CustomTextureModelHandler.getMetadata(CustomTextureModelHandler.spriteToAbsolute(tex));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (meta == null) continue;
                this.wrappedModels.add((ResourceLocation)mrl);
                event.getModelRegistry().func_82595_a((Object)mrl, (Object)CustomTextureModelHandler.wrap(rootModel, (IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl)));
                continue block2;
            }
        }
    }

    @Nonnull
    private static IBakedModel wrap(IModel model, IBakedModel object) {
        CustomTextureModel ctm = new CustomTextureModel(null, model);
        ctm.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, rl -> Minecraft.func_71410_x().func_147117_R().func_110572_b(rl.toString()));
        return new CustomTextureBakedModel(ctm, object);
    }

    public static ResourceLocation spriteToAbsolute(ResourceLocation sprite) {
        if (!sprite.func_110623_a().startsWith("textures/")) {
            sprite = new ResourceLocation(sprite.func_110624_b(), "textures/" + sprite.func_110623_a());
        }
        if (!sprite.func_110623_a().endsWith(".png")) {
            sprite = new ResourceLocation(sprite.func_110624_b(), sprite.func_110623_a() + ".png");
        }
        return sprite;
    }

    @Nullable
    public static MetadataSectionCTM getMetadata(ResourceLocation res) throws IOException {
        MetadataSectionCTM ret;
        if (METADATA_CACHE.containsKey(res)) {
            return METADATA_CACHE.get(res);
        }
        try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(res);){
            ret = (MetadataSectionCTM)resource.func_110526_a("ctm");
        }
        catch (FileNotFoundException e) {
            ret = null;
        }
        catch (JsonParseException e) {
            throw new IOException("Error loading metadata for location " + res, e);
        }
        METADATA_CACHE.put(res, ret);
        return ret;
    }

    @Nullable
    public static MetadataSectionCTM getMetadata(TextureAtlasSprite sprite) throws IOException {
        return CustomTextureModelHandler.getMetadata(CustomTextureModelHandler.spriteToAbsolute(new ResourceLocation(sprite.func_94215_i())));
    }

    public void func_110549_a(IResourceManager resourceManager) {
        METADATA_CACHE.clear();
        CustomTextureBakedModel.MODEL_CACHE.cleanUp();
        this.wrappedModels.clear();
    }

    static {
        METADATA_CACHE = new HashMap<ResourceLocation, MetadataSectionCTM>();
    }
}

