/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.customtexture;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MetadataSectionCTM
implements IMetadataSection {
    public static final String SECTION_NAME = "ctm";
    public BlockRenderLayer layer = null;
    public int skyLight = -1;
    public int blockLight = -1;

    public static MetadataSectionCTM fromJson(JsonObject obj) throws JsonParseException {
        JsonObject extraData;
        JsonElement layerEle;
        MetadataSectionCTM ret = new MetadataSectionCTM();
        if (!(obj.has("gregtech") && obj.get("gregtech").isJsonPrimitive() && obj.get("gregtech").getAsBoolean())) {
            return null;
        }
        if (obj.has("layer") && (layerEle = obj.get("layer")).isJsonPrimitive() && layerEle.getAsJsonPrimitive().isString()) {
            try {
                ret.layer = BlockRenderLayer.valueOf((String)layerEle.getAsString());
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Invalid block layer given: " + layerEle, (Throwable)e);
            }
        }
        if (obj.has("extra") && obj.get("extra").isJsonObject() && (extraData = obj.getAsJsonObject("extra")).has("light")) {
            if (extraData.get("light").isJsonPrimitive()) {
                JsonPrimitive light = extraData.getAsJsonPrimitive("light");
                if (light.isNumber()) {
                    ret.skyLight = light.getAsInt();
                    ret.blockLight = light.getAsInt();
                }
            } else if (extraData.get("light").isJsonObject()) {
                JsonObject light = extraData.getAsJsonObject("light");
                if (light.has("block") && light.get("block").isJsonPrimitive() && light.getAsJsonPrimitive("block").isNumber()) {
                    ret.blockLight = light.getAsJsonPrimitive("block").getAsInt();
                }
                if (light.has("sky") && light.get("sky").isJsonPrimitive() && light.getAsJsonPrimitive("sky").isNumber()) {
                    ret.blockLight = light.getAsJsonPrimitive("sky").getAsInt();
                }
            }
        }
        return ret;
    }

    public static class Serializer
    implements IMetadataSectionSerializer<MetadataSectionCTM> {
        @Nullable
        public MetadataSectionCTM deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) throws JsonParseException {
            if (json != null && json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                return MetadataSectionCTM.fromJson(obj);
            }
            return null;
        }

        @Nonnull
        public String func_110483_a() {
            return MetadataSectionCTM.SECTION_NAME;
        }
    }
}

