/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.lamp;

import gregtech.client.model.lamp.LampModelType;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.RenderUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="gregtech", value={Side.CLIENT})
public class LampBakedModel
implements IBakedModel {
    private static final String[] BLOOM_TEXTURE_SUFFIX = new String[]{"_bloom", "_emissive", "_bloom_ctm", "_emissive_ctm"};
    private static final Map<Key, Entry> ENTRIES = new Object2ObjectOpenHashMap();
    private final ModelResourceLocation modelLocation;
    private IBakedModel model;

    public static Entry register(EnumDyeColor color, LampModelType modelType, boolean bloom, boolean active) {
        return ENTRIES.computeIfAbsent(new Key(color, modelType, bloom, active), x$0 -> new Entry((Key)x$0));
    }

    public LampBakedModel(ModelResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
    }

    public LampBakedModel(IBakedModel model) {
        this.modelLocation = null;
        this.model = model;
    }

    protected IBakedModel getModel() {
        if (this.model == null) {
            this.model = Minecraft.func_71410_x().field_175618_aM.func_175023_a().func_178126_b().func_174953_a(Objects.requireNonNull(this.modelLocation));
            return this.model;
        }
        return this.model;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (state == null || layer == null) {
            return this.getFilteredQuads(true, true, state, side, rand);
        }
        if (layer == BlockRenderLayer.SOLID) {
            return this.getFilteredQuads(false, true, state, side, rand);
        }
        if (layer == BloomEffectUtil.BLOOM || layer == BlockRenderLayer.CUTOUT) {
            return this.getFilteredQuads(true, false, state, side, rand);
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> getFilteredQuads(boolean emissive, boolean nonEmissive, @Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (!emissive && !nonEmissive) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        ForgeHooksClient.setRenderLayer(null);
        List originalQuads = this.getModel().func_188616_a(state, side, rand);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
        for (BakedQuad q : originalQuads) {
            boolean isBloomTexture = false;
            for (String bloomTextureSuffix : BLOOM_TEXTURE_SUFFIX) {
                if (!q.func_187508_a().func_94215_i().endsWith(bloomTextureSuffix)) continue;
                isBloomTexture = true;
                break;
            }
            if (isBloomTexture) {
                if (!emissive) continue;
                quads.add(RenderUtil.makeEmissive(q));
                continue;
            }
            if (!nonEmissive) continue;
            quads.add(q);
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.getModel().func_177555_b();
    }

    public boolean func_177556_c() {
        return this.getModel().func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getModel().func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.getModel().func_177552_f();
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.getModel().isAmbientOcclusion(state);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        for (Map.Entry<Key, Entry> e : ENTRIES.entrySet()) {
            IBakedModel model;
            Entry entry = e.getValue();
            if (entry.customItemModel != null && (model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)entry.originalModelLocation)) != null) {
                IBakedModel customModel = e.getKey().modelType.createModel(model);
                event.getModelRegistry().func_82595_a((Object)entry.customItemModel, (Object)customModel);
            }
            if (entry.customBlockModel == null) continue;
            IBakedModel customModel = e.getKey().modelType.createModel(entry.originalModelLocation);
            event.getModelRegistry().func_82595_a((Object)entry.customBlockModel, (Object)customModel);
        }
    }

    public static final class Entry {
        @Nullable
        private final ModelResourceLocation customItemModel;
        @Nullable
        private final ModelResourceLocation customBlockModel;
        private final ModelResourceLocation originalModelLocation;

        private Entry(Key key) {
            this.originalModelLocation = new ModelResourceLocation(((Key)key).modelType.modelName, "active=" + key.active + ",color=" + key.color.func_176610_l());
            if (key.active) {
                String baseModelId = "active_lamp_" + ((Key)key).modelType.modelName.func_110624_b() + "_" + ((Key)key).modelType.modelName.func_110623_a() + "_" + key.color.func_176610_l();
                this.customItemModel = new ModelResourceLocation(new ResourceLocation("gregtech", baseModelId + "_item"), "");
                this.customBlockModel = new ModelResourceLocation(new ResourceLocation("gregtech", baseModelId + "_block" + (key.bloom ? "_bloom" : "")), "");
            } else {
                this.customBlockModel = null;
                this.customItemModel = null;
            }
        }

        public ModelResourceLocation getItemModelId() {
            return this.customItemModel != null ? this.customItemModel : this.originalModelLocation;
        }

        public ModelResourceLocation getBlockModelId() {
            return this.customBlockModel != null ? this.customBlockModel : this.originalModelLocation;
        }

        public ModelResourceLocation getOriginalModelLocation() {
            return this.originalModelLocation;
        }
    }

    private static final class Key {
        private final EnumDyeColor color;
        private final LampModelType modelType;
        private final boolean bloom;
        private final boolean active;
        private final int hash;

        private Key(EnumDyeColor color, LampModelType modelType, boolean bloom, boolean active) {
            this.color = color;
            this.modelType = modelType;
            this.bloom = bloom;
            this.active = active;
            this.hash = Objects.hash(color, modelType, bloom, active);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key entry = (Key)o;
            return this.bloom == entry.bloom && this.active == entry.active && this.color == entry.color && this.modelType.equals(entry.modelType);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "color=" + this.color.func_176610_l() + ", modelType=" + this.modelType + ", bloom=" + this.bloom + ", active=" + this.active;
        }
    }
}

