/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer;

import codechicken.lib.vec.Cuboid6;
import java.util.Arrays;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CubeRendererState {
    public final BlockRenderLayer layer;
    public final boolean[] sideMask;
    public final IBlockAccess world;
    public static boolean[] PASS_MASK = new boolean[EnumFacing.field_82609_l.length];

    public CubeRendererState(BlockRenderLayer layer, boolean[] sideMask, IBlockAccess world) {
        this.layer = layer;
        this.sideMask = sideMask;
        this.world = world;
    }

    public boolean shouldSideBeRendered(EnumFacing face, Cuboid6 bounds) {
        if (!this.sideMask[face.func_176745_a()]) {
            if (bounds == Cuboid6.full) {
                return false;
            }
            switch (face) {
                case DOWN: {
                    if (!(bounds.min.y <= 0.0)) break;
                    return false;
                }
                case UP: {
                    if (!(bounds.max.y >= 1.0)) break;
                    return false;
                }
                case NORTH: {
                    if (!(bounds.min.z <= 0.0)) break;
                    return false;
                }
                case SOUTH: {
                    if (!(bounds.max.z >= 1.0)) break;
                    return false;
                }
                case WEST: {
                    if (!(bounds.min.x <= 0.0)) break;
                    return false;
                }
                case EAST: {
                    if (!(bounds.max.x >= 1.0)) break;
                    return false;
                }
            }
        }
        return true;
    }

    static {
        Arrays.fill(PASS_MASK, true);
    }
}

