/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.handler;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.util.GTLog;
import gregtech.api.util.ModCompatibility;
import gregtech.client.renderer.ICCLBlockRenderer;
import gregtech.client.renderer.texture.Textures;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CCLBlockRenderer
implements ICCBlockRenderer,
IItemRenderer {
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("gregtech", "ccl_block"), "normal");
    public static final CCLBlockRenderer INSTANCE = new CCLBlockRenderer();
    public static EnumBlockRenderType BLOCK_RENDER_TYPE;
    public static Minecraft mc;

    public static void preInit() {
        BLOCK_RENDER_TYPE = BlockRenderingRegistry.createRenderType((String)"gregtech_ccl_block");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)BLOCK_RENDER_TYPE, (ICCBlockRenderer)INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TextureUtils.addIconRegister(Textures::register);
    }

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        GTLog.logger.info("Injected ccl block render model");
        event.getModelRegistry().func_82595_a((Object)MODEL_LOCATION, (Object)this);
    }

    public void renderItem(ItemStack rawStack, ItemCameraTransforms.TransformType transformType) {
        ItemStack stack = ModCompatibility.getRealItemStack(rawStack);
        if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof ICCLBlockRenderer) {
            ((ICCLBlockRenderer)((ItemBlock)stack.func_77973_b()).func_179223_d()).renderItem(stack, transformType);
        }
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        if (state != null && state.func_177230_c() instanceof ICCLBlockRenderer) {
            ((ICCLBlockRenderer)state.func_177230_c()).renderBlock(world, pos, state, buffer);
            return true;
        }
        return false;
    }

    public IModelState getTransforms() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public boolean func_188618_c() {
        return true;
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        if (state == null || !(state.func_177230_c() instanceof ICCLBlockRenderer)) {
            return;
        }
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)Cuboid6.full, (int)0);
    }

    public TextureAtlasSprite func_177554_e() {
        return TextureUtils.getMissingSprite();
    }

    public void registerTextures(TextureMap map) {
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    static {
        mc = Minecraft.func_71410_x();
    }
}

