/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.cube;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class SidedCubeRenderer
implements ICubeRenderer {
    private static final String BASE_DIR = "blocks/%s/%s";
    protected final String basePath;
    @SideOnly(value=Side.CLIENT)
    protected Map<OrientedOverlayRenderer.OverlayFace, TextureAtlasSprite> sprites;
    @SideOnly(value=Side.CLIENT)
    protected Map<OrientedOverlayRenderer.OverlayFace, TextureAtlasSprite> spritesEmissive;

    @Deprecated
    public SidedCubeRenderer(String basePath, OrientedOverlayRenderer.OverlayFace ... ignored) {
        this.basePath = basePath;
    }

    public SidedCubeRenderer(String basePath) {
        this.basePath = basePath;
        Textures.CUBE_RENDERER_REGISTRY.put(basePath, this);
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        String modID = "gregtech";
        String basePath = this.basePath;
        String[] split = this.basePath.split(":");
        if (split.length == 2) {
            modID = split[0];
            basePath = split[1];
        }
        this.sprites = new EnumMap<OrientedOverlayRenderer.OverlayFace, TextureAtlasSprite>(OrientedOverlayRenderer.OverlayFace.class);
        this.spritesEmissive = new EnumMap<OrientedOverlayRenderer.OverlayFace, TextureAtlasSprite>(OrientedOverlayRenderer.OverlayFace.class);
        for (OrientedOverlayRenderer.OverlayFace overlayFace : OrientedOverlayRenderer.OverlayFace.VALUES) {
            String faceName = overlayFace.name().toLowerCase();
            String overlayPath = String.format(BASE_DIR, basePath, faceName);
            TextureAtlasSprite normalSprite = ICubeRenderer.getResource(textureMap, modID, overlayPath);
            if (normalSprite == null) continue;
            this.sprites.put(overlayFace, normalSprite);
            this.spritesEmissive.put(overlayFace, ICubeRenderer.getResource(textureMap, modID, overlayPath + "_emissive"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite() {
        return this.sprites.get((Object)OrientedOverlayRenderer.OverlayFace.TOP);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing frontFacing, boolean isActive, boolean isWorkingEnabled) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            OrientedOverlayRenderer.OverlayFace overlayFace = OrientedOverlayRenderer.OverlayFace.bySide(facing, frontFacing);
            TextureAtlasSprite renderSprite = this.sprites.get((Object)overlayFace);
            if (renderSprite == null) continue;
            Textures.renderFace(renderState, translation, pipeline, facing, bounds, renderSprite, BlockRenderLayer.CUTOUT_MIPPED);
            TextureAtlasSprite emissiveSprite = this.spritesEmissive.get((Object)overlayFace);
            if (emissiveSprite == null) continue;
            if (ConfigHolder.client.machinesEmissiveTextures) {
                IVertexOperation[] lightPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new LightMapOperation(240, 240));
                Textures.renderFace(renderState, translation, lightPipeline, facing, bounds, emissiveSprite, BloomEffectUtil.getRealBloomLayer());
                continue;
            }
            Textures.renderFace(renderState, translation, pipeline, facing, bounds, emissiveSprite, BlockRenderLayer.CUTOUT_MIPPED);
        }
    }
}

