/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.cube;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.resources.ResourceHelper;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class SimpleSidedCubeRenderer
implements ICubeRenderer {
    protected final String basePath;
    @SideOnly(value=Side.CLIENT)
    protected Map<RenderSide, TextureAtlasSprite> sprites;
    @SideOnly(value=Side.CLIENT)
    protected Map<RenderSide, TextureAtlasSprite> spritesEmissive;

    public SimpleSidedCubeRenderer(String basePath) {
        this.basePath = basePath;
        Textures.CUBE_RENDERER_REGISTRY.put(basePath, this);
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        String modID = "gregtech";
        String basePath = this.basePath;
        String[] split = this.basePath.split(":");
        if (split.length == 2) {
            modID = split[0];
            basePath = split[1];
        }
        this.sprites = new EnumMap<RenderSide, TextureAtlasSprite>(RenderSide.class);
        this.spritesEmissive = new EnumMap<RenderSide, TextureAtlasSprite>(RenderSide.class);
        for (RenderSide overlayFace : RenderSide.VALUES) {
            String faceName = overlayFace.name().toLowerCase();
            ResourceLocation resourceLocation = new ResourceLocation(modID, String.format("blocks/%s/%s", basePath, faceName));
            this.sprites.put(overlayFace, textureMap.func_174942_a(resourceLocation));
            String emissive = String.format("blocks/%s/%s_emissive", basePath, faceName);
            if (!ResourceHelper.doResourcepacksHaveTexture(modID, emissive, true)) continue;
            this.spritesEmissive.put(overlayFace, textureMap.func_174942_a(new ResourceLocation(modID, emissive)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSpriteOnSide(RenderSide renderSide) {
        return this.sprites.get((Object)renderSide);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite() {
        return this.getSpriteOnSide(RenderSide.TOP);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing frontFacing, boolean isActive, boolean isWorkingEnabled) {
        RenderSide overlayFace = RenderSide.bySide(frontFacing);
        TextureAtlasSprite renderSprite = this.sprites.get((Object)overlayFace);
        Textures.renderFace(renderState, translation, pipeline, frontFacing, bounds, renderSprite, BlockRenderLayer.CUTOUT_MIPPED);
        TextureAtlasSprite spriteEmissive = this.spritesEmissive.get((Object)overlayFace);
        if (spriteEmissive != null) {
            if (ConfigHolder.client.machinesEmissiveTextures) {
                IVertexOperation[] lightPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new LightMapOperation(240, 240));
                Textures.renderFace(renderState, translation, lightPipeline, frontFacing, bounds, spriteEmissive, BloomEffectUtil.getRealBloomLayer());
            } else {
                Textures.renderFace(renderState, translation, pipeline, frontFacing, bounds, spriteEmissive, BlockRenderLayer.CUTOUT_MIPPED);
            }
        }
    }

    public static enum RenderSide {
        TOP,
        BOTTOM,
        SIDE;

        public static final RenderSide[] VALUES;

        public static RenderSide bySide(EnumFacing side) {
            if (side == EnumFacing.UP) {
                return TOP;
            }
            if (side == EnumFacing.DOWN) {
                return BOTTOM;
            }
            return SIDE;
        }

        static {
            VALUES = RenderSide.values();
        }
    }
}

