/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.custom;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.renderer.texture.cube.SidedCubeRenderer;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class FireboxActiveRenderer
extends SidedCubeRenderer {
    public FireboxActiveRenderer(String basePath) {
        super(basePath);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing frontFacing, boolean isActive, boolean isWorkingEnabled) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            OrientedOverlayRenderer.OverlayFace overlayFace = OrientedOverlayRenderer.OverlayFace.bySide(facing, frontFacing);
            TextureAtlasSprite renderSprite = (TextureAtlasSprite)this.sprites.get((Object)overlayFace);
            if (renderSprite == null) continue;
            Textures.renderFace(renderState, translation, pipeline, facing, bounds, renderSprite, BlockRenderLayer.CUTOUT_MIPPED);
            TextureAtlasSprite emissiveSprite = (TextureAtlasSprite)this.spritesEmissive.get((Object)overlayFace);
            if (emissiveSprite == null || facing == frontFacing || facing == EnumFacing.UP || facing == EnumFacing.DOWN) continue;
            Textures.renderFace(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new LightMapOperation(240, 240)), facing, bounds, emissiveSprite, ConfigHolder.client.machinesEmissiveTextures ? BloomEffectUtil.getRealBloomLayer() : BlockRenderLayer.CUTOUT_MIPPED);
        }
    }
}

