/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import com.enderio.core.common.interfaces.IOverlayRenderAware;
import gregtech.api.GregTechAPI;
import gregtech.api.block.VariantItemBlock;
import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.crafttweaker.MetaItemBracketHandler;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.recipeproperties.FusionEUToStartProperty;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockLamp;
import gregtech.common.blocks.BlockOre;
import gregtech.common.blocks.CompressedItemBlock;
import gregtech.common.blocks.FrameItemBlock;
import gregtech.common.blocks.LampItemBlock;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.OreItemBlock;
import gregtech.common.blocks.StoneVariantBlock;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.ItemBlockCable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.ItemBlockFluidPipe;
import gregtech.common.pipelike.itempipe.BlockItemPipe;
import gregtech.common.pipelike.itempipe.ItemBlockItemPipe;
import gregtech.common.pipelike.itempipe.ItemPipeType;
import gregtech.integration.groovy.GroovyScriptCompat;
import gregtech.integration.jei.GTJeiPlugin;
import gregtech.loaders.MaterialInfoLoader;
import gregtech.loaders.OreDictionaryLoader;
import gregtech.loaders.recipe.CraftingComponent;
import gregtech.loaders.recipe.GTRecipeManager;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber(modid="gregtech")
public class CommonProxy {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GTLog.logger.info("Registering Blocks...");
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)MetaBlocks.MACHINE);
        StoneType.init();
        BlockFluidPipe[] blockFluidPipeArray = GregTechAPI.MATERIAL_REGISTRY.iterator();
        while (blockFluidPipeArray.hasNext()) {
            Material material = (Material)blockFluidPipeArray.next();
            if (material.hasProperty(PropertyKey.ORE)) {
                CommonProxy.createOreBlock(material);
            }
            if (material.hasProperty(PropertyKey.WIRE)) {
                for (BlockMaterialPipe blockMaterialPipe : MetaBlocks.CABLES) {
                    if (((Insulation)blockMaterialPipe.getItemPipeType(null)).isCable() && material.getProperty(PropertyKey.WIRE).isSuperconductor()) continue;
                    ((BlockCable)blockMaterialPipe).addCableMaterial(material, material.getProperty(PropertyKey.WIRE));
                }
            }
            if (material.hasProperty(PropertyKey.FLUID_PIPE)) {
                for (BlockMaterialPipe blockMaterialPipe : MetaBlocks.FLUID_PIPES) {
                    if (((FluidPipeType)blockMaterialPipe.getItemPipeType(blockMaterialPipe.getItem(material))).getOrePrefix().isIgnored(material)) continue;
                    ((BlockFluidPipe)blockMaterialPipe).addPipeMaterial(material, material.getProperty(PropertyKey.FLUID_PIPE));
                }
            }
            if (!material.hasProperty(PropertyKey.ITEM_PIPE)) continue;
            for (BlockMaterialPipe blockMaterialPipe : MetaBlocks.ITEM_PIPES) {
                if (((ItemPipeType)blockMaterialPipe.getItemPipeType(blockMaterialPipe.getItem(material))).getOrePrefix().isIgnored(material)) continue;
                ((BlockItemPipe)blockMaterialPipe).addPipeMaterial(material, material.getProperty(PropertyKey.ITEM_PIPE));
            }
        }
        for (BlockFluidPipe blockFluidPipe : MetaBlocks.FLUID_PIPES) {
            if (((FluidPipeType)blockFluidPipe.getItemPipeType(blockFluidPipe.getItem(Materials.Wood))).getOrePrefix().isIgnored(Materials.Wood) && ((FluidPipeType)blockFluidPipe.getItemPipeType(blockFluidPipe.getItem(Materials.TreatedWood))).getOrePrefix().isIgnored(Materials.TreatedWood)) continue;
            blockFluidPipe.addPipeMaterial(Materials.Wood, new FluidPipeProperties(340, 5, false, false, false, false));
            blockFluidPipe.addPipeMaterial(Materials.TreatedWood, new FluidPipeProperties(340, 10, false, false, false, false));
        }
        for (BlockMaterialPipe blockMaterialPipe : MetaBlocks.CABLES) {
            registry.register((IForgeRegistryEntry)blockMaterialPipe);
        }
        for (BlockMaterialPipe blockMaterialPipe : MetaBlocks.FLUID_PIPES) {
            registry.register((IForgeRegistryEntry)blockMaterialPipe);
        }
        for (BlockMaterialPipe blockMaterialPipe : MetaBlocks.ITEM_PIPES) {
            registry.register((IForgeRegistryEntry)blockMaterialPipe);
        }
        registry.register((IForgeRegistryEntry)MetaBlocks.HERMETIC_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.CLEANROOM_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.FOAM);
        registry.register((IForgeRegistryEntry)MetaBlocks.REINFORCED_FOAM);
        registry.register((IForgeRegistryEntry)MetaBlocks.PETRIFIED_FOAM);
        registry.register((IForgeRegistryEntry)MetaBlocks.REINFORCED_PETRIFIED_FOAM);
        registry.register((IForgeRegistryEntry)MetaBlocks.BOILER_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.BOILER_FIREBOX_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.METAL_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.TURBINE_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.MACHINE_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.STEAM_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.MULTIBLOCK_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.TRANSPARENT_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.WIRE_COIL);
        registry.register((IForgeRegistryEntry)MetaBlocks.FUSION_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.WARNING_SIGN);
        registry.register((IForgeRegistryEntry)MetaBlocks.WARNING_SIGN_1);
        registry.register((IForgeRegistryEntry)MetaBlocks.ASPHALT);
        for (StoneVariantBlock block : MetaBlocks.STONE_BLOCKS.values()) {
            registry.register((IForgeRegistryEntry)block);
        }
        registry.register((IForgeRegistryEntry)MetaBlocks.RUBBER_LOG);
        registry.register((IForgeRegistryEntry)MetaBlocks.RUBBER_LEAVES);
        registry.register((IForgeRegistryEntry)MetaBlocks.RUBBER_SAPLING);
        registry.register((IForgeRegistryEntry)MetaBlocks.PLANKS);
        registry.register((IForgeRegistryEntry)MetaBlocks.WOOD_SLAB);
        registry.register((IForgeRegistryEntry)MetaBlocks.DOUBLE_WOOD_SLAB);
        registry.register((IForgeRegistryEntry)MetaBlocks.RUBBER_WOOD_STAIRS);
        registry.register((IForgeRegistryEntry)MetaBlocks.TREATED_WOOD_STAIRS);
        registry.register((IForgeRegistryEntry)MetaBlocks.RUBBER_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)MetaBlocks.TREATED_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)MetaBlocks.RUBBER_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)MetaBlocks.TREATED_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)MetaBlocks.RUBBER_WOOD_DOOR);
        registry.register((IForgeRegistryEntry)MetaBlocks.TREATED_WOOD_DOOR);
        registry.register((IForgeRegistryEntry)MetaBlocks.BRITTLE_CHARCOAL);
        for (BlockLamp block : MetaBlocks.LAMPS.values()) {
            registry.register((IForgeRegistryEntry)block);
        }
        for (BlockLamp block : MetaBlocks.BORDERLESS_LAMPS.values()) {
            registry.register((IForgeRegistryEntry)block);
        }
        MetaBlocks.COMPRESSED.values().stream().distinct().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.FRAMES.values().stream().distinct().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.SURFACE_ROCK.values().stream().distinct().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.ORES.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    private static void createOreBlock(Material material) {
        Object[] stoneTypeBuffer = new StoneType[16];
        int generationIndex = 0;
        Iterator<StoneType> iterator = StoneType.STONE_TYPE_REGISTRY.iterator();
        while (iterator.hasNext()) {
            StoneType stoneType = iterator.next();
            int id = StoneType.STONE_TYPE_REGISTRY.getIDForObject(stoneType);
            int index = id / 16;
            if (index > generationIndex) {
                CommonProxy.createOreBlock(material, CommonProxy.copyNotNull(stoneTypeBuffer), generationIndex);
                Arrays.fill(stoneTypeBuffer, null);
            }
            stoneTypeBuffer[id % 16] = stoneType;
            generationIndex = index;
        }
        CommonProxy.createOreBlock(material, CommonProxy.copyNotNull(stoneTypeBuffer), generationIndex);
    }

    private static <T> T[] copyNotNull(T[] src) {
        int nullIndex = ArrayUtils.indexOf((Object[])src, null);
        return Arrays.copyOfRange(src, 0, nullIndex == -1 ? src.length : nullIndex);
    }

    private static void createOreBlock(Material material, StoneType[] stoneTypes, int index) {
        BlockOre block = new BlockOre(material, stoneTypes);
        block.setRegistryName("ore_" + material + "_" + index);
        for (StoneType stoneType : stoneTypes) {
            GregTechAPI.oreBlockTable.computeIfAbsent(material, m -> new HashMap()).put(stoneType, block);
        }
        MetaBlocks.ORES.add(block);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerBlocksLast(RegistryEvent.Register<Block> event) {
        MetaBlocks.FLUID_BLOCKS.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        GTLog.logger.info("Registering Items...");
        IForgeRegistry registry = event.getRegistry();
        for (MetaItem<?> item : MetaItems.ITEMS) {
            registry.register(item);
            item.registerSubItems();
        }
        for (IGTTool tool : ToolItems.getAllTools()) {
            registry.register((IForgeRegistryEntry)tool.get());
        }
        GTRecipeManager.preLoad();
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.MACHINE, MachineItemBlock::new));
        for (Iterator<IOverlayRenderAware> iterator : MetaBlocks.CABLES) {
            registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(iterator, ItemBlockCable::new));
        }
        for (Iterator<IOverlayRenderAware> iterator : MetaBlocks.FLUID_PIPES) {
            registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(iterator, ItemBlockFluidPipe::new));
        }
        for (Iterator<IOverlayRenderAware> iterator : MetaBlocks.ITEM_PIPES) {
            registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(iterator, ItemBlockItemPipe::new));
        }
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.HERMETIC_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.CLEANROOM_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.BOILER_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.BOILER_FIREBOX_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.METAL_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.TURBINE_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.MACHINE_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.STEAM_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.MULTIBLOCK_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.TRANSPARENT_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.WIRE_COIL, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.FUSION_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.WARNING_SIGN, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.WARNING_SIGN_1, VariantItemBlock::new));
        for (BlockLamp block2 : MetaBlocks.LAMPS.values()) {
            registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(block2, LampItemBlock::new));
        }
        for (BlockLamp block3 : MetaBlocks.BORDERLESS_LAMPS.values()) {
            registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(block3, LampItemBlock::new));
        }
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.ASPHALT, VariantItemBlock::new));
        for (StoneVariantBlock block4 : MetaBlocks.STONE_BLOCKS.values()) {
            registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(block4, VariantItemBlock::new));
        }
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.PLANKS, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.WOOD_SLAB, b -> new ItemSlab((Block)b, (BlockSlab)b, (BlockSlab)MetaBlocks.DOUBLE_WOOD_SLAB)));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.RUBBER_WOOD_STAIRS, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.TREATED_WOOD_STAIRS, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.RUBBER_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.TREATED_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.RUBBER_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.TREATED_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.BRITTLE_CHARCOAL, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.RUBBER_LOG, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.RUBBER_LEAVES, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.RUBBER_SAPLING, ItemBlock::new));
        MetaBlocks.COMPRESSED.values().stream().distinct().map(block -> CommonProxy.createItemBlock(block, CompressedItemBlock::new)).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.FRAMES.values().stream().distinct().map(block -> CommonProxy.createItemBlock(block, FrameItemBlock::new)).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.ORES.stream().map(block -> CommonProxy.createItemBlock(block, OreItemBlock::new)).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void initComponents(RegistryEvent.Register<IRecipe> event) {
        CraftingComponent.initializeComponents();
        MinecraftForge.EVENT_BUS.post(new GregTechAPI.RegisterEvent<CraftingComponent>(null, CraftingComponent.class));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        FusionEUToStartProperty.registerFusionTier(6, "(MK1)");
        FusionEUToStartProperty.registerFusionTier(7, "(MK2)");
        FusionEUToStartProperty.registerFusionTier(8, "(MK3)");
        GTLog.logger.info("Registering ore dictionary...");
        MetaItems.registerOreDict();
        ToolItems.registerOreDict();
        MetaBlocks.registerOreDict();
        OreDictionaryLoader.init();
        MaterialInfoLoader.init();
        MinecraftForge.EVENT_BUS.post(new GregTechAPI.RegisterEvent<ItemMaterialInfo>(null, ItemMaterialInfo.class));
        GTLog.logger.info("Registering recipes...");
        GTRecipeManager.load();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void runEarlyMaterialHandlers(RegistryEvent.Register<IRecipe> event) {
        GTLog.logger.info("Running early material handlers...");
        OrePrefix.runMaterialHandlers();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipesLowest(RegistryEvent.Register<IRecipe> event) {
        GTLog.logger.info("Running late material handlers...");
        OrePrefix.runMaterialHandlers();
        GTRecipeManager.loadLatest();
        if (Loader.isModLoaded((String)"crafttweaker")) {
            MetaItemBracketHandler.rebuildComponentRegistry();
        }
        if (GroovyScriptCompat.isLoaded()) {
            GroovyScriptCompat.loadMetaItemBracketHandler();
        }
    }

    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("gregtech")) {
            ConfigManager.sync((String)"gregtech", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void modifyFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        CompressedItemBlock itemBlock;
        Material material;
        DustProperty property;
        ItemStack stack = event.getItemStack();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == MetaBlocks.RUBBER_SAPLING) {
            event.setBurnTime(100);
        } else if (block == MetaBlocks.WOOD_SLAB) {
            event.setBurnTime(150);
        } else if (stack.func_77973_b() instanceof CompressedItemBlock && (property = (material = (Material)(itemBlock = (CompressedItemBlock)stack.func_77973_b()).getBlockState(stack).func_177229_b((IProperty)itemBlock.compressedBlock.variantProperty)).getProperty(PropertyKey.DUST)) != null && property.getBurnTime() > 0) {
            double materialUnitsInBlock = (double)OrePrefix.block.getMaterialAmount(material) / 3628800.0;
            event.setBurnTime((int)(materialUnitsInBlock * (double)property.getBurnTime()));
        }
    }

    private static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            throw new IllegalArgumentException("Block " + block.func_149739_a() + " has no registry name.");
        }
        itemBlock.setRegistryName(registryName);
        return itemBlock;
    }

    public void onPreLoad() {
    }

    public void onLoad() {
    }

    public void onPostLoad() {
        TerminalRegistry.init();
        if (ConfigHolder.compat.removeSmeltingForEBFMetals) {
            ModHandler.removeSmeltingEBFMetals();
        }
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        if (Loader.isModLoaded((String)"jei") && event.getSide() == Side.CLIENT) {
            GTJeiPlugin.setupInputHandler();
        }
        GTRecipeInput.INSTANCES = new ObjectOpenHashSet();
    }

    public boolean isFancyGraphics() {
        return true;
    }
}

