/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.api.GTValues;
import gregtech.api.items.armor.ArmorMetaItem;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.CapesRegistry;
import gregtech.api.util.GTUtility;
import gregtech.api.util.VirtualTankRegistry;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinSaveData;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import gregtech.common.items.armor.IStepAssist;
import gregtech.common.items.behaviors.ToggleEnergyConsumerBehavior;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityCentralMonitor;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="gregtech")
public class EventHandlers {
    private static final String HAS_TERMINAL = "gregtech.terminal";
    private static ItemStack lastFeetEquip = ItemStack.field_190927_a;

    @SubscribeEvent
    public static void onEndermanTeleportEvent(EnderTeleportEvent event) {
        if (event.getEntity() instanceof EntityEnderman && event.getEntityLiving().func_70660_b(MobEffects.field_76437_t) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityLivingBase entity = event.getEntityLiving();
        EnumDifficulty difficulty = entity.field_70170_p.func_175659_aa();
        if (difficulty == EnumDifficulty.HARD && entity.func_70681_au().nextFloat() <= 0.03f && entity instanceof EntityZombie && ConfigHolder.tools.nanoSaber.zombieSpawnWithSabers) {
            ItemStack itemStack = MetaItems.NANO_SABER.getInfiniteChargedStack();
            ToggleEnergyConsumerBehavior.setItemActive(itemStack, true);
            entity.func_184201_a(EntityEquipmentSlot.MAINHAND, itemStack);
            ((EntityZombie)entity).func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractionRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack;
        if (event.getWorld().func_175625_s(event.getPos()) instanceof IGregTechTileEntity) {
            event.setUseBlock(Event.Result.ALLOW);
        }
        if (!((stack = event.getItemStack()).func_190926_b() || stack.func_77973_b() != Items.field_151033_d || event.getWorld().field_72995_K || event.getEntityPlayer().field_71075_bZ.field_75098_d || GTValues.RNG.nextInt(100) < ConfigHolder.misc.flintChanceToCreateFire)) {
            stack.func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
            if (stack.func_77952_i() >= stack.func_77958_k()) {
                stack.func_190918_g(1);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractionLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        TileEntity holder;
        if (event.getEntityPlayer().func_184812_l_() && (holder = event.getWorld().func_175625_s(event.getPos())) instanceof IGregTechTileEntity && ((IGregTechTileEntity)holder).getMetaTileEntity() instanceof MetaTileEntityCentralMonitor) {
            ((MetaTileEntityCentralMonitor)((IGregTechTileEntity)holder).getMetaTileEntity()).invalidateStructure();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (event.canHarvest()) {
            ItemStack item = event.getEntityPlayer().func_184614_ca();
            String tool = event.getTargetBlock().func_177230_c().getHarvestTool(event.getTargetBlock());
            if (!EventHandlers.canMineWithPick(tool)) {
                return;
            }
            if (ConfigHolder.machines.requireGTToolsForBlocks) {
                event.setCanHarvest(false);
                return;
            }
            tool = "pickaxe";
            int harvestLevel = event.getTargetBlock().func_177230_c().getHarvestLevel(event.getTargetBlock());
            if (!item.func_190926_b() && harvestLevel > item.func_77973_b().getHarvestLevel(item, tool, event.getEntityPlayer(), event.getTargetBlock())) {
                event.setCanHarvest(false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDestroySpeed(PlayerEvent.BreakSpeed event) {
        ItemStack item = event.getEntityPlayer().func_184614_ca();
        String tool = event.getState().func_177230_c().getHarvestTool(event.getState());
        if (tool != null && !item.func_190926_b() && EventHandlers.canMineWithPick(tool) && item.func_77973_b().getToolClasses(item).contains("pickaxe")) {
            event.setNewSpeed(event.getNewSpeed() * 0.75f);
        }
    }

    public static boolean canMineWithPick(String tool) {
        return "wrench".equals(tool) || "wirecutter".equals(tool);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityLivingFallEvent(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            ArmorMetaItem.ArmorMetaValueItem valueItem;
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            ItemStack armor = player.func_184582_a(EntityEquipmentSlot.FEET);
            ItemStack jet = player.func_184582_a(EntityEquipmentSlot.CHEST);
            if (player.field_70143_R < 3.2f) {
                return;
            }
            if (!armor.func_190926_b() && armor.func_77973_b() instanceof ArmorMetaItem) {
                ArmorMetaItem.ArmorMetaValueItem valueItem2 = (ArmorMetaItem.ArmorMetaValueItem)((ArmorMetaItem)armor.func_77973_b()).getItem(armor);
                if (valueItem2 != null) {
                    valueItem2.getArmorLogic().damageArmor((EntityLivingBase)player, armor, DamageSource.field_76379_h, (int)(player.field_70143_R - 1.2f), EntityEquipmentSlot.FEET);
                    player.field_70143_R = 0.0f;
                    event.setCanceled(true);
                }
            } else if (!jet.func_190926_b() && jet.func_77973_b() instanceof ArmorMetaItem && GTUtility.getOrCreateNbtCompound(jet).func_74764_b("flyMode") && (valueItem = (ArmorMetaItem.ArmorMetaValueItem)((ArmorMetaItem)jet.func_77973_b()).getItem(jet)) != null) {
                valueItem.getArmorLogic().damageArmor((EntityLivingBase)player, jet, DamageSource.field_76379_h, (int)(player.field_70143_R - 1.2f), EntityEquipmentSlot.FEET);
                player.field_70143_R = 0.0f;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        EntityEquipmentSlot slot = event.getSlot();
        if (event.getFrom().func_190926_b() || slot == EntityEquipmentSlot.MAINHAND || slot == EntityEquipmentSlot.OFFHAND) {
            return;
        }
        ItemStack stack = event.getFrom();
        if (!(stack.func_77973_b() instanceof ArmorMetaItem) || stack.func_77973_b().equals(event.getTo().func_77973_b())) {
            return;
        }
        ArmorMetaItem.ArmorMetaValueItem valueItem = (ArmorMetaItem.ArmorMetaValueItem)((ArmorMetaItem)stack.func_77973_b()).getItem(stack);
        if (valueItem == null) {
            return;
        }
        if (valueItem.isItemEqual(MetaItems.NIGHTVISION_GOGGLES.getStackForm()) || valueItem.isItemEqual(MetaItems.NANO_HELMET.getStackForm()) || valueItem.isItemEqual(MetaItems.QUANTUM_HELMET.getStackForm())) {
            event.getEntityLiving().func_184589_d(MobEffects.field_76439_r);
        }
        if (valueItem.isItemEqual(MetaItems.QUANTUM_CHESTPLATE.getStackForm()) || valueItem.isItemEqual(MetaItems.QUANTUM_CHESTPLATE_ADVANCED.getStackForm())) {
            event.getEntity().field_70178_ae = false;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!(event.phase != TickEvent.Phase.START || event.player.func_175149_v() || event.player instanceof EntityOtherPlayerMP || event.player instanceof FakePlayer)) {
            ItemStack feetEquip = event.player.func_184582_a(EntityEquipmentSlot.FEET);
            if (!lastFeetEquip.func_77973_b().equals(feetEquip.func_77973_b())) {
                ArmorMetaItem.ArmorMetaValueItem valueItem;
                if (lastFeetEquip.func_77973_b() instanceof ArmorMetaItem && (valueItem = (ArmorMetaItem.ArmorMetaValueItem)((ArmorMetaItem)lastFeetEquip.func_77973_b()).getItem(lastFeetEquip)) != null && valueItem.getArmorLogic() instanceof IStepAssist) {
                    event.player.field_70138_W = 0.6f;
                }
                lastFeetEquip = feetEquip.func_77946_l();
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        VirtualTankRegistry.initializeStorage(event.getWorld());
        CapesRegistry.checkAdvancements(event.getWorld());
    }

    @SubscribeEvent
    public static void onPlayerAdvancement(AdvancementEvent event) {
        CapesRegistry.unlockCapeOnAdvancement(event.getEntityPlayer(), event.getAdvancement());
    }

    @SubscribeEvent
    public static void onWorldUnloadEvent(WorldEvent.Unload event) {
        BedrockFluidVeinSaveData.setDirty();
    }

    @SubscribeEvent
    public static void onWorldSaveEvent(WorldEvent.Save event) {
        BedrockFluidVeinSaveData.setDirty();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (ConfigHolder.misc.spawnTerminal) {
            NBTTagCompound data;
            NBTTagCompound playerData = event.player.getEntityData();
            NBTTagCompound nBTTagCompound = data = playerData.func_74764_b("PlayerPersisted") ? playerData.func_74775_l("PlayerPersisted") : new NBTTagCompound();
            if (!data.func_74767_n(HAS_TERMINAL)) {
                ItemStack terminal = MetaItems.TERMINAL.getStackForm();
                if (event.player.func_184812_l_()) {
                    terminal.func_190925_c("terminal").func_74757_a("_creative", true);
                }
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)terminal);
                data.func_74757_a(HAS_TERMINAL, true);
                playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
            }
        }
        CapesRegistry.detectNewCapes(event.player);
        CapesRegistry.loadWornCapeOnLogin(event.player);
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (ItemStack.func_77989_b((ItemStack)event.getItemStack(), (ItemStack)FluidUtil.getFilledBucket((FluidStack)Materials.Creosote.getFluid(1000)))) {
            event.setBurnTime(6400);
        }
    }
}

