/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.block.DelayedStateBlock;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.GTUtility;
import gregtech.client.model.MaterialStateMapper;
import gregtech.client.model.modelfactories.MaterialBlockModelLoader;
import gregtech.common.blocks.properties.PropertyMaterial;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BlockCompressed
extends DelayedStateBlock {
    public final PropertyMaterial variantProperty;

    public BlockCompressed(gregtech.api.unification.material.Material[] materials) {
        super(Material.field_151573_f);
        this.func_149663_c("compressed");
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH_MATERIALS);
        this.variantProperty = PropertyMaterial.create("variant", materials);
        this.initBlockState();
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    public String getHarvestTool(IBlockState state) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (material.isSolid()) {
            return "pickaxe";
        }
        if (material.hasProperty(PropertyKey.DUST)) {
            return "shovel";
        }
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (material.hasProperty(PropertyKey.DUST)) {
            return material.getBlockHarvestLevel();
        }
        return 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta >= this.variantProperty.getAllowedValues().size()) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)this.variantProperty.getAllowedValues().get(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.variantProperty.getAllowedValues().indexOf((Object)state.func_177229_b((IProperty)this.variantProperty));
    }

    @Override
    protected BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.variantProperty});
    }

    public static ItemStack getItem(IBlockState blockState) {
        return GTUtility.toItem(blockState);
    }

    public ItemStack getItem(gregtech.api.unification.material.Material material) {
        return BlockCompressed.getItem(this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material));
    }

    public gregtech.api.unification.material.Material getGtMaterial(int meta) {
        return (gregtech.api.unification.material.Material)this.variantProperty.getAllowedValues().get(meta);
    }

    public IBlockState getBlock(gregtech.api.unification.material.Material material) {
        return this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material);
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        this.field_176227_L.func_177619_a().stream().filter(blockState -> blockState.func_177229_b((IProperty)this.variantProperty) != Materials.NULL).forEach(blockState -> list.add((Object)BlockCompressed.getItem(blockState)));
    }

    @Nonnull
    public Material func_149688_o(IBlockState state) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (material.hasProperty(PropertyKey.GEM)) {
            return Material.field_151576_e;
        }
        if (material.hasProperty(PropertyKey.INGOT)) {
            return Material.field_151573_f;
        }
        if (material.hasProperty(PropertyKey.DUST)) {
            return Material.field_151595_p;
        }
        return Material.field_151576_e;
    }

    @Nonnull
    public MapColor func_180659_g(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return this.func_149688_o(state).func_151565_r();
    }

    @Nonnull
    public SoundType getSoundType(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (material.hasProperty(PropertyKey.GEM)) {
            return SoundType.field_185851_d;
        }
        if (material.hasProperty(PropertyKey.INGOT)) {
            return SoundType.field_185852_e;
        }
        if (material.hasProperty(PropertyKey.DUST)) {
            return SoundType.field_185855_h;
        }
        return SoundType.field_185851_d;
    }

    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new MaterialStateMapper(MaterialIconType.block, s -> ((gregtech.api.unification.material.Material)s.func_177229_b((IProperty)this.variantProperty)).getMaterialIconSet()));
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)this.func_176201_c(state), (ModelResourceLocation)MaterialBlockModelLoader.registerItemModel(MaterialIconType.block, ((gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty)).getMaterialIconSet()));
        }
    }
}

