/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.client.model.lamp.LampBakedModel;
import gregtech.client.model.lamp.LampModelType;
import gregtech.client.utils.BloomEffectUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockLamp
extends Block {
    public static final PropertyBool BLOOM = PropertyBool.func_177716_a((String)"bloom");
    public static final PropertyBool LIGHT = PropertyBool.func_177716_a((String)"light");
    public static final PropertyBool INVERTED = PropertyBool.func_177716_a((String)"inverted");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final int BLOOM_FLAG = 1;
    public static final int LIGHT_FLAG = 2;
    public static final int INVERTED_FLAG = 4;
    public static final int POWERED_FLAG = 8;
    public static final int ITEM_FLAGS = 7;
    public final EnumDyeColor color;

    public BlockLamp(EnumDyeColor color) {
        super(Material.field_151591_t, MapColor.func_193558_a((EnumDyeColor)color));
        this.color = color;
        this.func_149711_c(0.3f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)BLOOM, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)LIGHT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(GregTechAPI.TAB_GREGTECH_DECORATIONS);
    }

    public boolean isLightEnabled(ItemStack stack) {
        return (stack.func_77960_j() & 2) == 0;
    }

    public boolean isBloomEnabled(ItemStack stack) {
        return (stack.func_77960_j() & 1) == 0;
    }

    public boolean isInverted(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)INVERTED);
    }

    public boolean isLightEnabled(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIGHT);
    }

    public boolean isBloomEnabled(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BLOOM);
    }

    public int getItemMetadataStates() {
        return 8;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INVERTED, BLOOM, LIGHT, POWERED});
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state) & 7;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BLOOM, (Comparable)Boolean.valueOf((meta & 1) == 0)).func_177226_a((IProperty)LIGHT, (Comparable)Boolean.valueOf((meta & 2) == 0)).func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (!((Boolean)state.func_177229_b((IProperty)BLOOM)).booleanValue()) {
            meta |= 1;
        }
        if (!((Boolean)state.func_177229_b((IProperty)LIGHT)).booleanValue()) {
            meta |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)INVERTED)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIGHT) != false && BlockLamp.isLightActive(state) ? 15 : 0;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        boolean powered;
        if (!world.field_72995_K && (powered = ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) != world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(!powered)), (Boolean)state.func_177229_b((IProperty)LIGHT) != false ? 10 : 2);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                if (!world.func_175640_z(pos)) {
                    world.func_175684_a(pos, (Block)this, 4);
                }
            } else if (world.func_175640_z(pos)) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), (Boolean)state.func_177229_b((IProperty)LIGHT) != false ? 10 : 2);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)), (Boolean)state.func_177229_b((IProperty)LIGHT) != false ? 10 : 2);
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < this.getItemMetadataStates(); ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        IBlockState state = this.func_176203_a(stack.func_77960_j());
        if (((Boolean)state.func_177229_b((IProperty)INVERTED)).booleanValue()) {
            tooltip.add(I18n.func_135052_a((String)"tile.gregtech_lamp.tooltip.inverted", (Object[])new Object[0]));
        }
        if (!((Boolean)state.func_177229_b((IProperty)BLOOM)).booleanValue()) {
            tooltip.add(I18n.func_135052_a((String)"tile.gregtech_lamp.tooltip.no_bloom", (Object[])new Object[0]));
        }
        if (!((Boolean)state.func_177229_b((IProperty)LIGHT)).booleanValue()) {
            tooltip.add(I18n.func_135052_a((String)"tile.gregtech_lamp.tooltip.no_light", (Object[])new Object[0]));
        }
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT) {
            return true;
        }
        return BlockLamp.isLightActive(state) && (Boolean)state.func_177229_b((IProperty)BLOOM) != false && layer == BloomEffectUtil.getRealBloomLayer();
    }

    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        HashMap<IBlockState, ModelResourceLocation> models = new HashMap<IBlockState, ModelResourceLocation>();
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            LampBakedModel.Entry entry = LampBakedModel.register(this.color, this.getModelType(), (Boolean)state.func_177229_b((IProperty)BLOOM), BlockLamp.isLightActive(state));
            models.put(state, entry.getBlockModelId());
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) continue;
            Item item = Item.func_150898_a((Block)this);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)this.func_176201_c(state), (ModelResourceLocation)entry.getItemModelId());
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{entry.getOriginalModelLocation()});
        }
        ModelLoader.setCustomStateMapper((Block)this, b -> models);
    }

    @SideOnly(value=Side.CLIENT)
    protected LampModelType getModelType() {
        return LampModelType.LAMP;
    }

    public void registerOreDict() {
        for (int meta = 0; meta < this.getItemMetadataStates(); ++meta) {
            OreDictUnifier.registerOre(new ItemStack((Block)this, 1, meta), OrePrefix.lampGt, (gregtech.api.unification.material.Material)MarkerMaterials.Color.COLORS.get((Object)this.color));
        }
    }

    public static boolean isLightActive(IBlockState state) {
        return state.func_177229_b((IProperty)INVERTED) == state.func_177229_b((IProperty)POWERED);
    }
}

