/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.block.VariantBlock;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

@ParametersAreNonnullByDefault
public class BlockMachineCasing
extends VariantBlock<MachineCasingType> {
    public BlockMachineCasing() {
        super(Material.field_151573_f);
        this.func_149663_c("machine_casing");
        this.func_149711_c(4.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("wrench", 2);
        this.func_180632_j(this.getState(MachineCasingType.ULV));
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (MachineCasingType variant : (MachineCasingType[])this.VALUES) {
            if (variant.ordinal() > MachineCasingType.UHV.ordinal() && !GregTechAPI.isHighTier()) continue;
            list.add((Object)this.getItemVariant(variant));
        }
    }

    public static enum MachineCasingType implements IStringSerializable
    {
        ULV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[0])),
        LV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[1])),
        MV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[2])),
        HV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[3])),
        EV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[4])),
        IV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[5])),
        LuV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[6])),
        ZPM(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[7])),
        UV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[8])),
        UHV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[9])),
        UEV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[10])),
        UIV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[11])),
        UXV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[12])),
        OpV(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[13])),
        MAX(MachineCasingType.makeName(GTValues.VOLTAGE_NAMES[14]));

        private final String name;

        private MachineCasingType(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        private static String makeName(String voltageName) {
            return String.join((CharSequence)"_", voltageName.toLowerCase().split(" "));
        }
    }
}

