/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import com.google.common.collect.ImmutableMap;
import gregtech.api.GregTechAPI;
import gregtech.api.block.DelayedStateBlock;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.client.ClientProxy;
import gregtech.client.model.SimpleStateMapper;
import gregtech.client.model.modelfactories.BakedModelHandler;
import gregtech.client.renderer.handler.MetaTileEntityRenderer;
import gregtech.client.renderer.handler.MetaTileEntityTESR;
import gregtech.client.renderer.pipe.CableRenderer;
import gregtech.client.renderer.pipe.FluidPipeRenderer;
import gregtech.client.renderer.pipe.ItemPipeRenderer;
import gregtech.common.blocks.BlockAsphalt;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockBrittleCharcoal;
import gregtech.common.blocks.BlockCleanroomCasing;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockGregStairs;
import gregtech.common.blocks.BlockHermeticCasing;
import gregtech.common.blocks.BlockLamp;
import gregtech.common.blocks.BlockLampBorderless;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockOre;
import gregtech.common.blocks.BlockSteamCasing;
import gregtech.common.blocks.BlockSurfaceRock;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.BlockWarningSign;
import gregtech.common.blocks.BlockWarningSign1;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.StoneVariantBlock;
import gregtech.common.blocks.foam.BlockFoam;
import gregtech.common.blocks.foam.BlockPetrifiedFoam;
import gregtech.common.blocks.wood.BlockGregFence;
import gregtech.common.blocks.wood.BlockGregFenceGate;
import gregtech.common.blocks.wood.BlockGregPlanks;
import gregtech.common.blocks.wood.BlockGregWoodSlab;
import gregtech.common.blocks.wood.BlockRubberDoor;
import gregtech.common.blocks.wood.BlockRubberLeaves;
import gregtech.common.blocks.wood.BlockRubberLog;
import gregtech.common.blocks.wood.BlockRubberSapling;
import gregtech.common.blocks.wood.BlockWoodenDoor;
import gregtech.common.items.MetaItems;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import gregtech.common.pipelike.cable.tile.TileEntityCableTickable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipeTickable;
import gregtech.common.pipelike.itempipe.BlockItemPipe;
import gregtech.common.pipelike.itempipe.ItemPipeType;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipe;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipeTickable;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetaBlocks {
    public static BlockMachine MACHINE;
    public static final BlockCable[] CABLES;
    public static final BlockFluidPipe[] FLUID_PIPES;
    public static final BlockItemPipe[] ITEM_PIPES;
    public static BlockBoilerCasing BOILER_CASING;
    public static BlockFireboxCasing BOILER_FIREBOX_CASING;
    public static BlockMetalCasing METAL_CASING;
    public static BlockTurbineCasing TURBINE_CASING;
    public static BlockMachineCasing MACHINE_CASING;
    public static BlockSteamCasing STEAM_CASING;
    public static BlockMultiblockCasing MULTIBLOCK_CASING;
    public static BlockGlassCasing TRANSPARENT_CASING;
    public static BlockWireCoil WIRE_COIL;
    public static BlockFusionCasing FUSION_CASING;
    public static BlockWarningSign WARNING_SIGN;
    public static BlockWarningSign1 WARNING_SIGN_1;
    public static BlockHermeticCasing HERMETIC_CASING;
    public static BlockCleanroomCasing CLEANROOM_CASING;
    public static final EnumMap<EnumDyeColor, BlockLamp> LAMPS;
    public static final EnumMap<EnumDyeColor, BlockLamp> BORDERLESS_LAMPS;
    public static BlockAsphalt ASPHALT;
    public static final EnumMap<StoneVariantBlock.StoneVariant, StoneVariantBlock> STONE_BLOCKS;
    public static BlockFoam FOAM;
    public static BlockFoam REINFORCED_FOAM;
    public static BlockPetrifiedFoam PETRIFIED_FOAM;
    public static BlockPetrifiedFoam REINFORCED_PETRIFIED_FOAM;
    public static BlockRubberLog RUBBER_LOG;
    public static BlockRubberLeaves RUBBER_LEAVES;
    public static BlockRubberSapling RUBBER_SAPLING;
    public static BlockGregPlanks PLANKS;
    public static BlockGregWoodSlab WOOD_SLAB;
    public static BlockGregWoodSlab DOUBLE_WOOD_SLAB;
    public static BlockStairs RUBBER_WOOD_STAIRS;
    public static BlockStairs TREATED_WOOD_STAIRS;
    public static BlockFence RUBBER_WOOD_FENCE;
    public static BlockFence TREATED_WOOD_FENCE;
    public static BlockFenceGate RUBBER_WOOD_FENCE_GATE;
    public static BlockFenceGate TREATED_WOOD_FENCE_GATE;
    public static BlockWoodenDoor RUBBER_WOOD_DOOR;
    public static BlockWoodenDoor TREATED_WOOD_DOOR;
    public static BlockBrittleCharcoal BRITTLE_CHARCOAL;
    public static final Map<Material, BlockCompressed> COMPRESSED;
    public static final Map<Material, BlockFrame> FRAMES;
    public static final Collection<BlockOre> ORES;
    public static final Map<Material, BlockSurfaceRock> SURFACE_ROCK;
    public static final Collection<BlockFluidBase> FLUID_BLOCKS;

    private MetaBlocks() {
    }

    public static void init() {
        GregTechAPI.MACHINE = MACHINE = new BlockMachine();
        MACHINE.setRegistryName("machine");
        for (Insulation insulation : Insulation.values()) {
            MetaBlocks.CABLES[insulation.ordinal()] = new BlockCable(insulation);
            CABLES[insulation.ordinal()].setRegistryName(insulation.func_176610_l());
        }
        for (Enum enum_ : FluidPipeType.values()) {
            MetaBlocks.FLUID_PIPES[enum_.ordinal()] = new BlockFluidPipe((FluidPipeType)enum_);
            FLUID_PIPES[enum_.ordinal()].setRegistryName(String.format("fluid_pipe_%s", ((FluidPipeType)enum_).name));
        }
        for (Enum enum_ : ItemPipeType.values()) {
            MetaBlocks.ITEM_PIPES[enum_.ordinal()] = new BlockItemPipe((ItemPipeType)enum_);
            ITEM_PIPES[enum_.ordinal()].setRegistryName(String.format("item_pipe_%s", ((ItemPipeType)enum_).name));
        }
        BOILER_CASING = new BlockBoilerCasing();
        BOILER_CASING.setRegistryName("boiler_casing");
        BOILER_FIREBOX_CASING = new BlockFireboxCasing();
        BOILER_FIREBOX_CASING.setRegistryName("boiler_firebox_casing");
        METAL_CASING = new BlockMetalCasing();
        METAL_CASING.setRegistryName("metal_casing");
        TURBINE_CASING = new BlockTurbineCasing();
        TURBINE_CASING.setRegistryName("turbine_casing");
        MACHINE_CASING = new BlockMachineCasing();
        MACHINE_CASING.setRegistryName("machine_casing");
        STEAM_CASING = new BlockSteamCasing();
        STEAM_CASING.setRegistryName("steam_casing");
        MULTIBLOCK_CASING = new BlockMultiblockCasing();
        MULTIBLOCK_CASING.setRegistryName("multiblock_casing");
        TRANSPARENT_CASING = new BlockGlassCasing();
        TRANSPARENT_CASING.setRegistryName("transparent_casing");
        WIRE_COIL = new BlockWireCoil();
        WIRE_COIL.setRegistryName("wire_coil");
        FUSION_CASING = new BlockFusionCasing();
        FUSION_CASING.setRegistryName("fusion_casing");
        WARNING_SIGN = new BlockWarningSign();
        WARNING_SIGN.setRegistryName("warning_sign");
        WARNING_SIGN_1 = new BlockWarningSign1();
        WARNING_SIGN_1.setRegistryName("warning_sign_1");
        HERMETIC_CASING = new BlockHermeticCasing();
        HERMETIC_CASING.setRegistryName("hermetic_casing");
        CLEANROOM_CASING = new BlockCleanroomCasing();
        CLEANROOM_CASING.setRegistryName("cleanroom_casing");
        for (Enum enum_ : EnumDyeColor.values()) {
            BlockLamp block = new BlockLamp((EnumDyeColor)enum_);
            block.setRegistryName(enum_.func_176610_l() + "_lamp");
            block.func_149663_c("gregtech_lamp." + enum_.func_176610_l());
            LAMPS.put((EnumDyeColor)enum_, block);
            block = new BlockLampBorderless((EnumDyeColor)enum_);
            block.setRegistryName("borderless_" + enum_.func_176610_l() + "_lamp");
            block.func_149663_c("gregtech_lamp_borderless." + enum_.func_176610_l());
            BORDERLESS_LAMPS.put((EnumDyeColor)enum_, block);
        }
        ASPHALT = new BlockAsphalt();
        ASPHALT.setRegistryName("asphalt");
        for (Enum enum_ : StoneVariantBlock.StoneVariant.values()) {
            STONE_BLOCKS.put((StoneVariantBlock.StoneVariant)enum_, new StoneVariantBlock((StoneVariantBlock.StoneVariant)enum_));
        }
        FOAM = new BlockFoam(false);
        FOAM.setRegistryName("foam");
        REINFORCED_FOAM = new BlockFoam(true);
        REINFORCED_FOAM.setRegistryName("reinforced_foam");
        PETRIFIED_FOAM = new BlockPetrifiedFoam(false);
        PETRIFIED_FOAM.setRegistryName("petrified_foam");
        REINFORCED_PETRIFIED_FOAM = new BlockPetrifiedFoam(true);
        REINFORCED_PETRIFIED_FOAM.setRegistryName("reinforced_petrified_foam");
        RUBBER_LOG = new BlockRubberLog();
        RUBBER_LOG.setRegistryName("rubber_log");
        RUBBER_LEAVES = new BlockRubberLeaves();
        RUBBER_LEAVES.setRegistryName("rubber_leaves");
        RUBBER_SAPLING = new BlockRubberSapling();
        RUBBER_SAPLING.setRegistryName("rubber_sapling");
        PLANKS = new BlockGregPlanks();
        PLANKS.setRegistryName("planks");
        WOOD_SLAB = new BlockGregWoodSlab.Half();
        WOOD_SLAB.setRegistryName("wood_slab");
        DOUBLE_WOOD_SLAB = new BlockGregWoodSlab.Double();
        DOUBLE_WOOD_SLAB.setRegistryName("double_wood_slab");
        RUBBER_WOOD_STAIRS = new BlockGregStairs(PLANKS.getState(BlockGregPlanks.BlockType.RUBBER_PLANK));
        ((Block)RUBBER_WOOD_STAIRS.setRegistryName("rubber_wood_stairs")).func_149663_c("rubber_wood_stairs");
        TREATED_WOOD_STAIRS = new BlockGregStairs(PLANKS.getState(BlockGregPlanks.BlockType.TREATED_PLANK));
        ((Block)TREATED_WOOD_STAIRS.setRegistryName("treated_wood_stairs")).func_149663_c("treated_wood_stairs");
        RUBBER_WOOD_FENCE = new BlockGregFence();
        ((Block)RUBBER_WOOD_FENCE.setRegistryName("rubber_wood_fence")).func_149663_c("rubber_wood_fence");
        TREATED_WOOD_FENCE = new BlockGregFence();
        ((Block)TREATED_WOOD_FENCE.setRegistryName("treated_wood_fence")).func_149663_c("treated_wood_fence");
        RUBBER_WOOD_FENCE_GATE = new BlockGregFenceGate();
        ((Block)RUBBER_WOOD_FENCE_GATE.setRegistryName("rubber_wood_fence_gate")).func_149663_c("rubber_wood_fence_gate");
        TREATED_WOOD_FENCE_GATE = new BlockGregFenceGate();
        ((Block)TREATED_WOOD_FENCE_GATE.setRegistryName("treated_wood_fence_gate")).func_149663_c("treated_wood_fence_gate");
        RUBBER_WOOD_DOOR = new BlockRubberDoor(() -> MetaItems.RUBBER_WOOD_DOOR.getStackForm());
        ((Block)RUBBER_WOOD_DOOR.setRegistryName("rubber_wood_door")).func_149663_c("rubber_wood_door");
        TREATED_WOOD_DOOR = new BlockWoodenDoor(() -> MetaItems.TREATED_WOOD_DOOR.getStackForm());
        ((Block)TREATED_WOOD_DOOR.setRegistryName("treated_wood_door")).func_149663_c("treated_wood_door");
        BRITTLE_CHARCOAL = new BlockBrittleCharcoal();
        BRITTLE_CHARCOAL.setRegistryName("brittle_charcoal");
        MetaBlocks.createGeneratedBlock(m -> m.hasProperty(PropertyKey.DUST) && m.hasFlag(MaterialFlags.GENERATE_FRAME), MetaBlocks::createFrameBlock);
        MetaBlocks.createGeneratedBlock(m -> m.hasProperty(PropertyKey.ORE) && m.hasProperty(PropertyKey.DUST), MetaBlocks::createSurfaceRockBlock);
        MetaBlocks.createGeneratedBlock(material -> (material.hasProperty(PropertyKey.INGOT) || material.hasProperty(PropertyKey.GEM) || material.hasFlag(MaterialFlags.FORCE_GENERATE_BLOCK)) && !OrePrefix.block.isIgnored((Material)material), MetaBlocks::createCompressedBlock);
        MetaBlocks.registerTileEntity();
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_LOG, 5, 5);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_LEAVES, 30, 60);
        Blocks.field_150480_ab.func_180686_a((Block)PLANKS, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)WOOD_SLAB, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)DOUBLE_WOOD_SLAB, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_WOOD_STAIRS, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)TREATED_WOOD_STAIRS, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_WOOD_FENCE, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)TREATED_WOOD_FENCE, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_WOOD_FENCE_GATE, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)TREATED_WOOD_FENCE_GATE, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_WOOD_DOOR, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)TREATED_WOOD_DOOR, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)BRITTLE_CHARCOAL, 5, 5);
    }

    protected static void createGeneratedBlock(Predicate<Material> materialPredicate, BiConsumer<Material[], Integer> blockGenerator) {
        TreeMap<Integer, Object[]> blocksToGenerate = new TreeMap<Integer, Object[]>();
        Iterator iterator = GregTechAPI.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            Material material = (Material)iterator.next();
            if (!materialPredicate.test(material)) continue;
            int id = material.getId();
            int metaBlockID = id / 16;
            int subBlockID = id % 16;
            if (!blocksToGenerate.containsKey(metaBlockID)) {
                Object[] materials = new Material[16];
                Arrays.fill(materials, Materials.NULL);
                blocksToGenerate.put(metaBlockID, materials);
            }
            ((Material[])blocksToGenerate.get((Object)Integer.valueOf((int)metaBlockID)))[subBlockID] = material;
        }
        blocksToGenerate.forEach((key, value) -> blockGenerator.accept((Material[])value, (Integer)key));
    }

    private static void createCompressedBlock(Material[] materials, int index) {
        BlockCompressed block = new BlockCompressed(materials);
        block.setRegistryName("meta_block_compressed_" + index);
        for (Material material : materials) {
            COMPRESSED.put(material, block);
        }
    }

    private static void createFrameBlock(Material[] materials, int index) {
        BlockFrame block = new BlockFrame(materials);
        block.setRegistryName("meta_block_frame_" + index);
        for (Material m : materials) {
            FRAMES.put(m, block);
        }
    }

    private static void createSurfaceRockBlock(Material[] materials, int index) {
        BlockSurfaceRock block = new BlockSurfaceRock(materials);
        block.setRegistryName("meta_block_surface_rock_" + index);
        for (Material material : materials) {
            SURFACE_ROCK.put(material, block);
        }
    }

    public static void registerTileEntity() {
        GameRegistry.registerTileEntity(MetaTileEntityHolder.class, (ResourceLocation)new ResourceLocation("gregtech", "machine"));
        GameRegistry.registerTileEntity(TileEntityCable.class, (ResourceLocation)new ResourceLocation("gregtech", "cable"));
        GameRegistry.registerTileEntity(TileEntityCableTickable.class, (ResourceLocation)new ResourceLocation("gregtech", "cable_tickable"));
        GameRegistry.registerTileEntity(TileEntityFluidPipe.class, (ResourceLocation)new ResourceLocation("gregtech", "fluid_pipe"));
        GameRegistry.registerTileEntity(TileEntityItemPipe.class, (ResourceLocation)new ResourceLocation("gregtech", "item_pipe"));
        GameRegistry.registerTileEntity(TileEntityFluidPipeTickable.class, (ResourceLocation)new ResourceLocation("gregtech", "fluid_pipe_active"));
        GameRegistry.registerTileEntity(TileEntityItemPipeTickable.class, (ResourceLocation)new ResourceLocation("gregtech", "item_pipe_active"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModels() {
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MACHINE), stack -> MetaTileEntityRenderer.MODEL_LOCATION);
        for (BlockCable blockCable : CABLES) {
            ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)blockCable), stack -> CableRenderer.INSTANCE.getModelLocation());
        }
        for (BlockMaterialPipe blockMaterialPipe : FLUID_PIPES) {
            ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)blockMaterialPipe), stack -> FluidPipeRenderer.INSTANCE.getModelLocation());
        }
        for (BlockMaterialPipe blockMaterialPipe : ITEM_PIPES) {
            ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)blockMaterialPipe), stack -> ItemPipeRenderer.INSTANCE.getModelLocation());
        }
        MetaBlocks.registerItemModel(BOILER_CASING);
        MetaBlocks.registerItemModel(METAL_CASING);
        MetaBlocks.registerItemModel(TURBINE_CASING);
        MetaBlocks.registerItemModel(MACHINE_CASING);
        MetaBlocks.registerItemModel(STEAM_CASING);
        MetaBlocks.registerItemModel(WARNING_SIGN);
        MetaBlocks.registerItemModel(WARNING_SIGN_1);
        MetaBlocks.registerItemModel(HERMETIC_CASING);
        MetaBlocks.registerItemModel(CLEANROOM_CASING);
        MetaBlocks.registerItemModel(ASPHALT);
        for (StoneVariantBlock block : STONE_BLOCKS.values()) {
            MetaBlocks.registerItemModel(block);
        }
        MetaBlocks.registerItemModelWithOverride((Block)RUBBER_LOG, ImmutableMap.of((Object)BlockLog.field_176299_a, (Object)BlockLog.EnumAxis.Y));
        MetaBlocks.registerItemModel((Block)RUBBER_LEAVES);
        MetaBlocks.registerItemModel((Block)RUBBER_SAPLING);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)RUBBER_SAPLING), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(RUBBER_SAPLING.getRegistryName()), "inventory"));
        MetaBlocks.registerItemModel(PLANKS);
        MetaBlocks.registerItemModelWithOverride((Block)WOOD_SLAB, ImmutableMap.of((Object)BlockSlab.field_176554_a, (Object)BlockSlab.EnumBlockHalf.BOTTOM));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)RUBBER_WOOD_STAIRS), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(RUBBER_WOOD_STAIRS.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)TREATED_WOOD_STAIRS), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(TREATED_WOOD_STAIRS.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)RUBBER_WOOD_FENCE), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(RUBBER_WOOD_FENCE.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)TREATED_WOOD_FENCE), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(TREATED_WOOD_FENCE.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)RUBBER_WOOD_FENCE_GATE), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(RUBBER_WOOD_FENCE_GATE.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)TREATED_WOOD_FENCE_GATE), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(TREATED_WOOD_FENCE_GATE.getRegistryName()), "inventory"));
        MetaBlocks.registerItemModel(BRITTLE_CHARCOAL);
        BOILER_FIREBOX_CASING.onModelRegister();
        WIRE_COIL.onModelRegister();
        FUSION_CASING.onModelRegister();
        MULTIBLOCK_CASING.onModelRegister();
        TRANSPARENT_CASING.onModelRegister();
        for (BlockLamp lamp : LAMPS.values()) {
            lamp.onModelRegister();
        }
        for (BlockLamp lamp : BORDERLESS_LAMPS.values()) {
            lamp.onModelRegister();
        }
        COMPRESSED.values().stream().distinct().forEach(BlockCompressed::onModelRegister);
        FRAMES.values().stream().distinct().forEach(BlockFrame::onModelRegister);
        ORES.forEach(BlockOre::onModelRegister);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModel(Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), MetaBlocks.statePropertiesToString(state.func_177228_b())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModelWithOverride(Block block, Map<IProperty<?>, Comparable<?>> stateOverrides) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            HashMap stringProperties = new HashMap((Map<IProperty<?>, Comparable<?>>)state.func_177228_b());
            stringProperties.putAll(stateOverrides);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), MetaBlocks.statePropertiesToString(stringProperties)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerStateMappers() {
        ModelLoader.setCustomStateMapper((Block)MACHINE, (IStateMapper)new SimpleStateMapper(MetaTileEntityRenderer.MODEL_LOCATION));
        SimpleStateMapper normalStateMapper = new SimpleStateMapper(CableRenderer.INSTANCE.getModelLocation());
        for (BlockCable blockCable : CABLES) {
            ModelLoader.setCustomStateMapper((Block)blockCable, (IStateMapper)normalStateMapper);
        }
        normalStateMapper = new SimpleStateMapper(FluidPipeRenderer.INSTANCE.getModelLocation());
        for (BlockMaterialPipe blockMaterialPipe : FLUID_PIPES) {
            ModelLoader.setCustomStateMapper((Block)blockMaterialPipe, (IStateMapper)normalStateMapper);
        }
        normalStateMapper = new SimpleStateMapper(ItemPipeRenderer.INSTANCE.getModelLocation());
        for (BlockMaterialPipe blockMaterialPipe : ITEM_PIPES) {
            ModelLoader.setCustomStateMapper((Block)blockMaterialPipe, (IStateMapper)normalStateMapper);
        }
        normalStateMapper = new SimpleStateMapper(BlockSurfaceRock.MODEL_LOCATION);
        for (BlockSurfaceRock surfaceRock : new HashSet<BlockSurfaceRock>(SURFACE_ROCK.values())) {
            ModelLoader.setCustomStateMapper((Block)surfaceRock, (IStateMapper)normalStateMapper);
        }
        normalStateMapper = new StateMapperBase(){

            @Nonnull
            protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
                return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), "normal");
            }
        };
        ModelLoader.setCustomStateMapper((Block)FOAM, (IStateMapper)normalStateMapper);
        ModelLoader.setCustomStateMapper((Block)REINFORCED_FOAM, (IStateMapper)normalStateMapper);
        ModelLoader.setCustomStateMapper((Block)PETRIFIED_FOAM, (IStateMapper)normalStateMapper);
        ModelLoader.setCustomStateMapper((Block)REINFORCED_PETRIFIED_FOAM, (IStateMapper)normalStateMapper);
        BakedModelHandler modelHandler = new BakedModelHandler();
        MinecraftForge.EVENT_BUS.register((Object)modelHandler);
        FLUID_BLOCKS.forEach(modelHandler::addFluidBlock);
        ClientRegistry.bindTileEntitySpecialRenderer(MetaTileEntityHolder.class, (TileEntitySpecialRenderer)new MetaTileEntityTESR());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerColors() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.FOAM_BLOCK_COLOR, new Block[]{FOAM, REINFORCED_FOAM, PETRIFIED_FOAM, REINFORCED_PETRIFIED_FOAM});
        Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.RUBBER_LEAVES_BLOCK_COLOR, new Block[]{RUBBER_LEAVES});
        Minecraft.func_71410_x().getItemColors().func_186731_a(ClientProxy.RUBBER_LEAVES_ITEM_COLOR, new Block[]{RUBBER_LEAVES});
        COMPRESSED.values().stream().distinct().forEach(block -> {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.COMPRESSED_BLOCK_COLOR, new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_186731_a(ClientProxy.COMPRESSED_ITEM_COLOR, new Block[]{block});
        });
        FRAMES.values().forEach(block -> {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.FRAME_BLOCK_COLOR, new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_186731_a(ClientProxy.FRAME_ITEM_COLOR, new Block[]{block});
        });
        SURFACE_ROCK.values().stream().distinct().forEach(block -> Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.SURFACE_ROCK_BLOCK_COLOR, new Block[]{block}));
        ORES.stream().distinct().forEach(block -> {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.ORE_BLOCK_COLOR, new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_186731_a(ClientProxy.ORE_ITEM_COLOR, new Block[]{block});
        });
        Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.MACHINE_CASING_BLOCK_COLOR, new Block[]{MACHINE_CASING});
        Minecraft.func_71410_x().getItemColors().func_186731_a(ClientProxy.MACHINE_CASING_ITEM_COLOR, new Block[]{MACHINE_CASING});
        Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.MACHINE_CASING_BLOCK_COLOR, new Block[]{HERMETIC_CASING});
        Minecraft.func_71410_x().getItemColors().func_186731_a(ClientProxy.MACHINE_CASING_ITEM_COLOR, new Block[]{HERMETIC_CASING});
    }

    public static void registerOreDict() {
        ItemStack itemStack;
        ItemStack itemStack2;
        DelayedStateBlock block;
        Material material;
        OreDictUnifier.registerOre(new ItemStack((Block)RUBBER_LEAVES), "treeLeaves");
        OreDictUnifier.registerOre(new ItemStack((Block)RUBBER_SAPLING), "treeSapling");
        for (BlockLamp blockLamp : LAMPS.values()) {
            blockLamp.registerOreDict();
        }
        for (BlockLamp blockLamp : BORDERLESS_LAMPS.values()) {
            blockLamp.registerOreDict();
        }
        for (Map.Entry entry : COMPRESSED.entrySet()) {
            material = (Material)entry.getKey();
            block = (BlockCompressed)((Object)entry.getValue());
            itemStack2 = ((BlockCompressed)block).getItem(material);
            OreDictUnifier.registerOre(itemStack2, OrePrefix.block, material);
        }
        for (Map.Entry entry : FRAMES.entrySet()) {
            material = (Material)entry.getKey();
            block = (BlockFrame)((Object)entry.getValue());
            itemStack2 = ((BlockFrame)block).getItem(material);
            OreDictUnifier.registerOre(itemStack2, OrePrefix.frameGt, material);
        }
        for (BlockOre blockOre : ORES) {
            material = blockOre.field_149764_J;
            for (StoneType stoneType : blockOre.STONE_TYPE.getAllowedValues()) {
                if (stoneType == null) continue;
                ItemStack normalStack = BlockOre.getItem(blockOre.func_176223_P().func_177226_a((IProperty)blockOre.STONE_TYPE, (Comparable)stoneType));
                OreDictUnifier.registerOre(normalStack, stoneType.processingPrefix, material);
            }
        }
        for (Iterator<Object> cable : CABLES) {
            for (Material pipeMaterial : ((BlockCable)((Object)cable)).getEnabledMaterials()) {
                itemStack = ((BlockMaterialPipe)((Object)cable)).getItem(pipeMaterial);
                OreDictUnifier.registerOre(itemStack, ((BlockMaterialPipe)((Object)cable)).getPrefix(), pipeMaterial);
            }
        }
        for (Iterator<Object> pipe : FLUID_PIPES) {
            for (Material pipeMaterial : ((BlockFluidPipe)((Object)pipe)).getEnabledMaterials()) {
                itemStack = ((BlockMaterialPipe)((Object)pipe)).getItem(pipeMaterial);
                OreDictUnifier.registerOre(itemStack, ((BlockMaterialPipe)((Object)pipe)).getPrefix(), pipeMaterial);
            }
        }
        for (Iterator<Object> pipe : ITEM_PIPES) {
            for (Material pipeMaterial : ((BlockItemPipe)((Object)pipe)).getEnabledMaterials()) {
                itemStack = ((BlockMaterialPipe)((Object)pipe)).getItem(pipeMaterial);
                OreDictUnifier.registerOre(itemStack, ((BlockMaterialPipe)((Object)pipe)).getPrefix(), pipeMaterial);
            }
        }
    }

    public static String statePropertiesToString(Map<IProperty<?>, Comparable<?>> properties) {
        StringBuilder stringbuilder = new StringBuilder();
        List entries = properties.entrySet().stream().sorted(Comparator.comparing(c -> ((IProperty)c.getKey()).func_177701_a())).collect(Collectors.toList());
        for (Map.Entry entry : entries) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty property = (IProperty)entry.getKey();
            stringbuilder.append(property.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(MetaBlocks.getPropertyName(property, (Comparable)entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    static {
        CABLES = new BlockCable[10];
        FLUID_PIPES = new BlockFluidPipe[7];
        ITEM_PIPES = new BlockItemPipe[8];
        LAMPS = new EnumMap(EnumDyeColor.class);
        BORDERLESS_LAMPS = new EnumMap(EnumDyeColor.class);
        STONE_BLOCKS = new EnumMap(StoneVariantBlock.StoneVariant.class);
        COMPRESSED = new HashMap<Material, BlockCompressed>();
        FRAMES = new HashMap<Material, BlockFrame>();
        ORES = new ReferenceArrayList();
        SURFACE_ROCK = new HashMap<Material, BlockSurfaceRock>();
        FLUID_BLOCKS = new ReferenceArrayList();
    }
}

