/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.block.VariantBlock;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.blocks.MetaBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class StoneVariantBlock
extends VariantBlock<StoneType> {
    private static final PropertyEnum<StoneType> PROPERTY = PropertyEnum.func_177709_a((String)"variant", StoneType.class);
    private final StoneVariant stoneVariant;

    public StoneVariantBlock(@Nonnull StoneVariant stoneVariant) {
        super(Material.field_151576_e);
        this.stoneVariant = stoneVariant;
        this.setRegistryName(stoneVariant.id);
        this.func_149663_c(stoneVariant.translationKey);
        this.func_149711_c(stoneVariant.hardness);
        this.func_149752_b(stoneVariant.resistance);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.getState(StoneType.BLACK_GRANITE));
        this.func_149647_a(GregTechAPI.TAB_GREGTECH_DECORATIONS);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        this.VARIANT = PROPERTY;
        this.VALUES = StoneType.values();
        return new BlockStateContainer((Block)this, new IProperty[]{this.VARIANT});
    }

    public boolean canCreatureSpawn(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public double getWalkingSpeedBonus() {
        return 1.6;
    }

    @Override
    public boolean checkApplicableBlocks(@Nonnull IBlockState state) {
        return state == this.getState(StoneType.CONCRETE_DARK) || state == this.getState(StoneType.CONCRETE_LIGHT);
    }

    protected boolean func_149700_E() {
        return this.stoneVariant == StoneVariant.SMOOTH;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)(this.stoneVariant == StoneVariant.SMOOTH ? (Block)MetaBlocks.STONE_BLOCKS.get((Object)StoneVariant.COBBLE) : this));
    }

    public static enum StoneVariant {
        SMOOTH("stone_smooth"),
        COBBLE("stone_cobble", 2.0f, 10.0f),
        COBBLE_MOSSY("stone_cobble_mossy", 2.0f, 10.0f),
        POLISHED("stone_polished"),
        BRICKS("stone_bricks"),
        BRICKS_CRACKED("stone_bricks_cracked"),
        BRICKS_MOSSY("stone_bricks_mossy"),
        CHISELED("stone_chiseled"),
        TILED("stone_tiled"),
        TILED_SMALL("stone_tiled_small"),
        BRICKS_SMALL("stone_bricks_small"),
        WINDMILL_A("stone_windmill_a", "stone_bricks_windmill_a"),
        WINDMILL_B("stone_windmill_b", "stone_bricks_windmill_b"),
        BRICKS_SQUARE("stone_bricks_square");

        public final String id;
        public final String translationKey;
        public final float hardness;
        public final float resistance;

        private StoneVariant(String id) {
            this(id, id);
        }

        private StoneVariant(String id, String translationKey) {
            this(id, translationKey, 1.5f, 10.0f);
        }

        private StoneVariant(String id, float hardness, float resistance) {
            this(id, id, hardness, resistance);
        }

        private StoneVariant(String id, String translationKey, float hardness, float resistance) {
            this.id = id;
            this.translationKey = translationKey;
            this.hardness = hardness;
            this.resistance = resistance;
        }
    }

    public static enum StoneType implements IStringSerializable
    {
        BLACK_GRANITE("black_granite", MapColor.field_151646_E),
        RED_GRANITE("red_granite", MapColor.field_151645_D),
        MARBLE("marble", MapColor.field_151677_p),
        BASALT("basalt", MapColor.field_193560_ab),
        CONCRETE_LIGHT("concrete_light", MapColor.field_151665_m),
        CONCRETE_DARK("concrete_dark", MapColor.field_151665_m);

        private final String name;
        public final MapColor mapColor;

        private StoneType(String name, MapColor mapColor) {
            this.name = name;
            this.mapColor = mapColor;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public OrePrefix getOrePrefix() {
            switch (this) {
                case BLACK_GRANITE: 
                case RED_GRANITE: 
                case MARBLE: 
                case BASALT: {
                    return OrePrefix.stone;
                }
                case CONCRETE_LIGHT: 
                case CONCRETE_DARK: {
                    return OrePrefix.block;
                }
            }
            throw new IllegalStateException("Unreachable");
        }

        public gregtech.api.unification.material.Material getMaterial() {
            switch (this) {
                case BLACK_GRANITE: {
                    return Materials.GraniteBlack;
                }
                case RED_GRANITE: {
                    return Materials.GraniteRed;
                }
                case MARBLE: {
                    return Materials.Marble;
                }
                case BASALT: {
                    return Materials.Basalt;
                }
                case CONCRETE_LIGHT: 
                case CONCRETE_DARK: {
                    return Materials.Concrete;
                }
            }
            throw new IllegalStateException("Unreachable");
        }
    }
}

